/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.identity.local;

import java.util.Collection;
import java.util.Map;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.identity.local.LocalAuthEntry;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

public class LocalIdentityService
implements IdentityService {
    private static final Logger log = Logger.getLogger(LocalIdentityService.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final Map<String, LocalAuthEntry> userDB = Util.makeHashMap();

    public LocalIdentityService() {
    }

    public LocalIdentityService(Collection<LocalAuthEntry> users) {
        for (LocalAuthEntry entry : users) {
            this.userDB.put(LocalIdentityService.getQualifiedUsername(entry), entry);
        }
    }

    @Override
    public Identity certify(String domain, String username, String password) throws IdentityServiceException {
        String qualifiedUsername = LocalIdentityService.getQualifiedUsername(domain, username);
        boolean userExists = this.userDB.containsKey(qualifiedUsername);
        if (INFO) {
            log.info((Object)("Looking up domain:user " + qualifiedUsername + ", in the database? " + userExists));
        }
        if (!userExists || !this.userDB.get(qualifiedUsername).getPassword().equals(password)) {
            String warning = "Password failed for user " + username + " in domain " + domain;
            log.warn((Object)warning);
            return new Identity();
        }
        Identity unsigned = new Identity(domain, username, this.userDB.get(qualifiedUsername).getAssertion());
        try {
            return XMLSignatureUtil.sign((Identity)unsigned);
        }
        catch (XMLSignatureException e) {
            throw new IdentityServiceException("Failed to sign identity", e);
        }
    }

    private static final String getQualifiedUsername(LocalAuthEntry authentry) {
        return LocalIdentityService.getQualifiedUsername(authentry.getDomain(), authentry.getUsername());
    }

    private static final String getQualifiedUsername(String domain, String username) {
        return domain.toLowerCase() + ":" + username.toLowerCase();
    }

    public static final Identity getUnsignedPublicIdentity() {
        return new Identity("public-domain", "public-user", "public-assertion");
    }
}

