/*
 * Decompiled with CFR 0.152.
 */
package org.spin.query.message.headers;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Interval;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Result")
@XmlRootElement
public final class Result {
    public static final Result Null = new Result();
    private final String description;
    private final CertID origin;
    private final Envelope payload;
    private final Interval executionTime;

    private Result() {
        this(null, null, null, null);
    }

    public Result(CertID origin, Envelope payload, Interval executionTime) {
        this(origin, null, payload, executionTime);
    }

    public Result(CertID origin, String description, Envelope payload, Interval executionTime) {
        this.origin = origin;
        this.description = description;
        this.payload = payload;
        this.executionTime = executionTime;
    }

    public static final Result of(Envelope payload, Interval executionTime) throws ConfigException {
        return Result.of(PKITool.getInstance().getMyCertID(), payload, executionTime);
    }

    public static final Result of(String payload, Interval executionTime) throws ConfigException {
        return Result.of(Envelope.unencrypted((String)payload), executionTime);
    }

    public static final Result of(CertID origin, Envelope payload, Interval executionTime) {
        return Result.of(origin, null, payload, executionTime);
    }

    public static final Result of(CertID origin, String description, Envelope payload, Interval executionTime) {
        return new Result(origin, description, payload, executionTime);
    }

    public static final Result of(CertID origin, String payload, Interval executionTime) {
        return Result.of(origin, null, payload, executionTime);
    }

    public static final Result of(CertID origin, String description, String payload, Interval executionTime) {
        return Result.of(origin, description, Envelope.unencrypted((String)payload), executionTime);
    }

    public final boolean isEncrypted() {
        return this.payload.getEncryptedFor() != null;
    }

    public final boolean isSigned() {
        return this.payload.isSigned();
    }

    public final Envelope getPayload() {
        return this.payload;
    }

    @Deprecated
    public final CertID getNodeID() {
        return this.getOrigin();
    }

    public final CertID getOrigin() {
        return this.origin;
    }

    public final String getDescription() {
        return this.description;
    }

    public Interval getExecutionTime() {
        return this.executionTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        if (this.origin == null ? other.origin != null : !this.origin.equals((Object)other.origin)) {
            return false;
        }
        return !(this.payload == null ? other.payload != null : !this.payload.equals((Object)other.payload));
    }
}

