/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.spin.tools.DynamicLoadingException;
import org.w3c.dom.Node;

public final class ClassTools {
    private static final Logger log = Logger.getLogger(ClassTools.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    private ClassTools() {
    }

    public static final <T> T createInstance(Class<T> clazz) throws DynamicLoadingException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + clazz.getName() + "':", e);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto) throws DynamicLoadingException {
        if (DEBUG) {
            log.debug((Object)("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'"));
        }
        try {
            return classToCastInto.cast(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, ClassLoader classLoader) throws DynamicLoadingException {
        if (DEBUG) {
            log.debug((Object)("Loading '" + className + "' via user-supplied ClassLoader, casting into '" + classToCastInto.getSimpleName() + "'"));
        }
        try {
            return classToCastInto.cast(classLoader.loadClass(className).newInstance());
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, Node config) throws DynamicLoadingException {
        return ClassTools.createInstance(className, classToCastInto, new Class[]{Node.class}, new Object[]{config});
    }

    public static final <T> T createInstance(Class<T> clazz, Class<?>[] constructorParamTypes, Object[] constructorParams) throws DynamicLoadingException {
        return ClassTools.createInstance(clazz.getName(), clazz, constructorParamTypes, constructorParams);
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, Class<?>[] constructorParamTypes, Object[] constructorParams) throws DynamicLoadingException {
        if (DEBUG) {
            log.debug((Object)("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'"));
        }
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(constructorParamTypes);
            return classToCastInto.cast(constructor.newInstance(constructorParams));
        }
        catch (Exception e) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e);
        }
    }

    public static final boolean allSamePackage(Class<?> ... classes) {
        if (classes == null || classes.length < 1) {
            return false;
        }
        if (classes.length == 1) {
            return true;
        }
        String packageName = classes[0].getPackage().getName();
        for (int i = 1; i < classes.length; ++i) {
            if (classes[i].getPackage().getName().equals(packageName)) continue;
            return false;
        }
        return true;
    }
}

