/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.spin.tools.XMLDataTypeException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NetworkTime", propOrder={"calendar"})
@XmlRootElement
public class NetworkTime {
    private static final Logger log = Logger.getLogger(NetworkTime.class);
    @XmlElement(required=true)
    @XmlSchemaType(name="dateTime")
    private XMLGregorianCalendar calendar;
    private static DatatypeFactory datatypeFactory;

    private static DatatypeFactory getDatatypeFactory() {
        try {
            if (datatypeFactory == null) {
                datatypeFactory = DatatypeFactory.newInstance();
            }
        }
        catch (DatatypeConfigurationException e) {
            log.error((Object)"Couldn't create DatatypeFactory.", (Throwable)e);
            throw new XMLDataTypeException(e);
        }
        return datatypeFactory;
    }

    public NetworkTime() {
        this(Calendar.getInstance());
    }

    public NetworkTime(Date date) {
        this(NetworkTime.makeXMLGregorianCalendar(date));
    }

    public NetworkTime(Calendar calendar) {
        this(NetworkTime.makeXMLGregorianCalendar(calendar));
    }

    public NetworkTime(NetworkTime other) {
        this(other.toCalendar());
    }

    public NetworkTime(String lexicalRepresentation) {
        this(NetworkTime.makeXMLGregorianCalendar(lexicalRepresentation));
    }

    public NetworkTime(XMLGregorianCalendar calendar) {
        this.calendar = calendar;
    }

    @Deprecated
    public NetworkTime(int addSeconds) {
        this();
        this.addSeconds(addSeconds);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkTime other = (NetworkTime)obj;
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }

    public boolean before(NetworkTime other) {
        return this.calendar.compare(other.calendar) == -1;
    }

    public boolean sameTime(NetworkTime other) {
        return this.calendar.compare(other.calendar) == 0;
    }

    public boolean after(NetworkTime other) {
        return this.calendar.compare(other.calendar) == 1;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        return this.calendar;
    }

    public Calendar toCalendar() {
        return this.calendar.toGregorianCalendar();
    }

    public void setXMLGregorianCalendar(XMLGregorianCalendar calendar) {
        this.calendar = calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = NetworkTime.makeXMLGregorianCalendar(calendar);
    }

    public String toString() {
        return this.calendar.toString();
    }

    public long toMilliSeconds() {
        return this.calendar.toGregorianCalendar().getTimeInMillis();
    }

    public NetworkTime addMilliseconds(long amount) {
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(amount));
        return this;
    }

    public NetworkTime addSeconds(long amount) {
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(amount * 1000L));
        return this;
    }

    public NetworkTime addMinutes(long amount) {
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(amount * 1000L * 60L));
        return this;
    }

    public NetworkTime addHours(int amount) {
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(amount * 1000 * 60 * 60));
        return this;
    }

    public NetworkTime addDays(int amount) {
        boolean isPositive = amount > 0;
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, 0, Math.abs(amount), 0, 0, 0));
        return this;
    }

    public NetworkTime addMonth(int amount) {
        return this.addMonths(amount);
    }

    public NetworkTime addMonths(int amount) {
        boolean isPositive = amount > 0;
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, 0, Math.abs(amount), 0, 0, 0, 0));
        return this;
    }

    public NetworkTime addYear(int amount) {
        return this.addYears(amount);
    }

    public NetworkTime addYears(int amount) {
        boolean isPositive = amount > 0;
        this.calendar.add(NetworkTime.getDatatypeFactory().newDuration(isPositive, Math.abs(amount), 0, 0, 0, 0, 0));
        return this;
    }

    public static final GregorianCalendar makeGregorianCalendar(XMLGregorianCalendar xmlCalendar) {
        if (xmlCalendar == null) {
            return null;
        }
        return xmlCalendar.toGregorianCalendar();
    }

    public static final GregorianCalendar makeGregorianCalendar(int daysOffset) {
        GregorianCalendar c = new GregorianCalendar();
        c.add(5, daysOffset);
        return c;
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(String lexicalRepresentation) {
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(lexicalRepresentation);
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(GregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(calendar);
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return NetworkTime.makeXMLGregorianCalendar(calendar.getTime());
    }

    public static final XMLGregorianCalendar makeXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return NetworkTime.getDatatypeFactory().newXMLGregorianCalendar(cal);
    }

    public static final Date toDate(XMLGregorianCalendar xmlGC) {
        if (xmlGC == null) {
            return null;
        }
        return xmlGC.toGregorianCalendar().getTime();
    }
}

