/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.spin.tools.Util;

public abstract class Optional<T>
implements Iterable<T> {
    private Optional() {
    }

    public static <T> Optional<T> of(T value) {
        if (value == null) {
            return Optional.none();
        }
        return Optional.some(value);
    }

    public static <T> Optional<T> none() {
        return None.Instance;
    }

    public static <T> Optional<T> some(T value) {
        return new Some<T>(value);
    }

    public abstract T get();

    public abstract T getOrElse(T var1);

    public abstract boolean isEmpty();

    public final boolean isPresent() {
        return !this.isEmpty();
    }

    public static final class None
    extends Optional<Object> {
        public static final None Instance = new None();

        private None() {
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("Can't get non-existent value");
        }

        @Override
        public Object getOrElse(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    public static final class Some<T>
    extends Optional<T> {
        private final T value;

        Some(T value) {
            Util.guardNotNull(value);
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.get();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.value).iterator();
        }

        public int hashCode() {
            int prime = 31;
            return 31 + (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Some other = (Some)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

