/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.Environment;

public abstract class SPINUnitTest
extends TestCase {
    protected final Logger log = Logger.getLogger(SPINUnitTest.class);
    protected final boolean DEBUG = this.log.isDebugEnabled();
    protected final boolean INFO = this.log.isInfoEnabled();
    private static volatile boolean log4jInitialized = false;
    private static final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        if (this.DEBUG) {
            this.log.debug((Object)"Setting up SPIN Unit Test");
        }
        lock.lock();
        try {
            SPINUnitTest.initLog4J();
            SPINUnitTest.switchToTestMode();
            SPINUnitTest.setDBDir();
        }
        finally {
            lock.unlock();
        }
    }

    private static void initLog4J() {
        if (!log4jInitialized) {
            ConfigTool.initLog4J();
            log4jInitialized = true;
        }
    }

    private static void switchToTestMode() {
        ConfigTool.onlyUseClassloader(true);
    }

    private static void setDBDir() {
        try {
            File cwd = new File("./target/db").getCanonicalFile();
            if (!cwd.equals(Environment.getDBDir())) {
                Environment.setDBDir(cwd);
            }
        }
        catch (Exception e) {
            System.err.println("Error setting DB path, this is bad, but we'll muddle on: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

