/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AgentConfig", namespace="http://spin.org/xml/res/agent")
@XmlRootElement(name="AgentConfig", namespace="http://spin.org/xml/res/agent")
public final class AgentConfig {
    public static final Float defaultPollingFrequency = Float.valueOf(1.0f);
    public static final Long defaultMaxWaitTime = 90000L;
    @XmlElement(name="rootAggregatorEndpoint", required=true)
    private EndpointConfig rootAggregatorEndpoint;
    @XmlElement(name="nodeConnectorEndpoint", required=true)
    private final EndpointConfig nodeConnectorEndpoint;
    @XmlElement(name="peerGroupToQuery", required=false)
    private final String peerGroupToQuery;
    @XmlElement(name="authEndpoint", required=false)
    private final EndpointConfig authEndpoint;
    @XmlElement(name="maxWaitTime", required=false)
    private final Long maxWaitTime;
    @XmlElement(name="pollingFrequency", required=false)
    private final Float pollingFrequency;
    public static final AgentConfig Default = new AgentConfig();

    public AgentConfig() {
        this(null, null, null, null, defaultMaxWaitTime, defaultPollingFrequency);
    }

    public AgentConfig(EndpointConfig rootAggregatorEndpoint, EndpointConfig nodeConnectorEndpoint, String peerGroupToQuery, EndpointConfig authEndpoint, Long maxWaitTime, Float pollingFrequency) {
        this.rootAggregatorEndpoint = rootAggregatorEndpoint;
        this.nodeConnectorEndpoint = nodeConnectorEndpoint;
        this.peerGroupToQuery = peerGroupToQuery;
        this.authEndpoint = authEndpoint;
        this.maxWaitTime = maxWaitTime == null ? defaultMaxWaitTime : maxWaitTime;
        this.pollingFrequency = pollingFrequency == null ? defaultPollingFrequency : pollingFrequency;
    }

    public static AgentConfig copyOf(AgentConfig other) {
        if (other == null) {
            return null;
        }
        return new AgentConfig(other.rootAggregatorEndpoint, other.nodeConnectorEndpoint, other.peerGroupToQuery, other.authEndpoint, other.maxWaitTime, other.pollingFrequency);
    }

    public boolean shouldUseRemoteCache() {
        return this.nodeConnectorEndpoint != null && this.nodeConnectorEndpoint.getEndpointType() != EndpointType.Local && this.nodeConnectorEndpoint.getAddress().length() > 0;
    }

    public EndpointConfig getRootAggregatorEndpoint() {
        return this.rootAggregatorEndpoint;
    }

    public AgentConfig withRootAggregatorEndpoint(EndpointConfig aggregator) {
        AgentConfig result = AgentConfig.copyOf(this);
        result.rootAggregatorEndpoint = aggregator;
        return result;
    }

    public String getPeerGroupToQuery() {
        return this.peerGroupToQuery;
    }

    public AgentConfig withPeerGroupToQuery(String newPeerGroupToQuery) {
        return new AgentConfig(this.rootAggregatorEndpoint, this.nodeConnectorEndpoint, newPeerGroupToQuery, this.authEndpoint, this.maxWaitTime, this.pollingFrequency);
    }

    public EndpointConfig getAuthEndpoint() {
        return this.authEndpoint;
    }

    public AgentConfig withAuthEndpoint(EndpointConfig newAuthEndpoint) {
        return new AgentConfig(this.rootAggregatorEndpoint, this.nodeConnectorEndpoint, this.peerGroupToQuery, newAuthEndpoint, this.maxWaitTime, this.pollingFrequency);
    }

    public final EndpointConfig getNodeConnectorEndpoint() {
        return this.nodeConnectorEndpoint;
    }

    public final AgentConfig withNodeConnectorEndpoint(EndpointConfig newEntryPoint) {
        return new AgentConfig(this.rootAggregatorEndpoint, newEntryPoint, this.peerGroupToQuery, this.authEndpoint, this.maxWaitTime, this.pollingFrequency);
    }

    public final long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public final AgentConfig withMaxWaitTime(long newMaxWaitTime) {
        return new AgentConfig(this.rootAggregatorEndpoint, this.nodeConnectorEndpoint, this.peerGroupToQuery, this.authEndpoint, newMaxWaitTime, this.pollingFrequency);
    }

    public final Float getPollingFrequency() {
        return this.pollingFrequency;
    }

    public final AgentConfig withPollingFrequency(Float newPollingFrequency) {
        AgentConfig.guardPollingFrequencyIsAllowedValue(newPollingFrequency);
        return new AgentConfig(this.rootAggregatorEndpoint, this.nodeConnectorEndpoint, this.peerGroupToQuery, this.authEndpoint, this.maxWaitTime, newPollingFrequency);
    }

    private static void guardPollingFrequencyIsAllowedValue(Float pollingFrequency) {
        if (pollingFrequency != null && pollingFrequency.floatValue() <= 0.0f) {
            throw new IllegalArgumentException("polling frequency must be > 0");
        }
    }

    public static AgentConfig makeMinimalAgentConfig(String peerGroupToQuery) {
        return AgentConfig.makeMinimalAgentConfig(peerGroupToQuery, null);
    }

    public static AgentConfig makeMinimalAgentConfig(String peerGroupToQuery, Long maxWaitTime) {
        AgentConfig result = new AgentConfig().withPeerGroupToQuery(peerGroupToQuery);
        if (maxWaitTime != null) {
            return result.withMaxWaitTime(maxWaitTime);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authEndpoint == null ? 0 : this.authEndpoint.hashCode());
        result = 31 * result + (this.maxWaitTime == null ? 0 : this.maxWaitTime.hashCode());
        result = 31 * result + (this.nodeConnectorEndpoint == null ? 0 : this.nodeConnectorEndpoint.hashCode());
        result = 31 * result + (this.peerGroupToQuery == null ? 0 : this.peerGroupToQuery.hashCode());
        result = 31 * result + (this.pollingFrequency == null ? 0 : this.pollingFrequency.hashCode());
        result = 31 * result + (this.rootAggregatorEndpoint == null ? 0 : this.rootAggregatorEndpoint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentConfig other = (AgentConfig)obj;
        if (this.authEndpoint == null ? other.authEndpoint != null : !this.authEndpoint.equals(other.authEndpoint)) {
            return false;
        }
        if (this.maxWaitTime == null ? other.maxWaitTime != null : !this.maxWaitTime.equals(other.maxWaitTime)) {
            return false;
        }
        if (this.nodeConnectorEndpoint == null ? other.nodeConnectorEndpoint != null : !this.nodeConnectorEndpoint.equals(other.nodeConnectorEndpoint)) {
            return false;
        }
        if (this.peerGroupToQuery == null ? other.peerGroupToQuery != null : !this.peerGroupToQuery.equals(other.peerGroupToQuery)) {
            return false;
        }
        if (this.pollingFrequency == null ? other.pollingFrequency != null : !this.pollingFrequency.equals(other.pollingFrequency)) {
            return false;
        }
        return !(this.rootAggregatorEndpoint == null ? other.rootAggregatorEndpoint != null : !this.rootAggregatorEndpoint.equals(other.rootAggregatorEndpoint));
    }

    public String toString() {
        return "AgentConfig [rootAggregatorEndpoint=" + this.rootAggregatorEndpoint + ", nodeConnectorEndpoint=" + this.nodeConnectorEndpoint + ", peerGroupToQuery=" + this.peerGroupToQuery + ", authEndpoint=" + this.authEndpoint + ", maxWaitTime=" + this.maxWaitTime + ", pollingFrequency=" + this.pollingFrequency + "]";
    }
}

