/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.spin.tools.FileUtils;
import org.spin.tools.JAXBUtils;
import org.spin.tools.RandomTool;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.Environment;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.config.ValidationException;

public final class ConfigTool {
    private static final Logger log = Logger.getLogger(ConfigTool.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final Object lock = new Object();
    private static volatile boolean onlyUseClassloader = false;
    private static final SecureRandom secureRandom = ConfigTool.makeSecureRandom();

    private ConfigTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onlyUseClassloader() {
        Object object = lock;
        synchronized (object) {
            return onlyUseClassloader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onlyUseClassloader(boolean shouldOnlyUseClassloader) {
        Object object = lock;
        synchronized (object) {
            onlyUseClassloader = shouldOnlyUseClassloader;
        }
    }

    public static final void initLog4J() {
        String log4JConfigFileName = "log4j.properties";
        try {
            PropertyConfigurator.configure((Properties)ConfigTool.getProperties(ConfigTool.getConfigFileStream("log4j.properties")));
        }
        catch (Exception e) {
            log.warn((Object)"'log4j.properties' not found");
        }
    }

    private static final boolean shouldUseClassloader(File desiredConfigFile) {
        return ConfigTool.onlyUseClassloader() || !desiredConfigFile.exists();
    }

    public static final InputStream getClasspathResource(String resourceName) {
        return ConfigTool.getClassLoader().getResourceAsStream(resourceName);
    }

    @Deprecated
    public static final URL getClasspathResourceAsURL(String resourceName) {
        return ConfigTool.getClassLoader().getResource(resourceName);
    }

    public static final URI getClasspathResourceAsURI(String resourceName) throws ConfigException {
        URL resourceURL = ConfigTool.getClassLoader().getResource(resourceName);
        if (resourceURL == null) {
            return null;
        }
        try {
            return resourceURL.toURI();
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Couldn't get a classpath URI for resource '" + resourceName + "'", e);
        }
    }

    private static final ClassLoader getClassLoader() {
        return ConfigTool.class.getClassLoader();
    }

    public static final URI getConfigFileAsURI(String desiredFileName) throws ConfigException {
        File desiredFile = ConfigTool.getConfigFile(desiredFileName);
        if (ConfigTool.shouldUseClassloader(desiredFile)) {
            URI result = ConfigTool.getClasspathResourceAsURI(desiredFileName);
            if (result == null) {
                throw new ConfigException(desiredFileName + " was not found on the classpath or file system.");
            }
            return result;
        }
        try {
            return desiredFile.toURI();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    @Deprecated
    public static final URL getConfigFileAsURL(String desiredFileName) throws ConfigException {
        File desiredFile = ConfigTool.getConfigFile(desiredFileName);
        if (ConfigTool.shouldUseClassloader(desiredFile)) {
            URL result = ConfigTool.getClasspathResourceAsURL(desiredFileName);
            if (result == null) {
                throw new ConfigException(desiredFileName + " was not found on the classpath or file system.");
            }
            return result;
        }
        try {
            return desiredFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new ConfigException(e);
        }
    }

    public static final String makeXMLFileName(Module module) {
        assert (module != null);
        return ConfigTool.makeXMLFileName(module.name());
    }

    private static final String makeXMLFileName(String module) {
        return module + ".xml";
    }

    public static File getConfigFile(Module moduleName) throws ConfigException {
        return ConfigTool.getConfigFile(ConfigTool.makeXMLFileName(moduleName.name()));
    }

    public static File getConfigFile(String filename) throws ConfigException {
        File rawFile = new File(filename);
        if (rawFile.isAbsolute()) {
            return rawFile;
        }
        return new File(Environment.getConfDir() + File.separator + filename);
    }

    public static File getConfigFileWithFailover(String filename) throws ConfigException {
        File file = ConfigTool.getConfigFile(filename);
        if (file.exists()) {
            if (DEBUG) {
                log.debug((Object)("Found " + filename + " absolute path= " + file.getAbsolutePath()));
            }
            return file;
        }
        URI classLoaderURI = ConfigTool.getConfigFileAsURI(filename);
        if (classLoaderURI != null) {
            if (DEBUG) {
                log.debug((Object)("Found " + filename + " classloaded path= " + classLoaderURI.getPath()));
            }
            try {
                return new File(classLoaderURI.toURL().getFile());
            }
            catch (MalformedURLException e) {
                throw new ConfigException(e);
            }
        }
        throw new ConfigException("Could not find " + filename + " on the filesystem or classpath ");
    }

    public static File getConfigFileFromClassloadedDir(String filename) throws ConfigException {
        String path;
        try {
            path = ConfigTool.getConfigFileAsURI(filename).toURL().getFile();
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Couldn't access file '" + filename + "'");
        }
        File result = new File(path);
        if (!result.exists()) {
            throw new ConfigException("File at '" + path + "' is not accessible via normal means.  Perhaps it's inside an archive?");
        }
        return result;
    }

    public static Reader getConfigFileReader(Module module) throws ConfigException {
        return ConfigTool.getConfigFileReader(module.name());
    }

    public static Reader getConfigFileReader(String moduleName) throws ConfigException {
        return new InputStreamReader(ConfigTool.getXMLConfigFileStream(moduleName));
    }

    public static InputStream getXMLConfigFileStream(String moduleName) throws ConfigException {
        if (INFO) {
            log.info((Object)("Loading from " + ConfigTool.getConfigFileAsURI(ConfigTool.makeXMLFileName(moduleName))));
        }
        return ConfigTool.getConfigFileStream(ConfigTool.makeXMLFileName(moduleName));
    }

    public static InputStream getConfigFileStream(File desiredFile) throws ConfigException {
        if (desiredFile.isAbsolute() && !ConfigTool.shouldUseClassloader(desiredFile)) {
            try {
                return new FileInputStream(desiredFile);
            }
            catch (FileNotFoundException e) {
                throw new ConfigException(e);
            }
        }
        return ConfigTool.getConfigFileStream(desiredFile.getName());
    }

    public static InputStream getConfigFileStream(String desiredFileName) throws ConfigException {
        File result = ConfigTool.getAbsoluteFileName(desiredFileName);
        if (ConfigTool.shouldUseClassloader(result)) {
            InputStream configStream;
            if (DEBUG) {
                log.debug((Object)"Using class loader");
            }
            if ((configStream = ConfigTool.getClasspathResource(desiredFileName)) == null) {
                throw new ConfigException("Couldn't find '" + desiredFileName + "' on the file system [ " + result.getAbsolutePath() + " ] or classpath.");
            }
            return configStream;
        }
        try {
            return new FileInputStream(result);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
    }

    private static File getAbsoluteFileName(String desiredFileName) throws ConfigException {
        File result = new File(desiredFileName);
        if (!result.isAbsolute()) {
            return new File(FileUtils.makePathString(Environment.getConfDir().toString(), desiredFileName));
        }
        return result;
    }

    public static String getConfigText(String filename) throws IOException, ConfigException {
        return FileUtils.read(ConfigTool.getConfigFileStream(filename));
    }

    public static Properties getConfigProperties(String filename) throws IOException, ConfigException {
        return ConfigTool.getProperties(ConfigTool.getConfigFile(filename));
    }

    public static Properties getProperties(File propertiesFile) throws IOException {
        return ConfigTool.getProperties(new FileInputStream(propertiesFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream propertiesStream) throws IOException {
        Util.guardNotNull(propertiesStream);
        Properties props = new Properties();
        try {
            props.load(propertiesStream);
            Properties properties = props;
            return properties;
        }
        finally {
            propertiesStream.close();
        }
    }

    public static final NodeConfig loadNodeConfig() throws ConfigException {
        return ConfigTool.load(Module.node, NodeConfig.class);
    }

    public static final void writeNodeConfig(NodeConfig config) throws ConfigException {
        ConfigTool.write(Module.node, (Object)config);
    }

    public static final AgentConfig loadAgentConfig() throws ConfigException {
        return ConfigTool.load(Module.agent, AgentConfig.class);
    }

    public static final void writeAgentConfig(AgentConfig config) throws ConfigException {
        ConfigTool.write(Module.agent, (Object)config);
    }

    public static final KeyStoreConfig loadKeyStoreConfig() throws ConfigException {
        try {
            return ConfigTool.load(Module.keystore, KeyStoreConfig.class);
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (ConfigException e) {
            String fileName = FileUtils.makePathString(Environment.getConfDir().toString(), ConfigTool.makeXMLFileName(Module.keystore));
            log.warn((Object)("Trying to generate keystore, unable to load from: '" + fileName + "'. File exists? " + FileUtils.exists(fileName)));
            ConfigTool.generateKeystoreAndConfigFile();
            try {
                return ConfigTool.load(Module.keystore, KeyStoreConfig.class);
            }
            catch (ConfigException ee) {
                throw new ConfigException("Unable to find keystore config file and unable to generate default key store file.", ee);
            }
        }
    }

    private static final void generateKeystoreAndConfigFile() throws ConfigException {
        String hostname = ConfigTool.getHostName();
        String password = "spinkeystore";
        String directoryName = Environment.getConfDir().toString();
        ConfigTool.makeKeyStoreDirIfNecessary(directoryName);
        String keystoreConfigFileName = ConfigTool.makeXMLFileName(Module.keystore);
        File keystoreXmlFile = ConfigTool.getQualifiedFileName(directoryName, keystoreConfigFileName);
        File keystoreFile = ConfigTool.generateCertificateAndKeyStoreFiles(directoryName, hostname, "spinkeystore");
        try {
            KeyStoreConfig keystoreConfig = new KeyStoreConfig(keystoreFile, "spinkeystore", hostname);
            if (!keystoreXmlFile.exists()) {
                keystoreXmlFile.createNewFile();
            }
            JAXBUtils.marshalToFile(keystoreConfig, keystoreXmlFile);
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
        catch (JAXBException e) {
            throw new ConfigException("Error marshalling auto-generated keystore to xml file.", e);
        }
    }

    private static final File getQualifiedFileName(String directoryName, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            return new File(FileUtils.makePathString(directoryName, fileName));
        }
        return file;
    }

    private static void makeKeyStoreDirIfNecessary(String directoryName) throws ConfigException {
        if (!new File(directoryName).exists() && !new File(directoryName).mkdir()) {
            throw new ConfigException("Unable to create directories to store keystore file.");
        }
    }

    private static final File generateCertificateAndKeyStoreFiles(String directoryName, String hostname, String password) throws ConfigException {
        String keystoreFileName = Defaults.keystoreFilename;
        File keystoreFile = ConfigTool.getQualifiedFileName(directoryName, keystoreFileName);
        String certFileName = keystoreFileName + ".cer";
        File certFile = ConfigTool.getQualifiedFileName(directoryName, certFileName);
        try {
            KeyPair keypair = ConfigTool.generateKeyPair();
            X509Certificate certificate = ConfigTool.createCertificate(keypair, hostname);
            Certificate[] certChain = Util.asArray(certificate);
            ConfigTool.writeCertToDisk(certFile, certificate);
            KeyStore keystore = ConfigTool.makeKeyStore(hostname, password, keypair, certChain);
            ConfigTool.writeKeystoreToDisk(keystoreFile, keystore, password);
            return keystoreFile;
        }
        catch (Exception e) {
            throw new ConfigException("Error generating and/or writing keystore/keypair/certificate: ", e);
        }
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keypairGenerator = KeyPairGenerator.getInstance("RSA");
        return keypairGenerator.generateKeyPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCertToDisk(File certFile, X509Certificate certificate) throws FileNotFoundException, IOException, CertificateEncodingException {
        FileOutputStream certStream = new FileOutputStream(certFile);
        try {
            certStream.write(certificate.getEncoded());
            if (INFO) {
                log.info((Object)("Certificate written to <" + certFile.getAbsolutePath() + ">."));
            }
        }
        finally {
            try {
                certStream.close();
            }
            catch (IOException ioe) {
                log.warn((Object)("Couldn't close certificate file '" + certFile + "'"), (Throwable)ioe);
            }
        }
    }

    private static KeyStore makeKeyStore(String hostname, String password, KeyPair keypair, Certificate[] certChain) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keystore = KeyStore.getInstance(KeyStoreConfig.defaultKeystoreType.name());
        keystore.load(null);
        keystore.setKeyEntry(hostname, keypair.getPrivate(), password.toCharArray(), certChain);
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeystoreToDisk(File keystoreFile, KeyStore keystore, String password) throws FileNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream keystoreFos = new FileOutputStream(keystoreFile);
        try {
            keystore.store(keystoreFos, password.toCharArray());
            if (INFO) {
                log.info((Object)("Keystore written to <" + keystoreFile.getAbsolutePath() + ">."));
            }
        }
        finally {
            try {
                keystoreFos.close();
            }
            catch (IOException ioe) {
                log.warn((Object)("Couldn't close keystore file: '" + keystoreFile + "'"), (Throwable)ioe);
            }
        }
    }

    private static final X509Certificate createCertificate(KeyPair keypair, String hostname) throws ConfigException {
        String QUOTE = "\"";
        X509Principal dName = new X509Principal("CN=\"" + hostname + "\"");
        long oneMonth = 2592000000L;
        long oneYear = 31104000000L;
        Date startDate = new Date(System.currentTimeMillis() - 2592000000L);
        Date endDate = new Date(System.currentTimeMillis() + 1555200000000L);
        BigInteger serialNum = ConfigTool.generateSerialNumber();
        X509V3CertificateGenerator certGenerator = ConfigTool.makeCertGenerator(keypair, dName, startDate, endDate, serialNum);
        try {
            return certGenerator.generate(keypair.getPrivate());
        }
        catch (Exception e) {
            throw new ConfigException("Error generating certificate: ", e);
        }
    }

    private static X509V3CertificateGenerator makeCertGenerator(KeyPair keypair, X509Principal dName, Date startDate, Date endDate, BigInteger serialNum) {
        X509V3CertificateGenerator certGenerator = new X509V3CertificateGenerator();
        certGenerator.setPublicKey(keypair.getPublic());
        certGenerator.setSignatureAlgorithm("SHA1withRSA");
        certGenerator.setIssuerDN((X509Name)dName);
        certGenerator.setSubjectDN((X509Name)dName);
        certGenerator.setSerialNumber(serialNum);
        certGenerator.setNotBefore(startDate);
        certGenerator.setNotAfter(endDate);
        return certGenerator;
    }

    private static BigInteger generateSerialNumber() {
        return BigInteger.valueOf(1 + secureRandom.nextInt(Integer.MAX_VALUE));
    }

    private static SecureRandom makeSecureRandom() {
        SecureRandom randSerial = new SecureRandom();
        randSerial.setSeed(RandomTool.randomBigInteger().longValue());
        return randSerial;
    }

    public static final void writeKeyStoreConfig(KeyStoreConfig config) throws ConfigException {
        ConfigTool.write(Module.keystore, (Object)config);
    }

    public static final RoutingTableConfig loadRoutingTableConfig() throws ConfigException {
        return ConfigTool.load(Module.routingtable, RoutingTableConfig.class);
    }

    public static final void writeRoutingTableConfig(RoutingTableConfig config) throws ConfigException {
        ConfigTool.write(Module.routingtable, (Object)config);
    }

    public static final <T> T load(Module moduleName, Class<T> configurationClass) throws ConfigException {
        return ConfigTool.load(ConfigTool.getConfigFileReader(moduleName), configurationClass);
    }

    public static final void write(Module moduleName, Object configurationClass) throws ConfigException {
        ConfigTool.write(ConfigTool.getConfigFile(moduleName), configurationClass);
    }

    protected static final <T> T load(File configFile, Class<T> configurationClass) throws ConfigException {
        if (INFO) {
            log.info((Object)("Loading " + configFile.getAbsolutePath()));
        }
        try {
            return ConfigTool.load(new FileReader(configFile), configurationClass);
        }
        catch (ConfigException e) {
            log.fatal((Object)("Failed to load! " + configFile.getAbsolutePath()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to load! " + configFile.getAbsolutePath()), (Throwable)e);
            throw new ConfigException(e);
        }
    }

    public static final <T> T load(Reader configFile, Class<T> configurationClass) throws ConfigException {
        try {
            return JAXBUtils.unmarshalAndValidate(configFile, configurationClass);
        }
        catch (JAXBException je) {
            throw new ValidationException("Validation failed! Expected a serialized " + configurationClass, je);
        }
        catch (Exception e) {
            throw new ConfigException("Could not load config file: '" + configFile + "'", e);
        }
    }

    public static final void write(File configFile, Object configurationClass) throws ConfigException {
        try {
            if (INFO) {
                log.info((Object)("Writing file " + configFile.getAbsolutePath()));
            }
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                File backup = new File(configFile + ".bak");
                if (backup.exists()) {
                    backup.delete();
                }
                configFile.renameTo(backup);
            }
            ConfigTool.writeConfigObjectAsXML(configFile, configurationClass);
        }
        catch (Exception e) {
            throw new ConfigException("Could not write file: " + configFile.getAbsoluteFile(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigObjectAsXML(File configFile, Object configurationClass) throws IOException, JAXBException {
        FileWriter writer = new FileWriter(configFile);
        try {
            JAXBUtils.marshalToWriter(configurationClass, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.warn((Object)("Couldn't close file '" + configFile + "'"));
            }
        }
    }

    @Deprecated
    public static URL buildURL(String suffix) {
        return ConfigTool.buildHTTPSLocalhostURL(suffix);
    }

    public static URL buildHTTPSLocalhostURL(String suffix) {
        try {
            return new URL("https://" + ConfigTool.getHostName() + suffix);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHostName() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            hostname = System.getProperty("HOSTNAME");
        }
        return hostname == null ? "localhost" : hostname;
    }

    static {
        try {
            ConfigTool.initLog4J();
        }
        catch (Exception e) {
            System.out.println("ConfigTool: could not initialize Log4J for Spin tools" + e.getMessage());
        }
    }

    private static final class Defaults {
        public static final String keystoreFilename = ConfigTool.getHostName() + ".keystore";
        public static final String keystorePassword = "spinkeystore";

        private Defaults() {
        }
    }
}

