/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.KeystoreType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyStoreConfig", namespace="http://spin.org/xml/res/keystore")
@XmlRootElement(name="KeyStoreConfig", namespace="http://spin.org/xml/res/keystore")
public final class KeyStoreConfig {
    @XmlElement(required=true)
    protected final File file;
    @XmlElement(required=true)
    protected final String password;
    @XmlElement(required=false)
    protected final String keyAlias;
    @XmlElement(required=false)
    protected final String caPublicKeyAlias;
    @XmlElement(required=false)
    protected final Boolean attachCertificateToSignature;
    @XmlElement(required=false)
    protected Boolean setSystemProperties = Boolean.TRUE;
    @XmlElement(required=false)
    protected KeystoreType keystoreType = defaultKeystoreType;
    public static final KeystoreType defaultKeystoreType = KeystoreType.JKS;

    public KeyStoreConfig() {
        this(null, null);
    }

    public KeyStoreConfig(File file, String password) {
        this(file, password, null);
    }

    public KeyStoreConfig(File file, String password, String keyAlias) {
        this(file, password, keyAlias, null, true);
    }

    public KeyStoreConfig(File file, String password, String keyAlias, String caPublicKeyAlias) {
        this(file, password, keyAlias, caPublicKeyAlias, true);
    }

    public KeyStoreConfig(File file, String password, boolean setSystemProperties) {
        this(file, password, null, null, setSystemProperties);
    }

    public KeyStoreConfig(File file, String password, String keyAlias, String caPublicKeyAlias, boolean setSystemProperties) {
        this(file, password, keyAlias, caPublicKeyAlias, false, setSystemProperties, null);
    }

    public KeyStoreConfig(File file, String password, String keyAlias, String caPublicKeyAlias, boolean attachCert, boolean setSystemProperties, KeystoreType keystoreType) {
        this.file = file;
        this.password = password;
        this.keyAlias = keyAlias;
        this.setSystemProperties = setSystemProperties;
        this.caPublicKeyAlias = caPublicKeyAlias;
        this.attachCertificateToSignature = attachCert;
        this.keystoreType = keystoreType == null ? defaultKeystoreType : keystoreType;
    }

    public File getFile() {
        return this.file;
    }

    public String getPassword() {
        return this.password;
    }

    public char[] getPasswordAsCharArray() {
        return this.password.toCharArray();
    }

    public boolean isSetSystemProperties() {
        return this.setSystemProperties;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getCaPublicKeyAlias() {
        return this.caPublicKeyAlias;
    }

    public boolean isAttachCertificateToSignature() {
        return this.attachCertificateToSignature;
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public KeyStoreConfig withKeyStoreType(KeystoreType keyStoreType) {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.setSystemProperties, keyStoreType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreConfig that = (KeyStoreConfig)o;
        if (this.attachCertificateToSignature != that.attachCertificateToSignature) {
            return false;
        }
        if (this.caPublicKeyAlias != null ? !this.caPublicKeyAlias.equals(that.caPublicKeyAlias) : that.caPublicKeyAlias != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        if (this.keyAlias != null ? !this.keyAlias.equals(that.keyAlias) : that.keyAlias != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.setSystemProperties != null ? !this.setSystemProperties.equals(that.setSystemProperties) : that.setSystemProperties != null);
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.keyAlias != null ? this.keyAlias.hashCode() : 0);
        result = 31 * result + (this.caPublicKeyAlias != null ? this.caPublicKeyAlias.hashCode() : 0);
        result = 31 * result + (this.attachCertificateToSignature != null ? this.attachCertificateToSignature.hashCode() : 0);
        result = 31 * result + (this.setSystemProperties != null ? this.setSystemProperties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "KeyStoreConfig [file=" + this.file + ", password=" + (this.password.length() > 0 ? "******" : "NULL") + ", keyAlias=" + this.keyAlias + ", caPublicKeyAlias=" + this.caPublicKeyAlias + ", attachCertificateToSignature=" + this.attachCertificateToSignature + ", setSystemProperties=" + this.setSystemProperties + "]";
    }
}

