/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.tools.Interval;
import org.spin.tools.Util;
import org.spin.tools.Version;
import org.spin.tools.config.QueryTypeConfig;
import org.spin.tools.config.ResultStoreType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NodeConfig")
@XmlRootElement(name="NodeConfig")
public final class NodeConfig {
    private static final Logger log = Logger.getLogger(NodeConfig.class);
    public static final Interval defaultBroadcastTimeoutPeriod = Interval.FiveSeconds;
    public static final Long defaultCertificationTime = 3600000L;
    public static final Long defaultCacheExpirationTime = 0x6DDD00L;
    public static final ResultStoreType defaultResultStoreType = ResultStoreType.SimpleInMemory;
    @XmlElement(name="version", required=true)
    protected final String version = Version.getVersion(NodeConfig.class);
    @XmlElement(name="nodeName", required=true)
    private String nodeName;
    @XmlElement(name="isAuthenticator", required=false)
    private Boolean isAuthenticator = Boolean.FALSE;
    @XmlElement(name="isBroadcaster", required=false)
    private Boolean isBroadcaster = Boolean.TRUE;
    @XmlElement(name="isAggregator", required=false)
    private Boolean isAggregator = Boolean.TRUE;
    @XmlElement(name="isQueryable", required=false)
    private Boolean isQueryable = Boolean.TRUE;
    @XmlElement(name="identityServiceClass", required=false)
    private String identityServiceClass;
    @Deprecated
    @XmlElement(name="queries", required=false)
    private final List<QueryTypeConfig> queries = Util.makeArrayList();
    @XmlElement(name="certificationTTL", required=false)
    private Long certificationTTL = defaultCertificationTime;
    @XmlElement(name="cacheTTL", required=false)
    private Long cacheTTL = defaultCacheExpirationTime;
    @XmlElement(name="broadcastTimeoutPeriod", required=false)
    private Interval broadcastTimeoutPeriod = defaultBroadcastTimeoutPeriod;
    @XmlElement(name="resultStoreType", required=false)
    private ResultStoreType resultStoreType = defaultResultStoreType;
    @XmlElement(name="queryActionMapClassName", required=false)
    private String queryActionMapClassName;

    public static final NodeConfig copyOf(NodeConfig other) {
        if (other == null) {
            return null;
        }
        NodeConfig result = new NodeConfig();
        result.cacheTTL = other.cacheTTL;
        result.certificationTTL = other.certificationTTL;
        result.identityServiceClass = other.identityServiceClass;
        result.isAggregator = other.isAggregator;
        result.isAuthenticator = other.isAuthenticator;
        result.isBroadcaster = other.isBroadcaster;
        result.isQueryable = other.isQueryable;
        result.nodeName = other.nodeName;
        result.resultStoreType = other.resultStoreType;
        result.queryActionMapClassName = other.queryActionMapClassName;
        if (other.broadcastTimeoutPeriod != null) {
            result.broadcastTimeoutPeriod = other.broadcastTimeoutPeriod;
        }
        for (QueryTypeConfig otherQueryTypeConfig : other.queries) {
            result.queries.add(QueryTypeConfig.copyOf(otherQueryTypeConfig));
        }
        return result;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Deprecated
    public List<QueryTypeConfig> getQueries() {
        return this.queries;
    }

    public boolean hasQueryType(String queryType) {
        for (QueryTypeConfig qt : this.getQueries()) {
            if (!qt.getQueryType().equalsIgnoreCase(queryType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void addQuery(QueryTypeConfig queryTypeConfig) {
        this.queries.add(queryTypeConfig);
    }

    @Deprecated
    public void addQueries(Collection<QueryTypeConfig> queryList) {
        this.queries.addAll(queryList);
    }

    public Boolean isAuthenticator() {
        return this.isAuthenticator;
    }

    @Deprecated
    public void setAuthenticator(Boolean isAuthenticator) {
        this.isAuthenticator = isAuthenticator;
    }

    public String getIdentityServiceClass() {
        return this.identityServiceClass;
    }

    @Deprecated
    public void setIdentityServiceClass(String identityServiceClass) {
        this.identityServiceClass = identityServiceClass;
    }

    public Boolean isBroadcaster() {
        return this.isBroadcaster;
    }

    @Deprecated
    public void setBroadcaster(Boolean isBroadcaster) {
        this.isBroadcaster = isBroadcaster;
    }

    public Boolean isAggregator() {
        return this.isAggregator;
    }

    @Deprecated
    public void setAggregator(Boolean isAggregator) {
        this.isAggregator = isAggregator;
    }

    public Boolean isQueryable() {
        return this.isQueryable;
    }

    @Deprecated
    public void setQueryable(Boolean isQueryable) {
        this.isQueryable = isQueryable;
    }

    public Long getCertificationTTL() {
        return this.certificationTTL;
    }

    @Deprecated
    public void setCertificationTTL(Long certificationTTL) {
        this.certificationTTL = certificationTTL;
    }

    public Long getCacheTTL() {
        return this.cacheTTL;
    }

    @Deprecated
    public void setCacheTTL(Long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public Interval getBroadcastTimeoutPeriod() {
        return this.broadcastTimeoutPeriod;
    }

    @Deprecated
    public void setBroadcastTimeoutPeriod(Interval broadcastTimeoutPeriod) {
        this.broadcastTimeoutPeriod = broadcastTimeoutPeriod;
    }

    public ResultStoreType getResultStoreType() {
        return this.resultStoreType;
    }

    @Deprecated
    public void setResultStoreType(ResultStoreType resultStoreType) {
        this.resultStoreType = resultStoreType;
    }

    public String getQueryActionMapClassName() {
        return this.queryActionMapClassName;
    }

    @Deprecated
    public void setQueryActionMapClassName(String queryActionMapClassName) {
        this.queryActionMapClassName = queryActionMapClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.broadcastTimeoutPeriod == null ? 0 : this.broadcastTimeoutPeriod.hashCode());
        result = 31 * result + (this.cacheTTL == null ? 0 : this.cacheTTL.hashCode());
        result = 31 * result + (this.certificationTTL == null ? 0 : this.certificationTTL.hashCode());
        result = 31 * result + (this.identityServiceClass == null ? 0 : this.identityServiceClass.hashCode());
        result = 31 * result + (this.isAggregator == null ? 0 : this.isAggregator.hashCode());
        result = 31 * result + (this.isAuthenticator == null ? 0 : this.isAuthenticator.hashCode());
        result = 31 * result + (this.isBroadcaster == null ? 0 : this.isBroadcaster.hashCode());
        result = 31 * result + (this.isQueryable == null ? 0 : this.isQueryable.hashCode());
        result = 31 * result + (this.nodeName == null ? 0 : this.nodeName.hashCode());
        result = 31 * result + (this.queries == null ? 0 : ((Object)this.queries).hashCode());
        result = 31 * result + (this.resultStoreType == null ? 0 : this.resultStoreType.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.queryActionMapClassName == null ? 0 : this.queryActionMapClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeConfig other = (NodeConfig)obj;
        if (this.broadcastTimeoutPeriod == null ? other.broadcastTimeoutPeriod != null : !this.broadcastTimeoutPeriod.equals(other.broadcastTimeoutPeriod)) {
            return false;
        }
        if (this.cacheTTL == null ? other.cacheTTL != null : !this.cacheTTL.equals(other.cacheTTL)) {
            return false;
        }
        if (this.certificationTTL == null ? other.certificationTTL != null : !this.certificationTTL.equals(other.certificationTTL)) {
            return false;
        }
        if (this.identityServiceClass == null ? other.identityServiceClass != null : !this.identityServiceClass.equals(other.identityServiceClass)) {
            return false;
        }
        if (this.isAggregator == null ? other.isAggregator != null : !this.isAggregator.equals(other.isAggregator)) {
            return false;
        }
        if (this.isAuthenticator == null ? other.isAuthenticator != null : !this.isAuthenticator.equals(other.isAuthenticator)) {
            return false;
        }
        if (this.isBroadcaster == null ? other.isBroadcaster != null : !this.isBroadcaster.equals(other.isBroadcaster)) {
            return false;
        }
        if (this.isQueryable == null ? other.isQueryable != null : !this.isQueryable.equals(other.isQueryable)) {
            return false;
        }
        if (this.nodeName == null ? other.nodeName != null : !this.nodeName.equals(other.nodeName)) {
            return false;
        }
        if (this.queries == null ? other.queries != null : !((Object)this.queries).equals(other.queries)) {
            return false;
        }
        if (this.resultStoreType == null ? other.resultStoreType != null : !this.resultStoreType.equals((Object)other.resultStoreType)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.queryActionMapClassName == null ? other.queryActionMapClassName != null : !this.queryActionMapClassName.equals(other.queryActionMapClassName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        String CRLF = System.getProperty("line.separator");
        sb.append("NodeName:\t\t").append(this.getNodeName());
        sb.append(CRLF);
        sb.append("Version:\t\t").append(this.getVersion());
        sb.append(CRLF);
        sb.append("isBroadcaster:\t\t").append(this.isBroadcaster);
        sb.append(CRLF);
        sb.append("isAggregator:\t\t").append(this.isAggregator);
        sb.append(CRLF);
        sb.append("Cache TTL:\t\t").append(this.getCacheTTL());
        sb.append(CRLF);
        sb.append("authenticator:\t\t").append(this.identityServiceClass);
        sb.append(CRLF);
        sb.append("Certification TTL:\t").append(this.getCertificationTTL());
        sb.append(CRLF);
        sb.append("isQueryable:\t\t").append(this.isQueryable);
        sb.append(CRLF);
        sb.append("broadcastTimeoutPeriod:\t\t").append(this.broadcastTimeoutPeriod);
        sb.append(CRLF);
        sb.append("resultStoreType:\t\t").append(this.resultStoreType.toString());
        sb.append(CRLF);
        for (QueryTypeConfig q : this.queries) {
            sb.append("QueryType:\t\t").append(q.getQueryType());
            sb.append(CRLF);
        }
        return sb.toString();
    }
}

