/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.PeerGroupConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RoutingTableConfig", namespace="http://spin.org/xml/res")
@XmlRootElement(name="RoutingTableConfig", namespace="http://spin.org/xml/res")
public final class RoutingTableConfig {
    @XmlElement(name="peerGroup", required=false)
    protected final List<PeerGroupConfig> peerGroups;

    public RoutingTableConfig() {
        this(Collections.emptyList());
    }

    public RoutingTableConfig(RoutingTableConfig other) {
        this(other.peerGroups);
    }

    public RoutingTableConfig(PeerGroupConfig ... peerGroups) {
        this(Arrays.asList(peerGroups));
    }

    public RoutingTableConfig(Collection<PeerGroupConfig> peerGroups) {
        Util.guardNotNull(peerGroups);
        this.peerGroups = Util.makeArrayList(peerGroups);
    }

    public static final RoutingTableConfig copyOf(RoutingTableConfig other) {
        if (other == null) {
            return null;
        }
        ArrayList<PeerGroupConfig> copiedPeerGroups = Util.makeArrayList(other.peerGroups.size());
        for (PeerGroupConfig otherPeerGroup : other.peerGroups) {
            copiedPeerGroups.add(PeerGroupConfig.copyOf(otherPeerGroup));
        }
        return new RoutingTableConfig(copiedPeerGroups);
    }

    public List<PeerGroupConfig> getPeerGroups() {
        return Util.makeArrayList(this.peerGroups);
    }

    @Deprecated
    public void add(PeerGroupConfig peerGroupConfig) {
        if (peerGroupConfig != null) {
            this.peerGroups.add(peerGroupConfig);
        }
    }

    public RoutingTableConfig with(PeerGroupConfig peerGroupConfig) {
        ArrayList<PeerGroupConfig> newPeerGroups = Util.makeArrayList(this.peerGroups.size() + 1);
        newPeerGroups.addAll(this.peerGroups);
        newPeerGroups.add(peerGroupConfig);
        return new RoutingTableConfig(newPeerGroups);
    }

    public RoutingTableConfig with(Collection<PeerGroupConfig> peerGroupConfigs) {
        return new RoutingTableConfig(peerGroupConfigs);
    }

    public RoutingTableConfig without(PeerGroupConfig peerGroupConfig) {
        if (peerGroupConfig == null) {
            return this;
        }
        ArrayList<PeerGroupConfig> newPeerGroups = Util.makeArrayList(this.peerGroups);
        newPeerGroups.remove(peerGroupConfig);
        return new RoutingTableConfig(newPeerGroups);
    }

    public String toString() {
        return "RoutingTableConfig [peerGroups=" + this.peerGroups + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.peerGroups == null ? 0 : ((Object)this.peerGroups).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingTableConfig other = (RoutingTableConfig)obj;
        if (this.peerGroups == null) {
            if (other.peerGroups != null) {
                return false;
            }
        } else if (!((Object)this.peerGroups).equals(other.peerGroups)) {
            return ((Object)Util.asSet(this.peerGroups)).equals(Util.asSet(other.peerGroups));
        }
        return true;
    }
}

