/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration;

import java.util.ArrayList;
import org.spin.tools.Util;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.config.migration.MigrationException;
import org.spin.tools.config.migration.Migrator;
import org.spin.tools.config.migration.oldversions.EndpointConfig_OneEight;
import org.spin.tools.config.migration.oldversions.EndpointType_OneEight;
import org.spin.tools.config.migration.oldversions.PeerGroupConfig_OneEight;
import org.spin.tools.config.migration.oldversions.RoutingTableConfig_OneEight;

public final class Migrators {
    private Migrators() {
    }

    public static final class ForRoutingTableConfig {
        public static final Migrator<RoutingTableConfig_OneEight, RoutingTableConfig> fromOneEight = new Migrator<RoutingTableConfig_OneEight, RoutingTableConfig>(){

            @Override
            public RoutingTableConfig migrate(RoutingTableConfig_OneEight srcOneEight) throws MigrationException {
                if (srcOneEight == null) {
                    return null;
                }
                ArrayList<PeerGroupConfig> peerGroups = Util.makeArrayList();
                for (String peerGroupNameOneEight : srcOneEight.getPeerGroupNames()) {
                    PeerGroupConfig_OneEight peerGroupOneEight = srcOneEight.get(peerGroupNameOneEight);
                    peerGroups.add(ForPeerGroupConfig.fromOneEight.migrate(peerGroupOneEight));
                }
                return new RoutingTableConfig(peerGroups);
            }
        };

        private ForRoutingTableConfig() {
        }
    }

    public static final class ForPeerGroupConfig {
        public static final Migrator<PeerGroupConfig_OneEight, PeerGroupConfig> fromOneEight = new Migrator<PeerGroupConfig_OneEight, PeerGroupConfig>(){

            @Override
            public PeerGroupConfig migrate(PeerGroupConfig_OneEight src) throws MigrationException {
                if (src == null) {
                    return null;
                }
                PeerGroupConfig result = new PeerGroupConfig(src.getGroupName()).withParent(ForEndpointConfig.fromOneEight.migrate(src.getParent()));
                ArrayList<EndpointConfig> children = Util.makeArrayList(src.getChildren().size());
                for (EndpointConfig_OneEight child : src.getChildren()) {
                    children.add(ForEndpointConfig.fromOneEight.migrate(child));
                }
                return result.withChildren(children);
            }
        };

        private ForPeerGroupConfig() {
        }
    }

    public static final class ForEndpointConfig {
        public static final Migrator<EndpointConfig_OneEight, EndpointConfig> fromOneEight = new Migrator<EndpointConfig_OneEight, EndpointConfig>(){

            @Override
            public EndpointConfig migrate(EndpointConfig_OneEight src) throws MigrationException {
                if (src == null) {
                    return null;
                }
                return new EndpointConfig(ForEndpointType.fromOneEight.migrate(src.getEndpointType()), src.getAddress());
            }
        };

        private ForEndpointConfig() {
        }
    }

    public static final class ForEndpointType {
        public static final Migrator<EndpointType_OneEight, EndpointType> fromOneEight = new Migrator<EndpointType_OneEight, EndpointType>(){

            @Override
            public EndpointType migrate(EndpointType_OneEight src) throws MigrationException {
                if (src == null) {
                    return null;
                }
                if (src == EndpointType_OneEight.Local) {
                    return EndpointType.Local;
                }
                if (src == EndpointType_OneEight.SOAP) {
                    return EndpointType.SOAP;
                }
                throw new MigrationException("Cannot migrate EndpointType: " + (Object)((Object)src));
            }
        };

        private ForEndpointType() {
        }
    }
}

