/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration.oldversions;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.DefaultPeerGroups;
import org.spin.tools.config.migration.oldversions.EndpointConfig_OneEight;
import org.spin.tools.config.migration.oldversions.PeerGroupConfig_OneEight;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RoutingTableConfig18")
@XmlRootElement
public class RoutingTableConfig_OneEight {
    protected final HashMap<String, PeerGroupConfig_OneEight> peerGroups = Util.makeHashMap();

    public RoutingTableConfig_OneEight() {
        this.ensureLocalPeerGroupIsPresent();
    }

    public RoutingTableConfig_OneEight(RoutingTableConfig_OneEight other) {
        for (String name : other.getPeerGroupNames()) {
            this.peerGroups.put(name, other.get(name));
        }
        this.ensureLocalPeerGroupIsPresent();
    }

    public static final RoutingTableConfig_OneEight copyOf(RoutingTableConfig_OneEight other) {
        if (other == null) {
            return null;
        }
        RoutingTableConfig_OneEight result = new RoutingTableConfig_OneEight();
        for (Map.Entry<String, PeerGroupConfig_OneEight> otherEntry : other.peerGroups.entrySet()) {
            result.peerGroups.put(otherEntry.getKey(), PeerGroupConfig_OneEight.copyOf(otherEntry.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void ensureLocalPeerGroupIsPresent() {
        HashMap<String, PeerGroupConfig_OneEight> hashMap = this.peerGroups;
        synchronized (hashMap) {
            if (!this.peerGroups.containsKey(DefaultPeerGroups.LOCAL.name())) {
                this.peerGroups.put(DefaultPeerGroups.LOCAL.name(), new PeerGroupConfig_OneEight(DefaultPeerGroups.LOCAL.name()));
            }
        }
    }

    public boolean contains(String peerGroupName) {
        return this.peerGroups.containsKey(peerGroupName);
    }

    public Set<String> getPeerGroupNames() {
        return this.peerGroups.keySet();
    }

    public PeerGroupConfig_OneEight get(String peerGroupName) {
        return this.peerGroups.get(peerGroupName);
    }

    public void add(PeerGroupConfig_OneEight peerGroup) {
        this.peerGroups.put(peerGroup.getGroupName(), peerGroup);
    }

    public void remove(String peerGroupName) {
        this.peerGroups.remove(peerGroupName);
    }

    public void clear() {
        this.peerGroups.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        for (String name : this.peerGroups.keySet()) {
            sb.append("PeerGroup Name:" + name);
            sb.append(CRLF);
            for (EndpointConfig_OneEight child : this.peerGroups.get(name).getChildren()) {
                sb.append("Child:" + child);
                sb.append(CRLF);
            }
            sb.append(CRLF);
            sb.append(CRLF);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.peerGroups == null ? 0 : this.peerGroups.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingTableConfig_OneEight other = (RoutingTableConfig_OneEight)obj;
        return Util.mapsAreEqual(this.peerGroups, other.peerGroups);
    }
}

