/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import org.spin.tools.Util;
import org.spin.tools.crypto.BadSignatureException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Decryptor;
import org.spin.tools.crypto.Encryptor;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.SignerVerifier;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

public abstract class Cryptor
implements Encryptor,
Decryptor,
SignerVerifier {
    public Envelope encryptAndSign(String plainText, CertID encryptFor) throws CryptoException {
        return this.sign(this.encrypt(plainText, encryptFor));
    }

    public Envelope encryptAndSign(String plainText, CertData encryptFor) throws CryptoException {
        return this.sign(this.encrypt(plainText, encryptFor));
    }

    public String decryptAndVerify(Envelope encrypted) throws CryptoException, BadSignatureException {
        Util.guardNotNull(encrypted);
        if (!encrypted.isEncrypted()) {
            throw new CryptoException("Can't decrypt, data isn't encrypted.");
        }
        if (!this.verify(encrypted)) {
            throw new BadSignatureException("Error verifying signature");
        }
        return this.decrypt(encrypted);
    }
}

