/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

public class NullCryptor
extends Cryptor {
    public static final NullCryptor Instance = new NullCryptor();

    private NullCryptor() {
    }

    @Override
    public Envelope encrypt(String plainText, CertID encryptFor) throws CryptoException {
        return Envelope.unencrypted(plainText);
    }

    @Override
    public Envelope encrypt(String plainText, CertData encryptFor) throws CryptoException {
        return Envelope.unencrypted(plainText);
    }

    @Override
    public String decrypt(Envelope cipherText) throws CryptoException {
        if (cipherText == null) {
            return null;
        }
        return cipherText.getData();
    }

    @Override
    public Envelope sign(Envelope encryptedData) throws CryptoException {
        return encryptedData;
    }

    @Override
    public boolean verify(Envelope encryptedData) throws CryptoException {
        return true;
    }
}

