/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.security.SignatureException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.spin.tools.PKITool;
import org.spin.tools.SymmetricCryptoTool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.BadSignatureException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.Cryptor;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

public class PKCryptor
extends Cryptor {
    private static final Logger log = Logger.getLogger(PKCryptor.class);
    private static final boolean INFO = log.isInfoEnabled();
    private final PKITool pkiTool;

    public PKCryptor() throws ConfigException {
        this(PKITool.getInstance());
    }

    public PKCryptor(PKITool pkiTool) {
        this.pkiTool = pkiTool;
    }

    private Envelope encrypt(String plainTextString, X509Certificate cert) throws CryptoException {
        SecretKey key = SymmetricCryptoTool.generateSecretKey();
        byte[] encryptedKey = this.pkiTool.encrypt(key.getEncoded(), cert.getPublicKey());
        byte[] data = SymmetricCryptoTool.encrypt(plainTextString.getBytes(), key);
        return Envelope.encrypted(encryptedKey, data, new CertID(cert.getSerialNumber()));
    }

    @Override
    public Envelope encrypt(String plainTextString, CertID recipientID) throws CryptoException {
        if (plainTextString == null) {
            throw new CryptoException("Null plaintext; can't encrypt");
        }
        if (recipientID == null) {
            throw new CryptoException("Null recipient x509 serial");
        }
        byte[] plainText = plainTextString.getBytes();
        if (!this.pkiTool.containsX509Certificate(recipientID)) {
            throw new CryptoException("No certificate found with key ID: " + recipientID);
        }
        return this.encrypt(plainTextString, this.pkiTool.getX509Certificate(recipientID));
    }

    @Override
    public Envelope encrypt(String plainTextString, CertData certData) throws CryptoException {
        X509Certificate cert = this.pkiTool.getX509Certificate(certData);
        return this.encrypt(plainTextString, cert);
    }

    @Override
    public String decrypt(Envelope encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        if (!encryptedData.isEncrypted()) {
            throw new CryptoException("Not encrypted, can't decrypt");
        }
        SecretKey key = SymmetricCryptoTool.getSecretKey(this.pkiTool.decrypt(encryptedData.getEncryptedKey()));
        return new String(SymmetricCryptoTool.decrypt(encryptedData.getDataBytes(), key));
    }

    @Override
    public Envelope sign(Envelope encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        try {
            return Envelope.signed(encryptedData, this.pkiTool.sign(encryptedData.getData()), this.pkiTool.getMyCertID());
        }
        catch (SignatureException e) {
            throw new CryptoException("Error signing: ", e);
        }
    }

    @Override
    public boolean verify(Envelope encryptedData) throws CryptoException {
        if (encryptedData == null) {
            throw new CryptoException("Null encrypted data passed in");
        }
        if (!encryptedData.isSigned()) {
            log.warn((Object)"Can't verify envelope with no signature");
            return false;
        }
        if (encryptedData.getSignedBy() == null) {
            log.warn((Object)"Data with signature, but no signedBy field. Can't verify signature");
            return false;
        }
        try {
            return this.pkiTool.verifySignature(encryptedData.getData(), encryptedData.getSignature(), encryptedData.getSignedBy());
        }
        catch (SignatureException e) {
            throw new BadSignatureException("Error verifying: ", e);
        }
    }

    public final PKITool getPKITool() {
        return this.pkiTool;
    }
}

