/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="X509DataType")
public final class CertData {
    @XmlElement(name="X509IssuerSerial")
    protected final CertID certID;
    @XmlElement(name="X509Certificate")
    protected final byte[] encodedCert;

    private CertData() {
        this(null, null);
    }

    public CertData(CertID certID, byte[] encodedCert) {
        this.certID = certID;
        this.encodedCert = encodedCert;
    }

    public CertID getCertID() {
        return this.certID;
    }

    public byte[] getX509Certificate() {
        return this.encodedCert;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encodedCert);
        result = 31 * result + (this.certID == null ? 0 : this.certID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertData other = (CertData)obj;
        if (!Arrays.equals(this.encodedCert, other.encodedCert)) {
            return false;
        }
        return !(this.certID == null ? other.certID != null : !this.certID.equals(other.certID));
    }
}

