/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.spin.tools.NetworkTime;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.Signature;

@XmlRootElement(name="Identity")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Identity")
public final class Identity
implements Signable {
    @XmlElement(name="Domain", required=true)
    protected final String domain;
    @XmlElement(name="Username", required=true)
    protected final String username;
    @XmlElement(name="Assertion", required=true)
    protected final List<String> assertions;
    @XmlElement(name="Timestamp")
    protected final XMLGregorianCalendar timestamp;
    @XmlElement(name="Signature")
    protected Signature signature;
    @XmlAttribute(name="Id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;

    public Identity() {
        this(null, null);
    }

    public Identity(String domain, String username) {
        this(domain, username, Collections.emptyList());
    }

    public Identity(String domain, String username, String assertion) {
        this(domain, username, Arrays.asList(assertion));
    }

    public Identity(String domain, String username, List<String> assertions) {
        this(domain, username, assertions, new NetworkTime().getXMLGregorianCalendar(), null);
    }

    public Identity(String domain, String username, List<String> assertions, XMLGregorianCalendar timestamp, Signature signature) {
        this(domain, username, assertions, timestamp, signature, null);
    }

    private Identity(String domain, String username, List<String> assertions, XMLGregorianCalendar timestamp, Signature signature, String id) {
        this.domain = domain;
        this.username = username;
        this.assertions = Util.makeArrayList(assertions);
        this.timestamp = timestamp;
        this.signature = signature;
        this.id = id;
    }

    public static final Identity copyOf(Identity other) {
        if (other == null) {
            return null;
        }
        return new Identity(other.domain, other.username, new ArrayList<String>(other.assertions), new NetworkTime(new NetworkTime(other.timestamp)).getXMLGregorianCalendar(), other.signature);
    }

    public CertID getCertID() {
        return this.getSignature().getKeyInfo().getCertData().getCertID();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getAssertion() {
        return this.assertions;
    }

    public void addAssertion(String assertion) {
        this.getAssertion().add(assertion);
    }

    public void setAssertion(String assertion) {
        this.getAssertion().clear();
        this.addAssertion(assertion);
    }

    public XMLGregorianCalendar getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public Identity withSignature(Signature newSignature) {
        return new Identity(this.domain, this.username, this.assertions, this.timestamp, newSignature, this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assertions == null ? 0 : ((Object)this.assertions).hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identity other = (Identity)obj;
        if (this.assertions == null ? other.assertions != null : !((Object)this.assertions).equals(other.assertions)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

