/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spin.tools.crypto.signature.DigestMethod;
import org.spin.tools.crypto.signature.Transforms;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ReferenceType")
public final class Reference {
    @XmlElement(name="Transforms")
    protected final Transforms transforms;
    @XmlElement(name="DigestMethod", required=true)
    protected final DigestMethod digestMethod;
    @XmlElement(name="DigestValue", required=true)
    protected final byte[] digestValue;
    @XmlAttribute(name="Id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected final String id;
    @XmlAttribute(name="URI")
    @XmlSchemaType(name="anyURI")
    protected final String uri;
    @XmlAttribute(name="Type")
    @XmlSchemaType(name="anyURI")
    protected final String type;

    private Reference() {
        this(null, null, null, null, null, null);
    }

    public Reference(Transforms transforms, DigestMethod digestMethod, byte[] digestValue, String id, String uri, String type) {
        this.transforms = transforms;
        this.digestMethod = digestMethod;
        this.digestValue = digestValue;
        this.id = id;
        this.uri = uri;
        this.type = type;
    }

    public Transforms getTransforms() {
        return this.transforms;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public String getId() {
        return this.id;
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digestMethod == null ? 0 : this.digestMethod.hashCode());
        result = 31 * result + Arrays.hashCode(this.digestValue);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.transforms == null ? 0 : this.transforms.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.digestMethod == null ? other.digestMethod != null : !this.digestMethod.equals(other.digestMethod)) {
            return false;
        }
        if (!Arrays.equals(this.digestValue, other.digestValue)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.transforms == null ? other.transforms != null : !this.transforms.equals(other.transforms)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

