/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.log4j.Logger;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.Signature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLSignatureUtil {
    private static final String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
    private static final Logger log = Logger.getLogger(XMLSignatureUtil.class);
    private static boolean attachPublicKeyToSignatures = false;

    public static Identity sign(Identity identity) throws XMLSignatureException {
        return XMLSignatureUtil.sign(identity, Identity.class, attachPublicKeyToSignatures);
    }

    public static Identity sign(Identity identity, boolean attachPublicKey) throws XMLSignatureException {
        return XMLSignatureUtil.sign(identity, Identity.class, attachPublicKey);
    }

    public static <T> T sign(T toBeSigned, Class<T> classOfObjectToBeSigned) throws XMLSignatureException {
        return XMLSignatureUtil.sign(toBeSigned, classOfObjectToBeSigned, attachPublicKeyToSignatures);
    }

    @Deprecated
    public static <T> T sign(T identity, Class<T> classOfObjectToBeSigned, boolean attachMyPublicKey) throws XMLSignatureException {
        Element signedIdentityElement = XMLSignatureUtil.signObject(identity, attachMyPublicKey);
        try {
            return JAXBUtils.unmarshal((Node)signedIdentityElement, classOfObjectToBeSigned);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Error unmarshalling signed Identity", e);
        }
    }

    public static Element signObject(Object rootXMLObject) throws XMLSignatureException {
        return XMLSignatureUtil.signObject(rootXMLObject, attachPublicKeyToSignatures);
    }

    @Deprecated
    public static Element signObject(Object toBeSigned, boolean attachMyPublicKey) throws XMLSignatureException {
        try {
            PKITool pkiTool = PKITool.getInstance();
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureUtil.getXMLSignatureFactory();
            Reference reference = xmlSignatureFactory.newReference("", xmlSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (XMLStructure)null)), null, null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (XMLStructure)null), xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
            Element element = JAXBUtils.marshalToElement(toBeSigned);
            DOMSignContext domSignContext = new DOMSignContext(pkiTool.getMyPrivateKey(), (Node)element);
            KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
            X509Certificate myX509PublicKeyCertificate = pkiTool.getX509Certificate(pkiTool.getMyCertID());
            X509IssuerSerial x509IssuerSerial = keyInfoFactory.newX509IssuerSerial(myX509PublicKeyCertificate.getIssuerX500Principal().getName(), myX509PublicKeyCertificate.getSerialNumber());
            List<Object> x509DataToInclude = attachMyPublicKey ? Arrays.asList(x509IssuerSerial, myX509PublicKeyCertificate) : Arrays.asList(x509IssuerSerial);
            X509Data x509Data = keyInfoFactory.newX509Data(x509DataToInclude);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Arrays.asList(x509Data));
            XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(domSignContext);
            return element;
        }
        catch (Exception e) {
            throw new XMLSignatureException("Failed to sign object", e);
        }
    }

    public static final boolean verifySignature(Signable toBeVerified) throws XMLSignatureException {
        PublicKey signerKey;
        BigInteger keyID;
        try {
            keyID = toBeVerified.getSignature().getKeyInfo().getCertData().getCertID().getSerial();
        }
        catch (NullPointerException e) {
            log.warn((Object)"Can't determine signing key");
            return false;
        }
        try {
            PublicKey caPublicKey = PKITool.getInstance().getCaPublicKey();
            if (caPublicKey != null) {
                X509Certificate attachedCertificate = XMLSignatureUtil.getX509Certificate(toBeVerified.getSignature());
                attachedCertificate.verify(caPublicKey);
                if (XMLSignatureUtil.verifySignature(toBeVerified, attachedCertificate.getPublicKey())) {
                    return true;
                }
            }
        }
        catch (CertificateException e) {
            log.info((Object)"Error getting Certificate Authority cert, proceding anyway.");
        }
        catch (ConfigException e) {
            log.error((Object)"Config Exception");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"No such algorithm");
        }
        catch (NoSuchProviderException e) {
            log.error((Object)"No such provider");
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Invalid Key, check configuration");
        }
        catch (SignatureException e) {
            log.error((Object)"Signature Exception");
        }
        try {
            signerKey = PKITool.getInstance().getPublicKey(keyID);
        }
        catch (CryptoException e) {
            log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn((Object)("Error getting signer key with serial '" + keyID + "', can't verify signature"), (Throwable)e);
            return false;
        }
        return XMLSignatureUtil.verifySignature(toBeVerified, signerKey);
    }

    public static final boolean verifySignature(Signable toBeVerified, PublicKey publicKey) throws XMLSignatureException {
        try {
            return XMLSignatureUtil.verifySignature(JAXBUtils.marshalToElement(toBeVerified), publicKey);
        }
        catch (JAXBException e) {
            throw new XMLSignatureException("Couldn't unmarshal signed identity", e);
        }
    }

    public static final boolean verifySignature(Element signedElement, PublicKey publicKey) throws XMLSignatureException {
        XMLSignature signature;
        NodeList signaturesNodeList = signedElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signaturesNodeList == null || signaturesNodeList.getLength() < 1) {
            throw new XMLSignatureException("No signature found!");
        }
        Node signatureNode = signaturesNodeList.item(0);
        if (signatureNode == null) {
            throw new XMLSignatureException("No signature found!");
        }
        DOMValidateContext domValidateContext = new DOMValidateContext(publicKey, signatureNode);
        try {
            signature = XMLSignatureUtil.getXMLSignatureFactory().unmarshalXMLSignature(domValidateContext);
        }
        catch (MarshalException e) {
            throw new XMLSignatureException("Couldn't unmarshal XML signature", e);
        }
        return signature.validate(domValidateContext);
    }

    public static final X509Certificate getX509Certificate(Signature signature) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.getKeyInfo().getCertData().getX509Certificate()));
        }
        catch (NullPointerException e) {
            log.error((Object)"Error getting attached X509 signature, possible misconfiguration");
            throw new CertificateException("Error getting attached certificate", e);
        }
    }

    private static final XMLSignatureFactory getXMLSignatureFactory() throws XMLSignatureException {
        try {
            return XMLSignatureFactory.getInstance("DOM", ClassTools.createInstance(providerName, Provider.class));
        }
        catch (DynamicLoadingException e) {
            throw new XMLSignatureException("Couldn't create XMLSignatureFactory using provider class '" + providerName + "': ", e);
        }
    }

    static {
        try {
            attachPublicKeyToSignatures = ConfigTool.loadKeyStoreConfig().isAttachCertificateToSignature();
        }
        catch (ConfigException e) {
            log.fatal((Object)"Error loading keystore config, this is really bad, attempting to let things continue");
        }
    }

    public static enum SignerStrategy {
        AttachSigningKey,
        DoNotAttachSigningKey;

    }
}

