/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.spin.extension.ConfigToolLegacyMethods;
import org.spin.extension.KeytoolShellExec;
import org.spin.extension.config.MailToolConfig;
import org.spin.tools.JDBCTool;
import org.spin.tools.PKITool;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.Environment;
import org.spin.tools.config.FileConfig;
import org.spin.tools.config.JDBCConfig;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.QueryTypeConfig;
import org.spin.tools.config.RoutingTable;
import org.spin.tools.config.RoutingTableConfig;

public class ConfigWizard {
    public static final String CRLF = System.getProperty("line.separator");
    private boolean shouldValidate = false;

    public ConfigWizard(boolean shouldValidate) {
        this.shouldValidate = shouldValidate;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            ConfigWizard.showUsage();
        } else {
            try {
                String runtime;
                Module module = args.length > 0 ? Module.valueOf((String)args[0]) : Module.all;
                String string = runtime = args.length > 1 ? args[1] : "main";
                if (runtime.contains("/") || runtime.contains("\\")) {
                    Environment.setConfDir((File)new File(runtime));
                }
                boolean shouldValidate = args.length > 2 && args[2].equalsIgnoreCase("validate");
                ConfigWizard wizard = new ConfigWizard(shouldValidate);
                if (module == Module.all) {
                    for (Module m : Module.values()) {
                        wizard.configure(m);
                    }
                } else {
                    wizard.configure(module);
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("Uknown module " + args[0]);
                ConfigWizard.showUsage();
            }
            catch (Exception e) {
                e.printStackTrace();
                ConfigWizard.showUsage();
            }
        }
    }

    public static void showUsage() {
        System.out.println("ConfigWizard MODULENAME");
        System.out.println("ConfigWizard MODULENAME [test|main|other]");
        System.out.println("ConfigWizard MODULENAME [test|main|other] validate");
        System.out.println();
        System.out.println("[MODULES] ");
        for (Module m : Module.values()) {
            System.out.println(m.name());
        }
        System.out.println("");
        System.out.println("[Examples] ");
        System.out.println("ConfigWizard agent");
        System.out.println("ConfigWizard agent main validate");
        System.out.println("ConfigWizard agent test validate");
        System.out.println("ConfigWizard node staging");
    }

    public void configure(Module module) throws ConfigException {
        this.printLine("Configuring module '" + module + "'");
        switch (module) {
            case keystore: {
                ConfigTool.writeKeyStoreConfig((KeyStoreConfig)this.promptKeyStore());
                break;
            }
            case agent: {
                ConfigTool.writeAgentConfig((AgentConfig)this.promptAgent());
                break;
            }
            case node: {
                ConfigTool.writeNodeConfig((NodeConfig)this.promptNode());
                break;
            }
            case routingtable: {
                ConfigTool.writeRoutingTableConfig((RoutingTableConfig)this.promptRoutingTable());
                break;
            }
            case mail: {
                ConfigToolLegacyMethods.writeMailToolConfig(this.promptMail());
                break;
            }
            default: {
                System.out.println("Module " + module.name() + " not supported by this config wizard.");
                ConfigWizard.showUsage();
            }
        }
    }

    public KeyStoreConfig promptKeyStore() throws ConfigException {
        if (ConfigTool.getConfigFile((Module)Module.keystore).exists()) {
            try {
                KeyStoreConfig keystore = ConfigTool.loadKeyStoreConfig();
                System.out.println(CRLF);
                if (this.promptBoolean("Found existing keystore.xml,  Would you like to configure this one now? (NO = generate new keystore)", true)) {
                    System.out.println(CRLF);
                    System.out.println(keystore);
                    System.out.println(CRLF);
                    return this.promptKeyStore(keystore);
                }
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        }
        System.out.println(CRLF);
        System.out.println(" Generating a new keystore for you now.");
        File keystoreFile = new File(this.prompt("where would you like your protected keystore?", Environment.getConfDir() + File.separator + Defaults.keystoreFilename));
        String hostname = this.prompt("hostname ", ConfigTool.getHostName());
        String password = this.prompt("password ", "spinkeystore");
        try {
            KeytoolShellExec.genKey(hostname, password, keystoreFile);
            KeytoolShellExec.exportPublicKey(hostname, password, keystoreFile);
            this.promptImportPublicKey(password, keystoreFile);
        }
        catch (IOException e) {
            throw new ConfigException((Throwable)e);
        }
        return new KeyStoreConfig(keystoreFile, password);
    }

    public KeyStoreConfig promptKeyStore(KeyStoreConfig defaultKeyStore) throws IOException {
        KeyStoreConfig keystore = new KeyStoreConfig(new File(this.prompt("file", defaultKeyStore.getFile().getAbsolutePath())), this.prompt("password", defaultKeyStore.getPassword()));
        if (this.shouldValidate && !this.testValid(keystore)) {
            return this.promptKeyStore(defaultKeyStore);
        }
        this.promptImportPublicKey(keystore.getPassword(), keystore.getFile());
        return keystore;
    }

    private void promptImportPublicKey(String password, File keystoreFile) throws IOException {
        if (this.promptBoolean("would you like to import public keys from other sites?", true)) {
            KeytoolShellExec.importPublicKey(password, keystoreFile, this.promptFile("certs"));
        }
    }

    public AgentConfig promptAgent() throws ConfigException {
        AgentConfig agentConfig;
        if (ConfigTool.getConfigFile((Module)Module.agent).exists()) {
            try {
                agentConfig = ConfigTool.loadAgentConfig();
                System.out.println(CRLF);
                System.out.println(agentConfig);
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        } else {
            agentConfig = AgentConfig.Default.withPeerGroupToQuery("LOCAL").withRootAggregatorEndpoint(Defaults.nodeConnectorEndpoint).withNodeConnectorEndpoint(Defaults.nodeConnectorEndpoint).withAuthEndpoint(Defaults.authEndpoint);
        }
        return this.promptAgent(agentConfig);
    }

    public AgentConfig promptAgent(AgentConfig config) {
        return config.withPeerGroupToQuery(this.prompt("peergroup", config.getPeerGroupToQuery())).withNodeConnectorEndpoint(this.promptSOAPEndpoint("Node Connector", config.getNodeConnectorEndpoint())).withMaxWaitTime(this.promptLong("max recieve wait time (ttl)", config.getMaxWaitTime()).longValue()).withAuthEndpoint(this.promptEndpoint("auth handler", config.getAuthEndpoint())).withRootAggregatorEndpoint(config.getNodeConnectorEndpoint());
    }

    public NodeConfig promptNode() throws ConfigException {
        NodeConfig config;
        if (ConfigTool.getConfigFile((Module)Module.node).exists()) {
            try {
                config = ConfigTool.loadNodeConfig();
                System.out.println(CRLF);
                System.out.println(config);
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        } else {
            config = new NodeConfig();
            config.setNodeName(Defaults.leafNodeName);
            config.setBroadcaster(Boolean.valueOf(true));
            config.setAggregator(Boolean.valueOf(true));
            config.setQueryable(Boolean.valueOf(true));
            config.setAuthenticator(Boolean.valueOf(false));
        }
        return this.promptNode(config);
    }

    public NodeConfig promptNode(NodeConfig defaults) {
        NodeConfig config = new NodeConfig();
        config.setNodeName(this.prompt("PeerName", defaults.getNodeName()));
        config.setBroadcaster(Boolean.valueOf(this.promptBoolean("are you going to broadcast queries?", defaults.isBroadcaster())));
        config.setAggregator(Boolean.valueOf(this.promptBoolean("are you going to aggregate responses?", defaults.isAggregator())));
        config.setCertificationTTL(this.promptLong("authenticated identities Expire In (ms):", config.getCertificationTTL()));
        config.setCacheTTL(this.promptLong("Cached Queries Expire In (ms):", config.getCacheTTL()));
        config.setAuthenticator(Boolean.valueOf(this.promptBoolean("are you going to host an authentication service?", defaults.isAuthenticator())));
        if (config.isAuthenticator().booleanValue()) {
            config.setIdentityServiceClass(this.prompt("authenticator class", null));
        }
        config.setQueryable(Boolean.valueOf(this.promptBoolean("are you going to query your local database?", defaults.isQueryable())));
        if (config.isQueryable().booleanValue()) {
            for (QueryTypeConfig query : defaults.getQueries()) {
                if (!this.promptBoolean("use " + query.getQueryType() + " ? ", true)) continue;
                config.getQueries().add(query);
            }
            while (this.promptBoolean("add a query type?", true)) {
                QueryTypeConfig example = new QueryTypeConfig("DiscoveryQueryAction", "org.spin.node.actions.discovery.DiscoveryQueryAction");
                QueryTypeConfig newType = this.promptQueryType(example);
                if (config.hasQueryType(newType.getQueryType())) {
                    this.printLine("\n querytype " + newType.getQueryType() + " already configured. \n");
                    continue;
                }
                config.getQueries().add(newType);
            }
        }
        return config;
    }

    public QueryTypeConfig promptQueryType(QueryTypeConfig defaults) {
        QueryTypeConfig config = new QueryTypeConfig(this.prompt("query type", defaults.getQueryType()), this.prompt("fully qualified classpath", defaults.getClassName()));
        return config;
    }

    public RoutingTableConfig promptRoutingTable() throws ConfigException {
        RoutingTableConfig config;
        if (ConfigTool.getConfigFile((Module)Module.routingtable).exists()) {
            try {
                config = ConfigTool.loadRoutingTableConfig();
                System.out.println(config);
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        } else {
            config = new RoutingTableConfig();
        }
        return this.promptRoutingTable(config);
    }

    public RoutingTableConfig promptRoutingTable(RoutingTableConfig routingTableConfig) {
        RoutingTable routingTable = new RoutingTable(routingTableConfig);
        if (!routingTableConfig.getPeerGroups().isEmpty()) {
            for (PeerGroupConfig peerGroup : routingTableConfig.getPeerGroups()) {
                String name = peerGroup.getGroupName();
                if (this.promptBoolean("Delete peer group " + name + "?", false)) {
                    routingTable.without(name);
                    continue;
                }
                if (name.equalsIgnoreCase("LOCAL")) continue;
                for (int i = 0; i < peerGroup.getChildren().size(); ++i) {
                    if (!this.promptBoolean("Delete node " + peerGroup.getChildren().get(i) + "?", false)) continue;
                    routingTable.get(name).withoutChildAt(i);
                }
                while (this.promptBoolean("Add peer to " + name, false)) {
                    routingTable.get(name).withChild(this.promptSOAPEndpoint("Node connection ", null));
                }
            }
            this.printLine();
        }
        while (this.promptBoolean("Add a Peer Group?", false)) {
            PeerGroupConfig peerGroup = new PeerGroupConfig();
            ArrayList peers = Util.makeArrayList();
            peerGroup.withGroupName(this.prompt("Peer Group Name", null).toUpperCase());
            while (this.promptBoolean("Add a Node to Peer Group '" + peerGroup.getGroupName() + "'?", true)) {
                peers.add(this.promptSOAPEndpoint("Node", null));
            }
            peerGroup.withChildren((Collection)peers);
            routingTable.with(peerGroup);
        }
        System.out.println(CRLF);
        System.out.println(routingTable);
        return routingTable.toRoutingTableConfig();
    }

    public MailToolConfig promptMail() throws ConfigException {
        MailToolConfig config;
        if (ConfigTool.getConfigFile((Module)Module.mail).exists()) {
            try {
                config = ConfigToolLegacyMethods.loadMailToolConfig();
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        } else {
            config = new MailToolConfig();
            config.setHost(Defaults.mailServerHostname);
            config.setRecipient("spin-admin@chip.org");
            config.setSender("spin-admin@chip.org");
        }
        return this.promptMail(config);
    }

    public MailToolConfig promptMail(MailToolConfig defaults) {
        MailToolConfig config = new MailToolConfig();
        config.setHost(this.prompt("host", defaults.getHost()));
        config.setPort(this.promptInt("port", defaults.getPort()));
        if (this.promptBoolean("use authentication?", false)) {
            config.setUsername(this.prompt("username", defaults.getUsername()));
            config.setPassword(this.prompt("password", defaults.getPassword()));
        }
        config.setSender(this.prompt("sender", defaults.getSender()));
        config.setRecipient(this.prompt("admin", defaults.getRecipient()));
        return config;
    }

    public File promptFile(String defaultLocation) throws IOException {
        FileConfig fileConfig = new FileConfig();
        fileConfig.setFilename(this.prompt("location", defaultLocation));
        if (!this.testValid(fileConfig)) {
            this.printLine("File location was invalid, please try again.");
            this.printLine();
            return this.promptFile(defaultLocation);
        }
        return new File(fileConfig.getFilename());
    }

    public URL promptURL(String prompt, URL defaultURL) {
        try {
            return new URL(this.prompt(prompt + ": ", defaultURL == null ? "" : defaultURL.toString()));
        }
        catch (Exception e) {
            return this.promptURL(prompt, defaultURL);
        }
    }

    public EndpointConfig promptEndpoint(String prompt, EndpointConfig defaultEndpoint) {
        String input = this.prompt(prompt + " type (LOCAL or SOAP): ", defaultEndpoint == null ? "" : defaultEndpoint.getEndpointType().name());
        EndpointType type = EndpointType.valueOf((String)input.toUpperCase());
        String address = null;
        if (type == EndpointType.SOAP) {
            return this.promptSOAPEndpoint(prompt, defaultEndpoint);
        }
        return new EndpointConfig(type, address);
    }

    public EndpointConfig promptSOAPEndpoint(String prompt, EndpointConfig defaultEndpoint) {
        String address = this.prompt(prompt + " address: ", defaultEndpoint == null ? "" : defaultEndpoint.getAddress());
        if (!EndpointType.SOAP.isValidAddress(address)) {
            return this.promptSOAPEndpoint(prompt, defaultEndpoint);
        }
        return new EndpointConfig(EndpointType.SOAP, address);
    }

    public JDBCConfig promptDB() throws IOException {
        JDBCConfig defaultDB = new JDBCConfig();
        defaultDB.setDriver("com.mysql.jdbc.Driver");
        defaultDB.setPassword("lcsspin");
        defaultDB.setUrl("jdbc:mysql://localhost:3306/spin");
        defaultDB.setUsername("spin");
        return this.promptDB(defaultDB);
    }

    public JDBCConfig promptDB(JDBCConfig defaultDB) throws IOException {
        JDBCConfig connection = new JDBCConfig();
        connection.setDriver(this.prompt("driver", defaultDB.getDriver()));
        connection.setUrl(this.prompt("URL", defaultDB.getUrl()));
        connection.setUsername(this.prompt("username", defaultDB.getUsername()));
        connection.setPassword(this.prompt("password", defaultDB.getPassword()));
        if (!this.testValid(connection)) {
            this.printLine(" JDBC connection was invalid, please try again.");
            this.printLine();
            return this.promptDB();
        }
        return connection;
    }

    public String prompt(String prompt, String defaultValue) {
        System.out.print(prompt);
        if (defaultValue != null && defaultValue.length() > 0) {
            this.printLine(" (default '" + defaultValue + "')");
        }
        System.out.print(" = ");
        String input = this.readLine();
        return input.length() == 0 ? defaultValue : input;
    }

    public boolean promptBoolean(String prompt, boolean defaultValue) {
        String input = this.prompt(prompt, defaultValue ? "yes" : "no");
        String formattedInput = input.trim().toUpperCase();
        if (formattedInput.length() == 0) {
            return defaultValue;
        }
        if (formattedInput.equalsIgnoreCase("YES") || formattedInput.equalsIgnoreCase("TRUE") || formattedInput.equalsIgnoreCase("Y") || formattedInput.equals("1")) {
            return true;
        }
        if (formattedInput.equalsIgnoreCase("NO") || formattedInput.equalsIgnoreCase("FALSE") || formattedInput.equalsIgnoreCase("N") || formattedInput.equals("0")) {
            return false;
        }
        return this.promptBoolean(prompt, defaultValue);
    }

    public Integer promptInt(String prompt, Integer defaultValue) {
        String input = this.prompt(prompt, "" + defaultValue);
        try {
            return Integer.parseInt(input);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Long promptLong(String prompt, Long defaultValue) {
        String input = this.prompt(prompt, "" + defaultValue);
        try {
            return Long.parseLong(input);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String readLine() {
        try {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e) {
            return "bad input";
        }
    }

    public void printLine() {
        System.out.println();
    }

    public void printLine(String print) {
        System.out.println(print);
    }

    public boolean testValid(KeyStoreConfig config) {
        try {
            PKITool.makeInstance((KeyStoreConfig)config);
            return true;
        }
        catch (Exception e) {
            this.printLine(" Keystore was invalid, please try again.");
            this.printLine(" Your settings: " + config.getFile() + " " + config.getPassword());
            this.printLine();
            return false;
        }
    }

    public boolean testValid(FileConfig fileConfig) {
        return this.testValid(new File(fileConfig.getFilename()));
    }

    public boolean testValid(File file) {
        try {
            if (file.exists()) {
                this.printLine("Found " + file.getAbsolutePath());
                this.printLine();
                return true;
            }
            this.printLine("File not found! " + file.getAbsolutePath());
            this.printLine();
            return false;
        }
        catch (Exception e) {
            this.printLine("Invalid file specified");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testValid(JDBCConfig jdbc) {
        Connection conn = null;
        try {
            conn = JDBCTool.getConnection((JDBCConfig)jdbc);
            this.printLine("Test Connection successfull ! ");
            this.printLine("driver=" + jdbc.getDriver());
            this.printLine("URL=" + jdbc.getUrl());
            this.printLine("username=" + jdbc.getUsername());
            this.printLine("password=" + jdbc.getPassword());
            this.printLine();
            boolean bl = true;
            return bl;
        }
        catch (ConfigException e) {
            this.printLine("Test Connection FAILED!");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException eaten) {}
            }
        }
    }

    public static final class Defaults {
        public static final String institution = "Harvard";
        public static final String keystoreFilename = ConfigTool.getHostName() + ".keystore";
        public static final String keystorePrivateKeyAlias = ConfigTool.getHostName();
        public static final String keystorePassword = "spinkeystore";
        public static final String agentPeerGroup = "LOCAL";
        public static final EndpointConfig nodeConnectorEndpoint = new EndpointConfig(EndpointType.SOAP, ConfigTool.buildURL((String)":443/node-server/node").toString());
        public static final EndpointConfig authEndpoint = new EndpointConfig(EndpointType.Local, null);
        public static final String leafNodeName = ConfigTool.getHostName();
        public static final String mailServerHostname = ConfigTool.getHostName();
        public static final String adminEmailAddress = "spin-admin@chip.org";
        public static final String dbDriver = "com.mysql.jdbc.Driver";
        public static final String dbURL = "jdbc:mysql://localhost:3306/spin";
        public static final String dbUser = "spin";
        public static final String dbPassword = "lcsspin";

        private Defaults() {
        }
    }
}

