/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.spin.tools.filter.CustomFileFilter;
import org.spin.tools.filter.FileFilterTool;
import sun.security.tools.KeyTool;

public abstract class KeytoolShellExec {
    private static final String QUOTE = "\"";

    public static void genKey(String hostname, String password, File keystoreFilename) throws IOException {
        String[] args = new String[]{"-genkeypair", "-alias ", hostname, "-dname", "cn=\"" + hostname + QUOTE, "-keystore", keystoreFilename.getAbsolutePath(), "-keypass", password, "-storepass", password, "-sigalg", "SHA1withRSA", "-keyalg", "RSA"};
        KeytoolShellExec.exec(args);
    }

    public static void exportPublicKey(String hostname, String password, File keystoreFilename) throws IOException {
        File certificateFilename = new File(keystoreFilename.getParentFile() + File.separator + keystoreFilename.getName() + ".cer");
        String[] args = new String[]{"-export", "-alias ", hostname, "-storepass", password, "-keystore", keystoreFilename.getAbsolutePath(), "-file", certificateFilename.getAbsolutePath()};
        KeytoolShellExec.exec(args);
    }

    public static void importPublicKey(String password, File keystoreFilename, File certificateFilename) throws IOException {
        if (certificateFilename.isDirectory()) {
            for (File cert : FileFilterTool.recursiveFilter((File)certificateFilename, (FileFilter)new CustomFileFilter("cer"))) {
                KeytoolShellExec.importPublicKey(password, keystoreFilename, cert);
            }
        } else {
            String[] args = new String[]{"-import", "-alias ", certificateFilename.getName(), "-storepass", password, "-keystore", keystoreFilename.getAbsolutePath(), "-file", certificateFilename.getAbsolutePath()};
            KeytoolShellExec.exec(args);
        }
    }

    private static void exec(String[] args) throws IOException {
        try {
            KeyTool.main((String[])args);
        }
        catch (Exception e) {
            throw new IOException("Failed to call Keytool.main(args)");
        }
    }
}

