/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class Merge {
    public static final String PACKAGE = "org.spin";
    private static final String GET = "get";
    private static final String SET = "set";

    private Merge() {
    }

    public static <T> T merge(T one, T two) {
        if (two == null) {
            return one;
        }
        if (one == null) {
            return two;
        }
        Class<?> clazz = one.getClass();
        T result = null;
        try {
            result = (T)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        for (Field field : Merge.findAllFields(clazz)) {
            Method getter = Merge.findGetter(field, clazz);
            Method setter = Merge.findSetter(field, clazz);
            if (getter == null || setter == null) continue;
            try {
                Object objOne = getter.invoke(one, new Object[0]);
                Object objTwo = getter.invoke(two, new Object[0]);
                Object value = field.getType().getName().toLowerCase().contains(PACKAGE) && !field.getType().isEnum() ? Merge.merge(objOne, objTwo) : (Collection.class.isAssignableFrom(field.getType()) ? Merge.mergeCollectionObjects(objOne, objTwo) : Merge.mergeObjects(objOne, objTwo));
                setter.invoke(result, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Object mergeObjects(Object one, Object two) {
        if (one != null) {
            return one;
        }
        return two;
    }

    private static Object mergeCollectionObjects(Object one, Object two) {
        if (one != null && two != null && one instanceof Collection && two instanceof Collection) {
            try {
                ArrayList result = new ArrayList();
                result.addAll((Collection)one);
                result.addAll((Collection)two);
                return result;
            }
            catch (Exception e) {
                return Merge.mergeObjects(one, two);
            }
        }
        return Merge.mergeObjects(one, two);
    }

    private static Collection<Field> findAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        allFields.addAll(Merge.findInheritedFields(clazz));
        return allFields;
    }

    private static Collection<Field> findInheritedFields(Class<?> baseClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> superClass = baseClass.getSuperclass();
        if (superClass != null && superClass.getName().toLowerCase().contains(PACKAGE)) {
            fieldList.addAll(Arrays.asList(superClass.getDeclaredFields()));
            fieldList.addAll(Merge.findInheritedFields(superClass));
        }
        return fieldList;
    }

    private static Method findGetter(Field field, Class<?> clazz) {
        for (String methodName : Merge.makeGetterMethodNames(field)) {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    private static Method findSetter(Field field, Class<?> clazz) {
        for (String methodName : Merge.makeSetterMethodNames(field)) {
            try {
                return clazz.getMethod(methodName, field.getType());
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    private static String[] makeGetterMethodNames(Field field) {
        String fieldName = field.getName();
        return new String[]{GET + Merge.firstCharToUpper(fieldName), GET + Merge.capitalizeFirstLowers(fieldName)};
    }

    private static String[] makeSetterMethodNames(Field field) {
        String fieldName = field.getName();
        return new String[]{SET + Merge.firstCharToUpper(fieldName), SET + Merge.capitalizeFirstLowers(fieldName)};
    }

    private static String firstCharToUpper(String str) {
        String firstChar = str.substring(0, 1).toUpperCase();
        return firstChar + str.substring(1, str.length());
    }

    private static String capitalizeFirstLowers(String str) {
        String retVal = null;
        if (str != null) {
            char c;
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length && !Character.isUpperCase(c = chars[i]); ++i) {
                if (!Character.isLowerCase(c)) continue;
                chars[i] = Character.toUpperCase(c);
            }
            retVal = new String(chars);
        }
        return retVal;
    }
}

