/*
 * Decompiled with CFR 0.152.
 */
package org.spin.extension.etl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.spin.extension.ETLXMLWorkarounds;
import org.spin.extension.config.URLConfig;
import org.spin.tools.JAXBUtils;
import org.spin.tools.JDBCTool;
import org.spin.tools.NetworkTime;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.ETLConfig;
import org.spin.tools.config.FileConfig;
import org.spin.tools.config.JDBCConfig;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.PipelineConfig;
import org.spin.tools.config.PipelineStepConfig;
import org.xml.sax.SAXException;

public abstract class Wizard {
    public String defaultDBDriver = "com.mysql.jdbc.Driver";
    public String defaultDBURL = "jdbc:mysql://localhost:3306/spinDB";
    public String defaultDBUsername = "spin";
    public String defaultDBPassword = "lcsspin";
    protected final File configurationFile = new File("ETLConfiguration.xml");
    protected ETLConfig etlConfig = new ETLConfig();
    protected final List<String> pipelineNames;

    public Wizard(List<String> pipelineNames) {
        this.pipelineNames = pipelineNames;
    }

    public PipelineConfig getPipelineConfig(String pipelineName) {
        List<PipelineStepConfig> loaderConfigs;
        List<PipelineStepConfig> transformerConfigs;
        PipelineStepConfig extractorStepConfig;
        PipelineConfig result = new PipelineConfig();
        result.setStreamingPipeline(Boolean.valueOf(false));
        result.setStreamSize(Integer.valueOf(1));
        while ((extractorStepConfig = this.getExtractorConfig(pipelineName)) == null) {
        }
        result.setExtractorStepConfig(extractorStepConfig);
        while ((transformerConfigs = this.getTransformerConfigs(pipelineName)) == null) {
        }
        result.getTransformationStepConfigs().addAll(transformerConfigs);
        while ((loaderConfigs = this.getLoaderConfigs(pipelineName)) == null) {
        }
        result.getLoaderStepConfigs().addAll(loaderConfigs);
        return result;
    }

    public void run() throws IOException, JAXBException, SAXException {
        if (this.configurationFile.exists()) {
            this.printLine("Loading defaults from " + this.configurationFile.getAbsolutePath());
            this.loadSavedConfiguration();
            this.backupOldConfiguration();
        }
        for (String pipelineName : this.pipelineNames) {
            PipelineConfig pipelineConfig;
            if (this.pipelineNames.size() != 1 && !this.promptPipeline(pipelineName)) continue;
            while ((pipelineConfig = this.getPipelineConfig(pipelineName)) == null) {
            }
            this.etlConfig.getPipelineConfigs().add(pipelineConfig);
        }
        if (!this.configurationFile.exists()) {
            this.configurationFile.createNewFile();
        }
        this.printLine();
        this.printLine("Writing configuration to '" + this.configurationFile.getAbsolutePath() + "'");
        ETLXMLWorkarounds.marshal(this.etlConfig, this.configurationFile);
        this.printLine("Done.");
    }

    public boolean promptPipeline(String pipelineName) throws IOException {
        this.printLine();
        return this.promptBoolean("Configure the " + pipelineName + " Pipeline? (Y/n)", "Y", "Y");
    }

    public boolean promptBoolean(String prompt, String defaultValue, String trueValue) throws IOException {
        return this.prompt(prompt, defaultValue).toUpperCase().equals(trueValue);
    }

    public void loadSavedConfiguration() throws JAXBException, IOException, SAXException {
        this.etlConfig = (ETLConfig)JAXBUtils.unmarshal((Reader)new FileReader(this.configurationFile), ETLConfig.class);
    }

    public void backupOldConfiguration() {
        String time = new NetworkTime().toString().replaceAll("[:]", "-");
        this.printLine("Creating backup configuration file, time= " + time);
        this.printLine();
        this.configurationFile.renameTo(new File("ETLConfiguration_backup_" + time + ".xml"));
    }

    protected abstract PipelineStepConfig getExtractorConfig(String var1);

    protected abstract List<PipelineStepConfig> getTransformerConfigs(String var1);

    protected abstract List<PipelineStepConfig> getLoaderConfigs(String var1);

    public ETLConfig getETLConfig() {
        return this.etlConfig;
    }

    public void setFirstPipeline(PipelineConfig defaultPipeline) {
        this.etlConfig.getPipelineConfigs().clear();
        this.etlConfig.getPipelineConfigs().add(defaultPipeline);
    }

    public PipelineConfig getFirstPipeline() {
        return this.etlConfig.getPipelineConfigs().size() > 0 ? (PipelineConfig)this.etlConfig.getPipelineConfigs().get(0) : null;
    }

    public List<PipelineConfig> getPipelines() {
        return this.etlConfig.getPipelineConfigs();
    }

    public BasicTarget promptBasicTarget(String prompt) throws IOException, IllegalArgumentException {
        this.printLine(" # " + prompt + " # ");
        this.printLine();
        this.printSpaces(prompt.length());
        this.choice(BasicTarget.DB.name(), "Database Connection");
        this.printLine();
        this.printSpaces(prompt.length());
        this.choice(BasicTarget.XML.name(), "XML Formatted File");
        this.printLine();
        this.printSpaces(prompt.length());
        this.choice(BasicTarget.SOAP.name(), "SOAP");
        this.printLine();
        this.printSpaces(prompt.length());
        this.choice(BasicTarget.CUSTOM.name(), "Custom");
        this.printLine();
        try {
            return BasicTarget.valueOf(this.prompt(prompt).toUpperCase());
        }
        catch (Exception e) {
            return this.promptBasicTarget(prompt);
        }
    }

    public File promptFile() throws IOException {
        return this.promptFile(null);
    }

    public File promptFile(String defaultLocation) throws IOException {
        FileConfig fileConfig = new FileConfig();
        fileConfig.setFilename(this.prompt("location", defaultLocation));
        if (!this.testValid(fileConfig)) {
            this.printLine("File location was invalid, please try again.");
            this.printLine();
            return this.promptFile(defaultLocation);
        }
        return new File(fileConfig.getFilename());
    }

    public URLConfig promptURL() throws IOException {
        return this.promptURL(null);
    }

    public URLConfig promptURL(String defaultURL) throws IOException {
        URLConfig url = new URLConfig();
        url.setUrl(this.prompt("URL", defaultURL));
        if (!this.testValid(url)) {
            this.printLine(" Specfiied URL was invalid, please try again.");
            this.printLine();
            return this.promptURL(defaultURL);
        }
        return url;
    }

    public JDBCConfig promptDB() throws IOException {
        JDBCConfig defaultDB = new JDBCConfig();
        defaultDB.setDriver(this.defaultDBDriver);
        defaultDB.setPassword(this.defaultDBPassword);
        defaultDB.setUrl(this.defaultDBURL);
        defaultDB.setUsername(this.defaultDBUsername);
        return this.promptDB(defaultDB);
    }

    public JDBCConfig promptDB(JDBCConfig defaultDB) throws IOException {
        JDBCConfig connection = new JDBCConfig();
        connection.setDriver(this.prompt("driver", defaultDB.getDriver()));
        connection.setUrl(this.prompt("URL", defaultDB.getUrl()));
        connection.setUsername(this.prompt("username", defaultDB.getUsername()));
        connection.setPassword(this.prompt("password", defaultDB.getPassword()));
        if (!this.testValid(connection)) {
            this.printLine(" JDBC connection was invalid, please try again.");
            this.printLine();
            return this.promptDB();
        }
        return connection;
    }

    public KeyStoreConfig promptKeyStore() throws IOException {
        return this.promptKeyStore(new KeyStoreConfig());
    }

    public KeyStoreConfig promptKeyStore(KeyStoreConfig defaultKeyStore) throws IOException {
        KeyStoreConfig keystore = null;
        try {
            File keystoreFile = new File(this.prompt("location", ConfigTool.getConfigFile((String)"keystore.xml").getAbsolutePath()));
            keystore = new KeyStoreConfig(keystoreFile, this.prompt("password", defaultKeyStore.getPassword()));
        }
        catch (Exception e) {
            this.printLine("Invalid keystore input, please try again.");
        }
        if (!this.testValid(keystore)) {
            this.printLine(" Keystore was invalid, please try again.");
            this.printLine(" Your settings: " + keystore.getFile().getAbsolutePath() + " " + keystore.getPassword());
            this.printLine();
            return this.promptKeyStore(defaultKeyStore);
        }
        return keystore;
    }

    public boolean testValid(FileConfig fileConfig) {
        return this.testValid(new File(fileConfig.getFilename()));
    }

    public boolean testValid(File file) {
        try {
            this.printLine("looking for " + file.getAbsolutePath());
            if (file.exists()) {
                this.printLine("Found " + file.getAbsolutePath());
                this.printLine();
                return true;
            }
            this.printLine("File not found! " + file.getAbsolutePath());
            this.printLine();
            return false;
        }
        catch (Exception e) {
            this.printLine("Invalid file specified");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testValid(JDBCConfig jdbc) {
        Connection conn = null;
        try {
            conn = JDBCTool.getConnection((JDBCConfig)jdbc);
            this.printLine("Test Connection successfull ! ");
            this.printLine("driver=" + jdbc.getDriver());
            this.printLine("URL=" + jdbc.getUrl());
            this.printLine("username=" + jdbc.getUsername());
            this.printLine("password=" + jdbc.getPassword());
            this.printLine();
            boolean bl = true;
            return bl;
        }
        catch (ConfigException e) {
            this.printLine("Test Connection FAILED!");
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException eaten) {}
            }
        }
    }

    public boolean testValid(KeyStoreConfig keystore) {
        if (keystore == null) {
            return false;
        }
        try {
            PKITool.getInstance();
            this.printLine("Keystore settings are valid!");
            this.printLine();
            return true;
        }
        catch (ConfigException e) {
            this.printLine("Could not load keystore !");
            this.printLine();
            return false;
        }
    }

    public boolean testValid(URLConfig url) {
        try {
            new URL(url.getUrl());
            this.printLine("URL is well formed.");
            this.printLine();
            return true;
        }
        catch (MalformedURLException e) {
            this.printLine("Malformed URL!");
            this.printLine();
            return false;
        }
    }

    public String prompt(String prompt) throws IOException {
        this.print(prompt);
        this.print("= ");
        return this.readLine();
    }

    public String prompt(String prompt, String defaultValue) throws IOException {
        this.print(prompt);
        if (defaultValue != null && defaultValue.length() > 0) {
            this.printLine(" (default '" + defaultValue + "')");
        }
        this.print("= ");
        String input = this.readLine();
        return input.length() == 0 ? defaultValue : input;
    }

    public void choice(String choice, String description) {
        this.print("[" + choice + "]");
        this.printSpaces(3);
        this.print(description);
    }

    public void printSpaces(int numSpaces) {
        for (int i = 0; i <= numSpaces; ++i) {
            System.out.print(" ");
        }
    }

    public String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    public void print(String print) {
        System.out.print(print);
    }

    public void printLine() {
        System.out.println();
    }

    public void printLine(String print) {
        System.out.println(print);
    }

    public boolean equals(String input, String match) {
        return input.trim().equalsIgnoreCase(match.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents(File sourceFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
        try {
            StringBuffer contents = new StringBuffer();
            while (reader.ready()) {
                contents.append(reader.readLine());
            }
            String string = contents.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static enum BasicTarget {
        DB,
        XML,
        SOAP,
        CUSTOM;

    }
}

