/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.monitor.scanner;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import net.shrine.serializers.crc.CRCQueryStatus;
import net.shrine.serializers.crc.CRCSerializer;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

public class ReqResPair {
    private List<NodeResponse> nodes = Util.makeArrayList();
    private RequestMessageType request;
    private ResponseMessageType response;
    private String queryMasterID;
    private CRCQueryStatus status;
    private int panels = 0;
    private int items = 0;
    private long tSTART;
    private long tEND;

    public void setRequest(RequestMessageType request) throws SerializationException {
        this.request = request;
        QueryDefinitionType definition = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)request).getQueryDefinition();
        this.panels = definition.getPanel().size();
        for (PanelType panel : definition.getPanel()) {
            this.items += panel.getItem().size();
        }
    }

    public void setResponse(ResponseMessageType response) throws SerializationException {
        this.response = response;
        this.status = CRCSerializer.getQueryStatus((ResponseMessageType)response);
        this.queryMasterID = CRCSerializer.getQueryMasterID((ResponseMessageType)response);
        for (QueryResultInstanceType queryResult : CRCSerializer.getQueryResults((ResponseMessageType)response)) {
            NodeResponse node = new NodeResponse();
            node.queryMasterID = this.queryMasterID;
            node.nodeID = queryResult.getDescription();
            node.setSize = queryResult.getSetSize();
            node.endTime = queryResult.getStartDate();
            node.startTime = queryResult.getEndDate();
            this.nodes.add(node);
        }
    }

    public RequestMessageType getRequest() {
        return this.request;
    }

    public ResponseMessageType getResponse() {
        return this.response;
    }

    public void start() {
        this.tSTART = System.currentTimeMillis();
    }

    public void end() {
        this.tEND = System.currentTimeMillis();
    }

    public List<NodeResponse> getNodes() {
        return this.nodes;
    }

    public String getQueryMasterID() {
        return this.queryMasterID;
    }

    public CRCQueryStatus getStatus() {
        return this.status;
    }

    public int getPanels() {
        return this.panels;
    }

    public int getItems() {
        return this.items;
    }

    public long gettSTART() {
        return this.tSTART;
    }

    public long gettEND() {
        return this.tEND;
    }

    public class NodeResponse {
        String queryMasterID;
        String nodeID;
        int setSize;
        XMLGregorianCalendar startTime;
        XMLGregorianCalendar endTime;
    }
}

