/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.networkhealth;

import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import cats.effect.IO;
import cats.effect.IO$;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Error;
import io.circe.HCursor;
import io.circe.config.syntax;
import io.circe.config.syntax$;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Log$;
import net.shrine.networkhealth.ConnectivityTestData;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.ResearcherId;
import net.shrine.protocol.version.v1.ConnectivityTest;
import net.shrine.protocol.version.v1.Query;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple5;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LambdaDeserialize;
import scala.runtime.SymbolLiteral;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import shapeless.;
import shapeless.DefaultSymbolicLabelling;
import shapeless.Generic;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.lazily$;
import shapeless.ops.hlist;

public final class ConnectivityTestData$
implements scala.Serializable {
    public static ConnectivityTestData$ MODULE$;

    static {
        new ConnectivityTestData$();
    }

    public Option<ConnectivityTestData> fromConfig() {
        None$ none$;
        Config connectivityTestConfig = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getConfigOrEmpty("shrine.hub.networkHealth.connectivityTest");
        if (connectivityTestConfig.hasPath("queryId") && new StringOps(Predef$.MODULE$.augmentString(connectivityTestConfig.getString("queryId"))).nonEmpty()) {
            None$ none$2;
            public final class Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1
            implements scala.Serializable {
                private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>> inst$macro$14;
                private DerivedDecoder<ConnectivityTest> inst$macro$1;
                private volatile byte bitmap$0;

                private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>> inst$macro$14$lzycompute() {
                    Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 1) == 0) {
                            this.inst$macro$14 = new ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>>(null){
                                private final Decoder<String> circeGenericDecoderFordelay;
                                private final Decoder<Option<Object>> circeGenericDecoderForlastUpdated;
                                private volatile byte bitmap$init$0;

                                public final Either<DecodingFailure, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>> apply(HCursor c) {
                                    return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecode(c.downField("queryId")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecode(c.downField("interval")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecode(c.downField("timeLimit")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecode(c.downField("delay")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForlastUpdated.tryDecode(c.downField("lastUpdated")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                                }

                                public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>> decodeAccumulating(HCursor c) {
                                    return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecodeAccumulating(c.downField("queryId")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecodeAccumulating(c.downField("interval")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecodeAccumulating(c.downField("timeLimit")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFordelay.tryDecodeAccumulating(c.downField("delay")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForlastUpdated.tryDecodeAccumulating(c.downField("lastUpdated")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                                }
                                {
                                    this.circeGenericDecoderFordelay = Decoder$.MODULE$.decodeString();
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                                    this.circeGenericDecoderForlastUpdated = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeLong());
                                    this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                                }
                            };
                            this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                        }
                    }
                    return this.inst$macro$14;
                }

                public ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>>> inst$macro$14() {
                    return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$14$lzycompute() : this.inst$macro$14;
                }

                private DerivedDecoder<ConnectivityTest> inst$macro$1$lzycompute() {
                    Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1 var1_1 = this;
                    synchronized (var1_1) {
                        if ((byte)(this.bitmap$0 & 2) == 0) {
                            public final class Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1$anon$macro$13$1
                            implements Generic<ConnectivityTest> {
                                public .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>> to(ConnectivityTest p) {
                                    ConnectivityTest connectivityTest = p;
                                    if (connectivityTest == null) {
                                        throw new MatchError((Object)connectivityTest);
                                    }
                                    String pat$macro$8 = connectivityTest.queryId();
                                    String pat$macro$9 = connectivityTest.interval();
                                    String pat$macro$10 = connectivityTest.timeLimit();
                                    String pat$macro$11 = connectivityTest.delay();
                                    Option pat$macro$12 = connectivityTest.lastUpdated();
                                    .colon.colon colon2 = new .colon.colon((Object)pat$macro$8, (HList)new .colon.colon((Object)pat$macro$9, (HList)new .colon.colon((Object)pat$macro$10, (HList)new .colon.colon((Object)pat$macro$11, (HList)new .colon.colon((Object)pat$macro$12, (HList)HNil$.MODULE$)))));
                                    return colon2;
                                }

                                public ConnectivityTest from(.colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>> p) {
                                    Option pat$macro$12;
                                    String pat$macro$11;
                                    String pat$macro$10;
                                    String pat$macro$9;
                                    String pat$macro$8;
                                    block3: {
                                        .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<String, .colon.colon<Option<Object>, HNil>>>>> colon2;
                                        block2: {
                                            colon2 = p;
                                            if (colon2 == null) break block2;
                                            pat$macro$8 = (String)colon2.head();
                                            .colon.colon colon3 = (.colon.colon)colon2.tail();
                                            if (colon3 == null) break block2;
                                            pat$macro$9 = (String)colon3.head();
                                            .colon.colon colon4 = (.colon.colon)colon3.tail();
                                            if (colon4 == null) break block2;
                                            pat$macro$10 = (String)colon4.head();
                                            .colon.colon colon5 = (.colon.colon)colon4.tail();
                                            if (colon5 == null) break block2;
                                            pat$macro$11 = (String)colon5.head();
                                            .colon.colon colon6 = (.colon.colon)colon5.tail();
                                            if (colon6 == null) break block2;
                                            pat$macro$12 = (Option)colon6.head();
                                            HNil hNil = (HNil)colon6.tail();
                                            if (HNil$.MODULE$.equals(hNil)) break block3;
                                        }
                                        throw new MatchError(colon2);
                                    }
                                    ConnectivityTest connectivityTest = new ConnectivityTest(pat$macro$8, pat$macro$9, pat$macro$10, pat$macro$11, pat$macro$12);
                                    return connectivityTest;
                                }

                                public Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1$anon$macro$13$1(Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1 $outer) {
                                }
                            }
                            this.inst$macro$1 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct((DefaultSymbolicLabelling)new DefaultSymbolicLabelling<ConnectivityTest>(null){

                                public .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, .colon.colon<Symbol, HNil>>>>> apply() {
                                    return new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "queryId"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "interval"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "timeLimit"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "delay"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "lastUpdated"), (HList)HNil$.MODULE$)))));
                                }
                            }, (Generic)new Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1$anon$macro$13$1(null), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "lastUpdated"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "delay"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "timeLimit"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "interval"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "queryId"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$14()));
                            this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                        }
                    }
                    return this.inst$macro$1;
                }

                public DerivedDecoder<ConnectivityTest> inst$macro$1() {
                    return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$1$lzycompute() : this.inst$macro$1;
                }

                public Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1() {
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(net.shrine.networkhealth.ConnectivityTestData$anon$importedDecoder$macro$15$1 )}, serializedLambda);
                }
            }
            DerivedDecoder<ConnectivityTest> inst$macro$16 = new Net_shrine_networkhealth_ConnectivityTestData$anon$importedDecoder$macro$15$1().inst$macro$1();
            Either either = syntax.CirceConfigOps$.MODULE$.as$extension0(syntax$.MODULE$.CirceConfigOps(connectivityTestConfig), Decoder$.MODULE$.importedDecoder((Decoder)lazily$.MODULE$.apply(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$16))));
            if (either instanceof Right) {
                Right right = (Right)either;
                ConnectivityTest connectivityTest = (ConnectivityTest)right.value();
                none$2 = this.fromConnectivityTest(connectivityTest);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                Error e = (Error)left.value();
                Log$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("An error occurred while loading the network health connectivity test config: ").append(e).toString());
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)either);
            }
            none$ = none$2;
        } else {
            Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> "No connectivity test configured");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<ConnectivityTestData> fromConnectivityTest(ConnectivityTest connectivityTest) {
        FiniteDuration interval = ConnectivityTestData$.parseDuration$1(connectivityTest.interval());
        FiniteDuration timeLimit = ConnectivityTestData$.parseDuration$1(connectivityTest.timeLimit());
        FiniteDuration delay = ConnectivityTestData$.parseDuration$1(connectivityTest.delay());
        long queryId = new StringOps(Predef$.MODULE$.augmentString(connectivityTest.queryId())).toLong();
        return (Option)HubDb$.MODULE$.db().selectQueryIO(queryId).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                Query q = (Query)some.value();
                Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Found query with id ").append(queryId).append(" and about to schedule the network health connectivity test").toString());
                none$ = new Some((Object)new ConnectivityTestData(queryId, q.researcherId(), interval, timeLimit, delay));
            } else if (None$.MODULE$.equals(option)) {
                Log$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> "Unable to find the query id specified for the connectivity test");
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            return none$;
        }).handleErrorWith((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Throwable throwable = x0$2;
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty()) {
                throw new MatchError((Object)throwable);
            }
            Throwable nfx = (Throwable)option.get();
            Log$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> "An error occurred while loading the networkHealth config in shrine.conf", nfx);
            IO iO = IO$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
            return iO;
        }).unsafeRunSync();
    }

    public ConnectivityTestData apply(long queryId, long researcherId, FiniteDuration interval, FiniteDuration timeLimit, FiniteDuration delay) {
        return new ConnectivityTestData(queryId, researcherId, interval, timeLimit, delay);
    }

    public Option<Tuple5<QueryId, ResearcherId, FiniteDuration, FiniteDuration, FiniteDuration>> unapply(ConnectivityTestData x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)new QueryId(x$0.queryId()), (Object)new ResearcherId(x$0.researcherId()), (Object)x$0.interval(), (Object)x$0.timeLimit(), (Object)x$0.delay()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final FiniteDuration parseDuration$1(String durationString) {
        return (FiniteDuration)new Some((Object)Duration$.MODULE$.apply(durationString)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FiniteDuration finiteDuration;
                A1 A1 = x1;
                Object object = A1 instanceof FiniteDuration ? (finiteDuration = (FiniteDuration)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Duration x1) {
                Duration duration = x1;
                boolean bl = duration instanceof FiniteDuration;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NumberFormatException(new StringBuilder(24).append(durationString).append(" is not a FiniteDuration").toString());
        });
    }

    private ConnectivityTestData$() {
        MODULE$ = this;
    }
}

