/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.i2b2Protocol;

import java.io.Serializable;
import net.shrine.adapter.i2b2Protocol.RunQueryRequest;
import net.shrine.adapter.i2b2Protocol.ShrineRequestUnmarshaller;
import net.shrine.adapter.i2b2Protocol.XmlNodeName;
import net.shrine.adapter.i2b2Protocol.XmlNodeName$;
import net.shrine.adapter.i2b2Protocol.query.I2b2QueryDefinition;
import net.shrine.adapter.i2b2Protocol.query.I2b2QueryDefinition$;
import net.shrine.crypto.SecureRandomSource$;
import net.shrine.protocol.i2b2.AuthenticationInfo;
import net.shrine.protocol.i2b2.I2b2XmlUnmarshaller;
import net.shrine.protocol.i2b2.RequestHeader;
import net.shrine.protocol.i2b2.ResultOutputType;
import net.shrine.protocol.i2b2.ResultOutputType$;
import net.shrine.protocol.i2b2.ShrineXmlUnmarshaller;
import net.shrine.protocol.i2b2.serialization.I2b2UnmarshallingHelpers;
import net.shrine.util.Tries$;
import net.shrine.xml.NodeSeqEnrichments;
import net.shrine.xml.XmlUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple8;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;

public final class RunQueryRequest$
implements I2b2XmlUnmarshaller<RunQueryRequest>,
ShrineXmlUnmarshaller<RunQueryRequest>,
ShrineRequestUnmarshaller,
I2b2UnmarshallingHelpers,
Serializable {
    public static final RunQueryRequest$ MODULE$ = new RunQueryRequest$();
    private static final String neededI2b2Namespace;
    private static volatile boolean bitmap$init$0;

    static {
        I2b2XmlUnmarshaller.$init$((I2b2XmlUnmarshaller)MODULE$);
        ShrineXmlUnmarshaller.$init$((ShrineXmlUnmarshaller)MODULE$);
        ShrineRequestUnmarshaller.$init$(MODULE$);
        I2b2UnmarshallingHelpers.$init$((I2b2UnmarshallingHelpers)MODULE$);
        neededI2b2Namespace = "http://www.i2b2.org/xsd/cell/crc/psm/1.1/";
        bitmap$init$0 = true;
    }

    public final Try<RequestHeader> i2b2Header(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2Header$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<String> i2b2ProjectId(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2ProjectId$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<Duration> i2b2WaitTime(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2WaitTime$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<AuthenticationInfo> i2b2AuthenticationInfo(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2AuthenticationInfo$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    @Override
    public final Try<RequestHeader> shrineHeader(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineHeader$(this, xml);
    }

    @Override
    public final Try<String> shrineProjectId(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineProjectId$(this, xml);
    }

    @Override
    public final Try<Duration> shrineWaitTime(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineWaitTime$(this, xml);
    }

    @Override
    public final Try<AuthenticationInfo> shrineAuthenticationInfo(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineAuthenticationInfo$(this, xml);
    }

    public Try<RunQueryRequest> fromXmlString(Set<ResultOutputType> breakdownTypes, String xmlString) {
        return ShrineXmlUnmarshaller.fromXmlString$((ShrineXmlUnmarshaller)this, breakdownTypes, (String)xmlString);
    }

    public Try<RunQueryRequest> fromI2b2String(Set<ResultOutputType> breakdownTypes, String xmlString) {
        return I2b2XmlUnmarshaller.fromI2b2String$((I2b2XmlUnmarshaller)this, breakdownTypes, (String)xmlString);
    }

    public Option<XmlNodeName> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public RunQueryRequest apply(String projectId, Duration waitTime, AuthenticationInfo authn, Option<Tuple2<String, String>> topicIdAndName, Set<ResultOutputType> outputTypes, I2b2QueryDefinition queryDefinition) {
        return new RunQueryRequest(projectId, waitTime, authn, SecureRandomSource$.MODULE$.nextId(), topicIdAndName, outputTypes, queryDefinition, this.apply$default$8());
    }

    public Option<XmlNodeName> apply$default$8() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<String, String>> toTopicIdAndName(Option<String> topicId, Option<String> topicName) {
        Tuple2 tuple2 = new Tuple2(topicId, topicName);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
        }
        if (tuple2 == null) throw new IllegalStateException(new StringBuilder(26).append("topicId is ").append(topicId).append(", topicName is ").append(topicName).toString());
        Option option = (Option)tuple2._1();
        Option option3 = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new IllegalStateException(new StringBuilder(26).append("topicId is ").append(topicId).append(", topicName is ").append(topicName).toString());
        Some some = (Some)option;
        String id = (String)some.value();
        if (!(option3 instanceof Some)) throw new IllegalStateException(new StringBuilder(26).append("topicId is ").append(topicId).append(", topicName is ").append(topicName).toString());
        Some some2 = (Some)option3;
        String name = (String)some2.value();
        return new Some((Object)new Tuple2((Object)id, (Object)name));
    }

    public String neededI2b2Namespace() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-TRUNK445-JOB1/adapter/service/src/main/scala/net/shrine/adapter/i2b2Protocol/RunQueryRequest.scala: 125");
        }
        return neededI2b2Namespace;
    }

    public Try<RunQueryRequest> fromI2b2(Set<ResultOutputType> breakdownTypes, NodeSeq xml) {
        NodeSeq queryDefNode = xml.$bslash("message_body").$bslash("request").$bslash("query_definition");
        Node node = (Node)queryDefNode.head();
        if (!(node instanceof Elem)) {
            throw new Exception(new StringBuilder(106).append("When unmarshalling a RunQueryRequest, encountered unexpected XML: '").append(queryDefNode).append("', <query_definition> might be missing.").toString());
        }
        Elem elem = (Elem)node;
        Elem elem2 = elem.copy(elem.scope().getPrefix(this.neededI2b2Namespace()), elem.copy$default$2(), elem.copy$default$3(), elem.copy$default$4(), elem.copy$default$5(), elem.copy$default$6());
        Elem queryDefXml = elem2;
        Try attempt = this.i2b2ProjectId(xml).flatMap((Function1 & Serializable)projectId -> MODULE$.i2b2WaitTime(xml).flatMap((Function1 & Serializable)waitTime -> MODULE$.i2b2AuthenticationInfo(xml).map((Function1 & Serializable)authn -> {
            Option topicId = xml.$bslash("message_body").$bslash("shrine").$bslash("queryTopicID").headOption().map((Function1 & Serializable)xml -> XmlUtil$.MODULE$.trim(xml));
            Option topicName = xml.$bslash("message_body").$bslash("shrine").$bslash("queryTopicName").headOption().map((Function1 & Serializable)xml -> XmlUtil$.MODULE$.trim(xml));
            Set<ResultOutputType> outputTypes = MODULE$.determineI2b2OutputTypes(breakdownTypes, xml.$bslash("message_body").$bslash("request").$bslash("result_output_list"));
            return new Tuple4(authn, (Object)topicId, (Object)topicName, outputTypes);
        }).flatMap((Function1 & Serializable)x$9 -> {
            Tuple4 tuple4 = x$9;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            AuthenticationInfo authn = (AuthenticationInfo)tuple4._1();
            Option topicId = (Option)tuple4._2();
            Option topicName = (Option)tuple4._3();
            Set outputTypes = (Set)tuple4._4();
            Try try_ = I2b2QueryDefinition$.MODULE$.fromI2b2((NodeSeq)queryDefXml).map((Function1 & Serializable)queryDef -> MODULE$.apply((String)projectId, (Duration)waitTime, authn, MODULE$.toTopicIdAndName((Option<String>)topicId, (Option<String>)topicName), (Set<ResultOutputType>)outputTypes, (I2b2QueryDefinition)queryDef));
            return try_;
        })));
        return attempt.map((Function1 & Serializable)req -> MODULE$.addPatientCountXmlIfNecessary((RunQueryRequest)req));
    }

    public Set<ResultOutputType> determineI2b2OutputTypes(Set<ResultOutputType> breakdownTypes, NodeSeq nodeSeq) {
        Seq sequence = (Seq)nodeSeq.$bslash("result_output").flatMap((Function1 & Serializable)breakdownXml -> {
            String breakdownName = XmlUtil$.MODULE$.trim(breakdownXml.$bslash("@name"));
            return ResultOutputType$.MODULE$.valueOf(breakdownTypes, breakdownName);
        });
        return sequence.toSet();
    }

    public Set<ResultOutputType> determineShrineOutputTypes(NodeSeq nodeSeq) {
        Seq attempts = (Seq)nodeSeq.$bslash("resultType").map((Function1 & Serializable)xml -> ResultOutputType$.MODULE$.fromXml(xml));
        return (Set)Tries$.MODULE$.sequence((Iterable)attempts).map((Function1 & Serializable)x$10 -> x$10.toSet()).get();
    }

    public RunQueryRequest addPatientCountXmlIfNecessary(RunQueryRequest req) {
        RunQueryRequest runQueryRequest;
        if (req.outputTypes().contains((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML())) {
            runQueryRequest = req;
        } else {
            Set x$1 = (Set)req.outputTypes().$plus((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML());
            String x$2 = req.copy$default$1();
            Duration x$3 = req.copy$default$2();
            AuthenticationInfo x$4 = req.copy$default$3();
            long x$5 = req.copy$default$4();
            Option<Tuple2<String, String>> x$6 = req.copy$default$5();
            I2b2QueryDefinition x$7 = req.copy$default$7();
            Option<XmlNodeName> x$8 = req.copy$default$8();
            runQueryRequest = req.copy(x$2, x$3, x$4, x$5, x$6, (Set<ResultOutputType>)x$1, x$7, x$8);
        }
        return runQueryRequest;
    }

    public Try<RunQueryRequest> fromXml(Set<ResultOutputType> breakdownTypes, NodeSeq xml) {
        Try attempt = this.shrineProjectId(xml).flatMap((Function1 & Serializable)projectId -> MODULE$.shrineWaitTime(xml).flatMap((Function1 & Serializable)waitTime -> MODULE$.shrineAuthenticationInfo(xml).flatMap((Function1 & Serializable)authn -> NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml), "queryId").map((Function1 & Serializable)xml -> BoxesRunTime.boxToLong((long)XmlUtil$.MODULE$.toLong(xml))).map((Function1 & Serializable)queryId -> RunQueryRequest$.$anonfun$fromXml$5(xml, BoxesRunTime.unboxToLong((Object)queryId))).flatMap((Function1 & Serializable)x$11 -> {
            Tuple3 tuple3 = x$11;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long queryId = BoxesRunTime.unboxToLong((Object)tuple3._1());
            Option topicId = (Option)tuple3._2();
            Option topicName = (Option)tuple3._3();
            Try try_ = NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml), "outputTypes").map((Function1 & Serializable)nodeSeq -> MODULE$.determineShrineOutputTypes((NodeSeq)nodeSeq)).flatMap((Function1 & Serializable)outputTypes -> NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml), I2b2QueryDefinition$.MODULE$.rootTagName()).flatMap((Function1 & Serializable)nodeSeq -> I2b2QueryDefinition$.MODULE$.fromXml((NodeSeq)nodeSeq)).flatMap((Function1 & Serializable)queryDef -> XmlNodeName$.MODULE$.fromXmlOption(xml.$bslash("nodeId")).map((Function1 & Serializable)nodeId -> new RunQueryRequest((String)projectId, (Duration)waitTime, (AuthenticationInfo)authn, queryId, MODULE$.toTopicIdAndName((Option<String>)topicId, (Option<String>)topicName), (Set<ResultOutputType>)outputTypes, (I2b2QueryDefinition)queryDef, (Option<XmlNodeName>)nodeId))));
            return try_;
        }))));
        return attempt.map((Function1 & Serializable)req -> MODULE$.addPatientCountXmlIfNecessary((RunQueryRequest)req));
    }

    public RunQueryRequest apply(String projectId, Duration waitTime, AuthenticationInfo authn, long networkQueryId, Option<Tuple2<String, String>> topicIdAndName, Set<ResultOutputType> outputTypes, I2b2QueryDefinition queryDefinition, Option<XmlNodeName> nodeId) {
        return new RunQueryRequest(projectId, waitTime, authn, networkQueryId, topicIdAndName, outputTypes, queryDefinition, nodeId);
    }

    public Option<Tuple8<String, Duration, AuthenticationInfo, Object, Option<Tuple2<String, String>>, Set<ResultOutputType>, I2b2QueryDefinition, Option<XmlNodeName>>> unapply(RunQueryRequest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.projectId(), (Object)x$0.waitTime(), (Object)x$0.authn(), (Object)BoxesRunTime.boxToLong((long)x$0.networkQueryId()), x$0.topicIdAndName(), x$0.outputTypes(), (Object)x$0.queryDefinition(), x$0.nodeId()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RunQueryRequest$.class);
    }

    public static final /* synthetic */ Tuple3 $anonfun$fromXml$5(NodeSeq xml$2, long queryId) {
        Option topicId = xml$2.$bslash("topicId").headOption().map((Function1 & Serializable)xml -> XmlUtil$.MODULE$.trim(xml));
        Option topicName = xml$2.$bslash("topicName").headOption().map((Function1 & Serializable)xml -> XmlUtil$.MODULE$.trim(xml));
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)queryId), (Object)topicId, (Object)topicName);
    }

    private RunQueryRequest$() {
    }
}

