/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.setup;

import java.io.Serializable;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.hub.setup.ShrineNetworkLifecycle;
import net.shrine.hub.setup.ShrineNetworkLifecycle$;
import net.shrine.hub.setup.WrongArgumentsException;
import net.shrine.protocol.version.MomQueueName$;
import net.shrine.protocol.version.NetworkId$;
import net.shrine.protocol.version.v2.Network;
import net.shrine.protocol.version.v2.Network$;
import net.shrine.protocol.version.v2.Node;
import net.shrine.protocol.version.v2.Node$;
import net.shrine.protocol.version.v2.VersionInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000594A\u0001E\t\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003BB\u001f\u0001A\u0003%q\u0005C\u0003?\u0001\u0011\u0005q\bC\u0004Q\u0001\t\u0007I\u0011A)\t\rU\u0003\u0001\u0015!\u0003S\u0011\u00151\u0006\u0001\"\u0001@\u0011\u0015A\u0006\u0001\"\u0001@\u0011\u0015Q\u0006\u0001\"\u0001@\u0011\u0015a\u0006\u0001\"\u0001@\u0011\u0015q\u0006\u0001\"\u0001@\u0011\u0015\u0001\u0007\u0001\"\u0001@\u0011\u0015\u0011\u0007\u0001\"\u0001@\u0011\u0015!\u0007\u0001\"\u0001@\u0011\u0015I\u0007\u0001\"\u0001@\u0005i\u0019\u0006N]5oK:+Go^8sW2Kg-Z2zG2,G+Z:u\u0015\t\u00112#A\u0003tKR,\bO\u0003\u0002\u0015+\u0005\u0019\u0001.\u001e2\u000b\u0005Y9\u0012AB:ie&tWMC\u0001\u0019\u0003\rqW\r^\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003E\tQ#\u001a=qK\u000e$X\r\u001a(pI\u0016$V-\u001c9mCR,7/F\u0001(!\rA\u0003g\r\b\u0003S9r!AK\u0017\u000e\u0003-R!\u0001L\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012BA\u0018\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u0007M+\u0017O\u0003\u00020;A\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0003mJR!\u0001O\u001d\u0002\u000fY,'o]5p]*\u0011!(F\u0001\taJ|Go\\2pY&\u0011A(\u000e\u0002\u0005\u001d>$W-\u0001\ffqB,7\r^3e\u001d>$W\rV3na2\fG/Z:!\u0003!!Xm\u001d;IK2\u0004H#\u0001!\u0011\u0005q\t\u0015B\u0001\"\u001e\u0005\u0011)f.\u001b;)\u0005\u0011!\u0005CA#O\u001b\u00051%BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u0013*\u000bqA[;qSR,'O\u0003\u0002L\u0019\u0006)!.\u001e8ji*\tQ*A\u0002pe\u001eL!a\u0014$\u0003\tQ+7\u000f^\u0001\u0010i\u0016l\u0007\u000f\\1uK:+Go^8sWV\t!\u000b\u0005\u00025'&\u0011A+\u000e\u0002\b\u001d\u0016$xo\u001c:l\u0003A!X-\u001c9mCR,g*\u001a;x_J\\\u0007%A\tuKN$8I]3bi\u0016tU\r^<pe.D#a\u0002#\u0002AQ,7\u000f^\"sK\u0006$XMT3uo>\u00148\u000eV<jG\u0016\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c\u0015\u0003\u0011\u0011\u000b\u0011\u0003^3ti6{G-\u001b4z\u001d\u0016$xo\u001c:lQ\tIA)A\fuKN$8\u000b[8x\u001d\u0016$xo\u001c:l\u0003:$gj\u001c3fg\"\u0012!\u0002R\u0001\u000fi\u0016\u001cHo\u0011:fCR,gj\u001c3fQ\tYA)\u0001\buKN$Xj\u001c3jMftu\u000eZ3)\u00051!\u0015!\u0006;fgR\u0014V\r^5sKJ+7\u000f^8sK:{G-\u001a\u0015\u0003\u001b\u0011\u000b!BY3g_J,W)Y2iQ\tqa\r\u0005\u0002FO&\u0011\u0001N\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!C1gi\u0016\u0014X)Y2iQ\ty1\u000e\u0005\u0002FY&\u0011QN\u0012\u0002\n\u0003\u001a$XM]#bG\"\u0004")
public class ShrineNetworkLifecycleTest {
    private final Seq<Node> expectedNodeTemplates;
    private final Network templateNetwork;
    private volatile byte bitmap$init$0;

    public Seq<Node> expectedNodeTemplates() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-GFRELEASE-JOB1/tmp.6F1rnfqn7T/hub/network-lifecycle-tool/src/test/scala/net/shrine/hub/setup/ShrineNetworkLifecycleTest.scala: 11");
        }
        return this.expectedNodeTemplates;
    }

    @Test
    public void testHelp() {
        ShrineNetworkLifecycle.Help$.MODULE$.doIt((String[])((Object[])new String[]{"help"})).unsafeRunSync();
        ShrineNetworkLifecycle$.MODULE$.commands().foreach((Function1 & Serializable)command -> {
            ShrineNetworkLifecycleTest.$anonfun$testHelp$1(command);
            return BoxedUnit.UNIT;
        });
    }

    public Network templateNetwork() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /var/opt/bamboo/bamboo-home/local-working-dir/SHRINE-GFRELEASE-JOB1/tmp.6F1rnfqn7T/hub/network-lifecycle-tool/src/test/scala/net/shrine/hub/setup/ShrineNetworkLifecycleTest.scala: 48");
        }
        return this.templateNetwork;
    }

    @Test
    public void testCreateNetwork() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync();
        VersionInfo x$1 = network.versionInfo();
        long x$22 = this.templateNetwork().copy$default$1();
        String x$32 = this.templateNetwork().copy$default$3();
        String x$4 = this.templateNetwork().copy$default$4();
        String x$5 = this.templateNetwork().copy$default$5();
        String x$6 = this.templateNetwork().copy$default$6();
        Option x$7 = this.templateNetwork().copy$default$7();
        Network expectedNetwork = this.templateNetwork().copy(x$22, x$1, x$32, x$4, x$5, x$6, x$7);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Seq nodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectAllNodesIO().unsafeRunSync()).map((Function1 & Serializable)x$2 -> (Node)x$2.get())).toSeq().sortBy((Function1 & Serializable)x$3 -> x$3.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)nodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
        Assertions.assertEquals((Object)expectedNodes, (Object)nodes);
    }

    @Test
    public void testCreateNetworkTwiceShouldFail() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Assertions.assertThrows(WrongArgumentsException.class, () -> ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"})));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync();
        VersionInfo x$1 = network.versionInfo();
        long x$2 = this.templateNetwork().copy$default$1();
        String x$3 = this.templateNetwork().copy$default$3();
        String x$42 = this.templateNetwork().copy$default$4();
        String x$52 = this.templateNetwork().copy$default$5();
        String x$6 = this.templateNetwork().copy$default$6();
        Option x$7 = this.templateNetwork().copy$default$7();
        Network expectedNetwork = this.templateNetwork().copy(x$2, x$1, x$3, x$42, x$52, x$6, x$7);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Seq nodes = (Seq)((IterableOnceOps)((IterableOps)HubDb$.MODULE$.db().selectAllNodesIO().unsafeRunSync()).map((Function1 & Serializable)x$4 -> (Node)x$4.get())).toSeq().sortBy((Function1 & Serializable)x$5 -> x$5.key(), (Ordering)Ordering.String$.MODULE$);
        Seq expectedNodes = (Seq)((IterableOps)this.expectedNodeTemplates().zip((IterableOnce)nodes)).map((Function1 & Serializable)nodePair -> ((Node)nodePair._1()).copy(((Node)nodePair._2()).id(), ((Node)nodePair._2()).versionInfo(), ((Node)nodePair._1()).copy$default$3(), ((Node)nodePair._1()).copy$default$4(), ((Node)nodePair._1()).copy$default$5(), ((Node)nodePair._1()).copy$default$6(), ((Node)nodePair._1()).copy$default$7(), ((Node)nodePair._1()).copy$default$8(), ((Node)nodePair._1()).copy$default$9(), ((Node)nodePair._1()).copy$default$10()));
        Assertions.assertEquals((Object)expectedNodes, (Object)nodes);
    }

    @Test
    public void testModifyNetwork() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"modifyNetwork", "name=Better-named-network"}));
        Network network = (Network)HubDb$.MODULE$.db().selectTheNetworkIO().unsafeRunSync();
        long x$1 = NetworkId$.MODULE$.oneNetwork();
        String x$2 = "Better-named-network";
        String x$3 = MomQueueName$.MODULE$.apply("hub");
        String x$4 = "yourEmail@your.ctsa.edu";
        String x$5 = "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName";
        None$ x$6 = None$.MODULE$;
        VersionInfo x$7 = Network$.MODULE$.apply$default$2();
        Network qual$1 = new Network(x$1, x$7, "Better-named-network", x$3, "yourEmail@your.ctsa.edu", "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", (Option)x$6);
        VersionInfo x$8 = network.versionInfo();
        long x$9 = qual$1.copy$default$1();
        String x$10 = qual$1.copy$default$3();
        String x$11 = qual$1.copy$default$4();
        String x$12 = qual$1.copy$default$5();
        String x$13 = qual$1.copy$default$6();
        Option x$14 = qual$1.copy$default$7();
        Network expectedNetwork = qual$1.copy(x$9, x$8, x$10, x$11, x$12, x$13, x$14);
        Assertions.assertEquals((Object)expectedNetwork, (Object)network);
        Assertions.assertEquals((int)2, (int)network.versionInfo().itemVersion());
    }

    @Test
    public void testShowNetworkAndNodes() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNetwork"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"listNodes"}));
        String nodeKey = ((Node)this.expectedNodeTemplates().head()).key();
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNode", nodeKey}));
    }

    @Test
    public void testCreateNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNode", "key=h4", "name=Hospital 4", "userDomainName=h4Land", "adminEmail=yourself@h4.edu", "queueName=h4q", "momId=h4IsMe"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"showNode", "h4"}));
        Option node = (Option)HubDb$.MODULE$.db().selectNodeByKeyIO("h4").unsafeRunSync();
        String x$1 = "Hospital 4";
        String x$2 = "h4";
        String x$3 = "h4Land";
        String x$4 = "yourself@h4.edu";
        Option x$5 = Option$.MODULE$.apply((Object)"h4q");
        String x$6 = "h4IsMe";
        boolean x$7 = Node$.MODULE$.create$default$6();
        Node qual$1 = Node$.MODULE$.create("Hospital 4", "h4", "h4Land", "yourself@h4.edu", x$5, x$7, "h4IsMe");
        long x$8 = ((Node)node.get()).id();
        VersionInfo x$9 = ((Node)node.get()).versionInfo();
        String x$10 = qual$1.copy$default$3();
        String x$11 = qual$1.copy$default$4();
        String x$12 = qual$1.copy$default$5();
        String x$13 = qual$1.copy$default$6();
        String x$14 = qual$1.copy$default$7();
        boolean x$15 = qual$1.copy$default$8();
        int x$16 = qual$1.copy$default$9();
        String x$17 = qual$1.copy$default$10();
        Node expectedNode = qual$1.copy(x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        Assertions.assertEquals((Object)expectedNode, (Object)node.get());
    }

    @Test
    public void testModifyNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"modifyNode", "shrine-dev-hub", "name=Best CTSA"}));
        Option node = (Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-hub").unsafeRunSync();
        Node qual$1 = Node$.MODULE$.create("Best CTSA", "shrine-dev-hub", "shrine-dev-hub", "yourEmail@your.ctsa.edu", Option$.MODULE$.apply((Object)"shrinedevhub"), false, "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName");
        long x$1 = ((Node)node.get()).id();
        VersionInfo x$2 = ((Node)node.get()).versionInfo();
        String x$3 = qual$1.copy$default$3();
        String x$4 = qual$1.copy$default$4();
        String x$5 = qual$1.copy$default$5();
        String x$6 = qual$1.copy$default$6();
        String x$7 = qual$1.copy$default$7();
        boolean x$8 = qual$1.copy$default$8();
        int x$9 = qual$1.copy$default$9();
        String x$10 = qual$1.copy$default$10();
        Node expectedNode = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        Assertions.assertEquals((Object)expectedNode, (Object)node.get());
    }

    @Test
    public void testRetireRestoreNode() {
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"createNetwork", "src/test/inputs/network.conf"}));
        Node beforeNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync()).get();
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"retireNode", "shrine-dev-node01"}));
        Node retiredNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync()).get();
        VersionInfo x$1 = retiredNode.versionInfo();
        boolean x$2 = false;
        long x$3 = beforeNode.copy$default$1();
        String x$4 = beforeNode.copy$default$3();
        String x$5 = beforeNode.copy$default$4();
        String x$6 = beforeNode.copy$default$5();
        String x$7 = beforeNode.copy$default$6();
        String x$8 = beforeNode.copy$default$7();
        int x$9 = beforeNode.copy$default$9();
        String x$10 = beforeNode.copy$default$10();
        Node expectedNode = beforeNode.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, false, x$9, x$10);
        Assertions.assertEquals((Object)expectedNode, (Object)retiredNode);
        ShrineNetworkLifecycle$.MODULE$.executeCommand((String[])((Object[])new String[]{"restoreNode", "shrine-dev-node01"}));
        Node restoredNode = (Node)((Option)HubDb$.MODULE$.db().selectNodeByKeyIO("shrine-dev-node01").unsafeRunSync()).get();
        VersionInfo x$11 = restoredNode.versionInfo();
        boolean x$12 = true;
        long x$13 = beforeNode.copy$default$1();
        String x$14 = beforeNode.copy$default$3();
        String x$15 = beforeNode.copy$default$4();
        String x$16 = beforeNode.copy$default$5();
        String x$17 = beforeNode.copy$default$6();
        String x$18 = beforeNode.copy$default$7();
        int x$19 = beforeNode.copy$default$9();
        String x$20 = beforeNode.copy$default$10();
        Node expectedRestoredNode = beforeNode.copy(x$13, x$11, x$14, x$15, x$16, x$17, x$18, true, x$19, x$20);
        Assertions.assertEquals((Object)expectedRestoredNode, (Object)restoredNode);
    }

    @BeforeEach
    public void beforeEach() {
        HubDb$.MODULE$.db().createTables();
    }

    @AfterEach
    public void afterEach() {
        HubDb$.MODULE$.db().dropTables();
    }

    public static final /* synthetic */ void $anonfun$testHelp$1(ShrineNetworkLifecycle.Command command) {
        ShrineNetworkLifecycle.Help$.MODULE$.doIt((String[])((Object[])new String[]{"help", command.name()})).unsafeRunSync();
    }

    public ShrineNetworkLifecycleTest() {
        Node[] nodeArray = new Node[3];
        nodeArray[0] = Node$.MODULE$.create("Test CTSA", "shrine-dev-hub", "shrine-dev-hub", "yourEmail@your.ctsa.edu", Option$.MODULE$.apply((Object)"shrinedevhub"), false, "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName");
        String x$12 = "Famous Hospital 2";
        String x$2 = "shrine-dev-node02";
        String x$3 = "shrine-dev-node02";
        String x$4 = "admin@hospital.famousUniversity2.edu";
        Option x$5 = Option$.MODULE$.apply((Object)"shrinedevnode02");
        String x$6 = "arn:aws:iam::Node2AWSAccountNumber:user/node02UserName";
        boolean x$7 = Node$.MODULE$.create$default$6();
        nodeArray[1] = Node$.MODULE$.create("Famous Hospital 2", "shrine-dev-node02", "shrine-dev-node02", "admin@hospital.famousUniversity2.edu", x$5, x$7, "arn:aws:iam::Node2AWSAccountNumber:user/node02UserName");
        String x$8 = "Famous Hospital 1";
        String x$9 = "shrine-dev-node01";
        String x$10 = "shrine-dev-node01";
        String x$11 = "admin@hospital.famousUniversity1.edu";
        Option x$122 = Option$.MODULE$.apply((Object)"shrinedevnode01");
        String x$13 = "arn:aws:iam::Node1AWSAccountNumber:user/node01UserName";
        boolean x$14 = Node$.MODULE$.create$default$6();
        nodeArray[2] = Node$.MODULE$.create("Famous Hospital 1", "shrine-dev-node01", "shrine-dev-node01", "admin@hospital.famousUniversity1.edu", x$122, x$14, "arn:aws:iam::Node1AWSAccountNumber:user/node01UserName");
        this.expectedNodeTemplates = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])nodeArray)).sortBy((Function1 & Serializable)x$1 -> x$1.key(), (Ordering)Ordering.String$.MODULE$);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        long x$15 = NetworkId$.MODULE$.oneNetwork();
        String x$16 = "SHRINE Dev test network";
        String x$17 = MomQueueName$.MODULE$.apply("hub");
        String x$18 = "yourEmail@your.ctsa.edu";
        String x$19 = "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName";
        None$ x$20 = None$.MODULE$;
        VersionInfo x$21 = Network$.MODULE$.apply$default$2();
        this.templateNetwork = new Network(x$15, x$21, "SHRINE Dev test network", x$17, "yourEmail@your.ctsa.edu", "arn:aws:iam::CtsaAWSAccountNumber:user/hubUserName", (Option)x$20);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

