/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageSystemAttributeName {
    SENDER_ID("SenderId"),
    SENT_TIMESTAMP("SentTimestamp"),
    APPROXIMATE_RECEIVE_COUNT("ApproximateReceiveCount"),
    APPROXIMATE_FIRST_RECEIVE_TIMESTAMP("ApproximateFirstReceiveTimestamp"),
    SEQUENCE_NUMBER("SequenceNumber"),
    MESSAGE_DEDUPLICATION_ID("MessageDeduplicationId"),
    MESSAGE_GROUP_ID("MessageGroupId"),
    AWS_TRACE_HEADER("AWSTraceHeader"),
    DEAD_LETTER_QUEUE_SOURCE_ARN("DeadLetterQueueSourceArn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageSystemAttributeName> VALUE_MAP;
    private final String value;

    private MessageSystemAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageSystemAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageSystemAttributeName> knownValues() {
        EnumSet<MessageSystemAttributeName> knownValues = EnumSet.allOf(MessageSystemAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageSystemAttributeName.class, MessageSystemAttributeName::toString);
    }
}

