/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.SortKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOrganizationsAccessReportRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetOrganizationsAccessReportRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetOrganizationsAccessReportRequest.getter(GetOrganizationsAccessReportRequest::jobId)).setter(GetOrganizationsAccessReportRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(GetOrganizationsAccessReportRequest.getter(GetOrganizationsAccessReportRequest::maxItems)).setter(GetOrganizationsAccessReportRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetOrganizationsAccessReportRequest.getter(GetOrganizationsAccessReportRequest::marker)).setter(GetOrganizationsAccessReportRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> SORT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortKey").getter(GetOrganizationsAccessReportRequest.getter(GetOrganizationsAccessReportRequest::sortKeyAsString)).setter(GetOrganizationsAccessReportRequest.setter(Builder::sortKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD, SORT_KEY_FIELD));
    private final String jobId;
    private final Integer maxItems;
    private final String marker;
    private final String sortKey;

    private GetOrganizationsAccessReportRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.sortKey = builder.sortKey;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String marker() {
        return this.marker;
    }

    public final SortKeyType sortKey() {
        return SortKeyType.fromValue(this.sortKey);
    }

    public final String sortKeyAsString() {
        return this.sortKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortKeyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationsAccessReportRequest)) {
            return false;
        }
        GetOrganizationsAccessReportRequest other = (GetOrganizationsAccessReportRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.sortKeyAsString(), other.sortKeyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetOrganizationsAccessReportRequest").add("JobId", (Object)this.jobId()).add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).add("SortKey", (Object)this.sortKeyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SortKey": {
                return Optional.ofNullable(clazz.cast(this.sortKeyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationsAccessReportRequest, T> g) {
        return obj -> g.apply((GetOrganizationsAccessReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private Integer maxItems;
        private String marker;
        private String sortKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationsAccessReportRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.sortKey(model.sortKey);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getSortKey() {
            return this.sortKey;
        }

        public final void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        @Override
        public final Builder sortKey(String sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        @Override
        public final Builder sortKey(SortKeyType sortKey) {
            this.sortKey(sortKey == null ? null : sortKey.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOrganizationsAccessReportRequest build() {
            return new GetOrganizationsAccessReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOrganizationsAccessReportRequest> {
        public Builder jobId(String var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder sortKey(String var1);

        public Builder sortKey(SortKeyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

