/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeMessageVisibilityRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueUrl").getter(ChangeMessageVisibilityRequest.getter(ChangeMessageVisibilityRequest::queueUrl)).setter(ChangeMessageVisibilityRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<String> RECEIPT_HANDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiptHandle").getter(ChangeMessageVisibilityRequest.getter(ChangeMessageVisibilityRequest::receiptHandle)).setter(ChangeMessageVisibilityRequest.setter(Builder::receiptHandle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptHandle").build()}).build();
    private static final SdkField<Integer> VISIBILITY_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VisibilityTimeout").getter(ChangeMessageVisibilityRequest.getter(ChangeMessageVisibilityRequest::visibilityTimeout)).setter(ChangeMessageVisibilityRequest.setter(Builder::visibilityTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, RECEIPT_HANDLE_FIELD, VISIBILITY_TIMEOUT_FIELD));
    private final String queueUrl;
    private final String receiptHandle;
    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    public final String queueUrl() {
        return this.queueUrl;
    }

    public final String receiptHandle() {
        return this.receiptHandle;
    }

    public final Integer visibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityRequest)) {
            return false;
        }
        ChangeMessageVisibilityRequest other = (ChangeMessageVisibilityRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.receiptHandle(), other.receiptHandle()) && Objects.equals(this.visibilityTimeout(), other.visibilityTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeMessageVisibilityRequest").add("QueueUrl", (Object)this.queueUrl()).add("ReceiptHandle", (Object)this.receiptHandle()).add("VisibilityTimeout", (Object)this.visibilityTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "ReceiptHandle": {
                return Optional.ofNullable(clazz.cast(this.receiptHandle()));
            }
            case "VisibilityTimeout": {
                return Optional.ofNullable(clazz.cast(this.visibilityTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeMessageVisibilityRequest, T> g) {
        return obj -> g.apply((ChangeMessageVisibilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private String receiptHandle;
        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.receiptHandle(model.receiptHandle);
            this.visibilityTimeout(model.visibilityTimeout);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeMessageVisibilityRequest build() {
            return new ChangeMessageVisibilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
        public Builder queueUrl(String var1);

        public Builder receiptHandle(String var1);

        public Builder visibilityTimeout(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

