/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub.mom;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.std.Dispatcher;
import com.typesafe.config.Config;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import net.shrine.config.ConfigSource$;
import net.shrine.http4s.catsio.LazyIO$;
import net.shrine.http4s.catsio.RetryIO$;
import net.shrine.hub.data.client.HubClient$;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.hub.mom.ExceptionDuringDispatch;
import net.shrine.hub.mom.OkToRetry$;
import net.shrine.log.Log$;
import net.shrine.messagequeueclient.AwsSqsMessageQueueClient;
import net.shrine.messagequeueclient.KafkaMessageQueueClient;
import net.shrine.messagequeueservice.DeliveryAttemptId;
import net.shrine.messagequeueservice.Message;
import net.shrine.messagequeueservice.MessageQueueService;
import net.shrine.protocol.version.Envelope;
import net.shrine.protocol.version.Envelope$;
import net.shrine.protocol.version.EnvelopeContents;
import net.shrine.protocol.version.EnvelopeContentsCompanion;
import net.shrine.protocol.version.Id;
import net.shrine.protocol.version.MomQueueName;
import net.shrine.protocol.version.ProtocolVersion;
import net.shrine.protocol.version.v2.AwsSqsConfig;
import net.shrine.protocol.version.v2.KafkaConfig;
import net.shrine.protocol.version.v2.Network;
import net.shrine.protocol.version.v2.Node;
import net.shrine.protocol.version.v2.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ShrineMomClient$ {
    public static final ShrineMomClient$ MODULE$ = new ShrineMomClient$();
    private static IO<Network> networkIO;
    private static IO<MessageQueueService> serviceIO;
    private static final Config hubMomConfig;
    private static final FiniteDuration retryDelay;
    private static final Option<Object> momSendAttempts;
    private static final Function1<Throwable, Object> retryIfTaskThrows;
    private static volatile byte bitmap$init$0;
    private static volatile byte bitmap$0;

    static {
        hubMomConfig = ConfigSource$.MODULE$.config().getConfig("shrine.hub.mom");
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        retryDelay = net.shrine.config.package$.MODULE$.ConfigExtensions(MODULE$.hubMomConfig()).getFiniteDuration("retryDelay");
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        int attempts = MODULE$.hubMomConfig().getInt("momSendAttempts");
        momSendAttempts = attempts > 0 ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)attempts)) : None$.MODULE$;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        retryIfTaskThrows = (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ShrineMomClient$.$anonfun$retryIfTaskThrows$1(x0$1));
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    private IO<Network> networkIO$lzycompute() {
        ShrineMomClient$ shrineMomClient$ = this;
        synchronized (shrineMomClient$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Log$.MODULE$.info((Function0 & Serializable)() -> "Getting the network");
                networkIO = LazyIO$.MODULE$.apply("networkIO", ConfigSource$.MODULE$.config().getBoolean("shrine.hub.create") ? HubDb$.MODULE$.db().selectTheNetworkIO() : HubClient$.MODULE$.getNetworkIO());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return networkIO;
    }

    private IO<Network> networkIO() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.networkIO$lzycompute();
        }
        return networkIO;
    }

    private IO<MessageQueueService> serviceIO$lzycompute() {
        ShrineMomClient$ shrineMomClient$ = this;
        synchronized (shrineMomClient$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                serviceIO = LazyIO$.MODULE$.apply("serviceIO", this.networkIO().flatMap((Function1 & Serializable)network -> MODULE$.serviceIOFromNetwork((Network)network)));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return serviceIO;
    }

    public IO<MessageQueueService> serviceIO() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.serviceIO$lzycompute();
        }
        return serviceIO;
    }

    public IO<MessageQueueService> serviceIOFromNetwork(Network network) {
        Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(11).append("Network is ").append(network).toString());
        Tuple2 tuple2 = new Tuple2((Object)network.awsSqsConfig(), (Object)network.kafkaConfig());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                String momClassNameKey = "shrine.hub.messagequeue.implementation";
                String momClassName = ConfigSource$.MODULE$.config().getString(momClassNameKey);
                Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(34).append("Using ").append(momClassName).append(" system from ConfigSource \"").append(momClassNameKey).append("\"").toString());
                JavaUniverse.JavaMirror classLoaderMirror = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                Symbols.ModuleSymbolApi module = ((Mirror)classLoaderMirror).staticModule(momClassName);
                return IO$.MODULE$.apply((Function0 & Serializable)() -> (MessageQueueService)classLoaderMirror.reflectModule(module).instance());
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                AwsSqsConfig awsSqsConfig = (AwsSqsConfig)some.value();
                if (None$.MODULE$.equals(option3)) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> new AwsSqsMessageQueueClient(awsSqsConfig));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                KafkaConfig kafkaConfig = (KafkaConfig)some.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> new KafkaMessageQueueClient(kafkaConfig));
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (option instanceof Some && option5 instanceof Some) {
                return IO$.MODULE$.raiseError((Throwable)new IllegalStateException("This network is configured to use both AWS and Kafka"));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Config hubMomConfig() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineMomClient.scala: 62");
        }
        return hubMomConfig;
    }

    private FiniteDuration retryDelay() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineMomClient.scala: 63");
        }
        return retryDelay;
    }

    private Option<Object> momSendAttempts() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineMomClient.scala: 64");
        }
        return momSendAttempts;
    }

    private Function1<Throwable, Object> retryIfTaskThrows() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ShrineMomClient.scala: 70");
        }
        return retryIfTaskThrows;
    }

    public IO<BoxedUnit> sendToNodeIO(Id subjectId, EnvelopeContents envelopeContents, EnvelopeContentsCompanion envelopeContentsCompanion, String logString, long nodeId) {
        return HubDb$.MODULE$.db().selectNodeIO(nodeId).flatMap((Function1 & Serializable)node -> MODULE$.sendIO(subjectId, envelopeContents, envelopeContentsCompanion, logString, ((Node)node.get()).momQueueName()));
    }

    public IO<BoxedUnit> sendToNodeIO(Id subjectId, EnvelopeContents envelopeContents, EnvelopeContentsCompanion envelopeContentsCompanion, String logString, String queueName) {
        return this.sendIO(subjectId, envelopeContents, envelopeContentsCompanion, logString, queueName);
    }

    public IO<BoxedUnit> sendToHubIO(Id subjectId, EnvelopeContents envelopeContents, EnvelopeContentsCompanion envelopeContentsCompanion, String logString) {
        return this.networkIO().flatMap((Function1 & Serializable)network -> MODULE$.sendIO(subjectId, envelopeContents, envelopeContentsCompanion, logString, network.hubQueueName()));
    }

    private IO<BoxedUnit> sendIO(Id subjectId, EnvelopeContents envelopeContents, EnvelopeContentsCompanion envelopeContentsCompanion, String logString, String queueName) {
        Envelope envelope = new Envelope(envelopeContentsCompanion.envelopeType(), BoxesRunTime.unboxToLong((Object)subjectId.underlying()), envelopeContents.asJsonText(), Envelope$.MODULE$.apply$default$4(), Envelope$.MODULE$.apply$default$5());
        IO sIO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(14).append("Will send ").append(logString).append(" to ").append(new MomQueueName(queueName)).toString())).flatMap((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit = x$3;
            return MODULE$.serviceIO().flatMap((Function1 & Serializable)service -> service.getQueueIO(queueName).flatMap((Function1 & Serializable)queue -> queue.sendIO(envelope.asJsonText(), envelope.contentsSubject()).flatMap((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(9).append("Sent ").append(logString).append(" to ").append(new MomQueueName(queueName)).toString())).map((Function1 & Serializable)x$1 -> {
                    boxedUnit = x$1;
                    return BoxedUnit.UNIT;
                });
            })));
        });
        return (IO)this.momSendAttempts().fold((Function0 & Serializable)() -> RetryIO$.MODULE$.keepTrying(sIO, MODULE$.retryDelay(), MODULE$.retryIfTaskThrows(), new StringBuilder(23).append("send ").append(subjectId).append(" to ").append(new MomQueueName(queueName)).append(" until success").toString(), (GenTemporal)IO$.MODULE$.asyncForIO()), (Function1 & Serializable)attempts -> RetryIO$.MODULE$.keepTryingBounded(sIO, ShrineMomClient$.MODULE$.retryDelay(), BoxesRunTime.unboxToInt((Object)attempts), ShrineMomClient$.MODULE$.retryIfTaskThrows(), new StringBuilder(24).append("send ").append(subjectId).append(" to ").append(new MomQueueName(queueName)).append(" attempt ").append(BoxesRunTime.unboxToInt((Object)attempts)).append(" times").toString(), (GenTemporal)IO$.MODULE$.asyncForIO()));
    }

    private IO<BoxedUnit> receiveUntilStopIO(IO<MomQueueName> queueNameIO, Function1<Envelope, IO<Object>> dispatch) {
        Stream queueNameStream = Stream$.MODULE$.eval((Object)IO$.MODULE$.cede().flatMap((Function1 & Serializable)x$4 -> queueNameIO));
        Stream queueStream = queueNameStream.flatMap((Function1 & Serializable)queueName -> ShrineMomClient$.$anonfun$receiveUntilStopIO$2(((MomQueueName)queueName).underlying()), NotGiven$.MODULE$.default());
        Stream dispatchedStream = queueStream.flatMap((Function1 & Serializable)queue -> queue.receiveStream(), NotGiven$.MODULE$.default()).flatMap((Function1 & Serializable)message -> MODULE$.openEnvelopeAndDispatch((Message)message, dispatch), NotGiven$.MODULE$.default());
        IO streamToRun = RetryIO$.MODULE$.keepTrying((IO)dispatchedStream.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain(), this.retryDelay(), this.retryIfTaskThrows(), "receiveUntilStop", (GenTemporal)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)x$6 -> {
            Log$.MODULE$.debug((Function0 & Serializable)() -> "End of receive message stream");
            return BoxedUnit.UNIT;
        }).handleErrorWith((Function1 & Serializable)t -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.error((Function0 & Serializable)() -> "Exception while running dispatch", t)));
        return streamToRun;
    }

    public Function0<Future<BoxedUnit>> receiveUntilStop(IO<MomQueueName> queueNameIO, Function1<Envelope, IO<Object>> dispatch, Dispatcher<IO> dispatcher) {
        return dispatcher.unsafeRunCancelable(this.receiveUntilStopIO(queueNameIO, dispatch));
    }

    /*
     * Unable to fully structure code
     */
    private Stream<IO, BoxedUnit> openEnvelopeAndDispatch(Message message, Function1<Envelope, IO<Object>> dispatch) {
        Log$.MODULE$.debug((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$1(net.shrine.messagequeueservice.Message scala.Function1 ), ()Ljava/lang/String;)((Message)message, dispatch));
        envelopeTry = Envelope$.MODULE$.tryRead(message.contents());
        envelope = (Envelope)envelopeTry.get();
        Log$.MODULE$.info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$2(net.shrine.protocol.version.Envelope ), ()Ljava/lang/String;)((Envelope)envelope));
        var7_5 = false;
        var8_6 = BoxesRunTime.unboxToInt(null);
        var9_7 = envelope.protocolVersion();
        if (!(new ProtocolVersion(var9_7) instanceof ProtocolVersion)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = var9_7;
        if (var8_6 == package$.MODULE$.versionId()) {
            v0 = (IO)dispatch.apply((Object)envelope);
        } else if (var7_5 && var8_6 == net.shrine.protocol.version.v1.package$.MODULE$.versionId()) {
            Log$.MODULE$.warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$3(int ), ()Ljava/lang/String;)((int)var8_6));
            v0 = (IO)dispatch.apply((Object)envelope);
        } else if (var7_5) {
            Log$.MODULE$.warn((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$4(int ), ()Ljava/lang/String;)((int)var8_6));
            v0 = (IO)dispatch.apply((Object)envelope);
        } else {
            throw new MatchError((Object)new ProtocolVersion(var9_7));
        }
        dispatchIO = v0;
        timeLimit = FiniteDuration$.MODULE$.apply(message.millisecondsToComplete(), TimeUnit.MILLISECONDS);
        shouldCompleteIO = dispatchIO.timeoutTo((Duration)timeLimit, IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$openEnvelopeAndDispatch$5(net.shrine.messagequeueservice.Message scala.concurrent.duration.FiniteDuration ), ()V)((Message)message, (FiniteDuration)timeLimit)).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$7(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lcats/effect/IO;)()));
        completeIO = shouldCompleteIO.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$9$adapted(net.shrine.messagequeueservice.Message java.lang.Object ), (Ljava/lang/Object;)Lcats/effect/IO;)((Message)message)).handleErrorWith((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$14(net.shrine.protocol.version.Envelope java.lang.Throwable ), (Ljava/lang/Throwable;)Lcats/effect/IO;)((Envelope)envelope)).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$16(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lcats/effect/IO;)());
        concurrentDispatchIO = completeIO.start().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$openEnvelopeAndDispatch$17(cats.effect.kernel.Fiber ), (Lcats/effect/kernel/Fiber;)Lcats/effect/IO;)());
        return Stream$.MODULE$.eval((Object)concurrentDispatchIO);
    }

    public static final /* synthetic */ boolean $anonfun$retryIfTaskThrows$1(Throwable x0$1) {
        Option<Throwable> option;
        Throwable throwable = x0$1;
        if (throwable != null && !(option = OkToRetry$.MODULE$.unapply(throwable)).isEmpty()) {
            return true;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ Stream $anonfun$receiveUntilStopIO$2(String queueName) {
        Log$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(23).append("Dispatcher for ").append(new MomQueueName(queueName)).append(" started").toString());
        return Stream$.MODULE$.eval((Object)MODULE$.serviceIO().flatMap((Function1 & Serializable)x$5 -> x$5.getQueueIO(queueName)));
    }

    public static final /* synthetic */ String $anonfun$openEnvelopeAndDispatch$1(Message message$1, Function1 dispatch$2) {
        return new StringBuilder(41).append("Message delivery id ").append(new DeliveryAttemptId(message$1.deliveryAttemptId())).append(" to be dispatched to ").append(dispatch$2).toString();
    }

    public static final /* synthetic */ String $anonfun$openEnvelopeAndDispatch$2(Envelope envelope$2) {
        return new StringBuilder(18).append("Envelope holds a ").append(new ProtocolVersion(envelope$2.protocolVersion())).append(" ").append(envelope$2.contentsType()).toString();
    }

    public static final /* synthetic */ String $anonfun$openEnvelopeAndDispatch$3(int x2$1) {
        return new StringBuilder(69).append("Envelope contents version ").append(new ProtocolVersion(x2$1)).append(" is not tested with this version of shrine.").toString();
    }

    public static final /* synthetic */ String $anonfun$openEnvelopeAndDispatch$4(int x2$1) {
        return new StringBuilder(97).append("Envelope contents version ").append(new ProtocolVersion(x2$1)).append(" is not tested with this version of shrine. Attempting to read it with ").append(new ProtocolVersion(package$.MODULE$.versionId())).toString();
    }

    public static final /* synthetic */ void $anonfun$openEnvelopeAndDispatch$5(Message message$1, FiniteDuration timeLimit$1) {
        Log$.MODULE$.warn((Function0 & Serializable)() -> new StringBuilder(56).append("openEnvelopeAndDispatch of message ").append(new DeliveryAttemptId(message$1.deliveryAttemptId())).append(" did not complete in ").append(timeLimit$1).toString());
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$7(BoxedUnit x$7) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> false);
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$9(Message message$1, boolean shouldComplete) {
        if (shouldComplete) {
            return message$1.completeIO().map((Function1 & Serializable)x$8 -> {
                Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(18).append("message ").append(new DeliveryAttemptId(message$1.deliveryAttemptId())).append(" completed").toString());
                return BoxedUnit.UNIT;
            });
        }
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Log$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(22).append("Message ").append(new DeliveryAttemptId(message$1.deliveryAttemptId())).append(" not completed").toString()));
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$14(Envelope envelope$2, Throwable x0$1) {
        Option option;
        Throwable throwable = x0$1;
        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
            Throwable t = (Throwable)option.get();
            return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> new ExceptionDuringDispatch(t, envelope$2));
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$16(BoxedUnit x$9) {
        return IO$.MODULE$.cede();
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$17(Fiber x$10) {
        return IO$.MODULE$.unit();
    }

    private ShrineMomClient$() {
    }

    public static final /* synthetic */ IO $anonfun$openEnvelopeAndDispatch$9$adapted(Message message$1, Object shouldComplete) {
        return ShrineMomClient$.$anonfun$openEnvelopeAndDispatch$9(message$1, BoxesRunTime.unboxToBoolean((Object)shouldComplete));
    }
}

