/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ConsumerGroupHeartbeatResponse
extends AbstractResponse {
    private final ConsumerGroupHeartbeatResponseData data;

    public ConsumerGroupHeartbeatResponse(ConsumerGroupHeartbeatResponseData data) {
        super(ApiKeys.CONSUMER_GROUP_HEARTBEAT);
        this.data = data;
    }

    @Override
    public ConsumerGroupHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ConsumerGroupHeartbeatResponse parse(ByteBuffer buffer, short version) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData(new ByteBufferAccessor(buffer), version));
    }
}

