/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.shrine.proxy.ShrineMessageFormatException;
import net.shrine.serializers.HTTPClient;
import org.apache.log4j.Logger;
import org.spin.extension.JDOMTool;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;

public class ShrineProxy {
    private static final Logger log = Logger.getLogger(ShrineProxy.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private List<String> whiteList = new ArrayList();
    private List<String> blackList = new ArrayList();

    public ShrineProxy() throws ConfigException {
        log.info((Object)"ProxyAdapter init: ");
        this.getLists();
    }

    private void getLists() throws ConfigException {
        try {
            File proxyconf = ConfigTool.getConfigFileWithFailover((String)"shrine-proxy-acl.xml");
            JDOMTool jdom = new JDOMTool((Reader)new BufferedReader(new FileReader(proxyconf)));
            this.whiteList = jdom.getElementValues("//lists/whitelist/host");
            this.blackList = jdom.getElementValues("//lists/blacklist/host");
        }
        catch (Exception e) {
            log.error((Object)("ShrineProxy encountered a problem while checking ACL permissions: " + e));
            throw new ConfigException(e.getStackTrace().toString());
        }
        log.info((Object)"Loaded access control list.");
        for (String white : this.whiteList) {
            log.info((Object)("Whitelist entry:" + white));
        }
        for (String black : this.blackList) {
            log.info((Object)("Blacklist entry:" + black));
        }
    }

    private boolean isAllowableDomain(String redirectURL) {
        boolean returnValue = false;
        for (String s : this.whiteList) {
            if (!redirectURL.startsWith(s)) continue;
            returnValue = true;
            break;
        }
        for (String s : this.blackList) {
            if (!redirectURL.startsWith(s)) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public String redirect(JDOMTool request) throws ShrineMessageFormatException, ConfigException, IOException {
        String redirectURL;
        try {
            redirectURL = request.getElementValue("//redirect_url");
        }
        catch (Exception e) {
            log.error((Object)("Error parsing redirect_url tag: " + e.getStackTrace()));
            throw new ShrineMessageFormatException((Throwable)e);
        }
        if (redirectURL == null || redirectURL.length() == 0) {
            log.error((Object)"ShrineAdapter detected missing redirect_url tag");
            throw new ShrineMessageFormatException("ShrineAdapter detected missing redirect_url tag");
        }
        if (!this.isAllowableDomain(redirectURL)) {
            throw new ShrineMessageFormatException("redirectURL not in white list or is in black list: " + redirectURL);
        }
        if (DEBUG) {
            log.debug((Object)("Proxy redirecting to " + redirectURL));
        }
        return HTTPClient.post((String)request.toString(), (String)redirectURL);
    }
}

