/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.qep;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import net.shrine.authentication.Authenticator;
import net.shrine.authorization.QueryAuthorizationService;
import net.shrine.config.package;
import net.shrine.config.package$;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.BouncyKeyStoreCollection$;
import net.shrine.http4s.client.legacy.EndpointConfig;
import net.shrine.http4s.client.legacy.EndpointConfig$;
import net.shrine.http4s.client.legacy.Poster;
import net.shrine.http4s.client.legacy.Poster$;
import net.shrine.log.Log$;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.ResultOutputType$;
import net.shrine.protocol.XmlNodeName;
import net.shrine.qep.AuthStrategy$;
import net.shrine.qep.I2b2QepService;
import net.shrine.source.ConfigSource$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple8;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class I2b2QepService$
implements scala.Serializable {
    public static I2b2QepService$ MODULE$;

    static {
        new I2b2QepService$();
    }

    public I2b2QepService apply(Config qepConfig, String commonName, Authenticator authenticator, QueryAuthorizationService authorizationService, Set<ResultOutputType> breakdownTypes, XmlNodeName nodeId, BouncyKeyStoreCollection certCollection) {
        return new I2b2QepService(commonName, authenticator, authorizationService, breakdownTypes, qepConfig.getBoolean("audit.collectQepAudit"), nodeId, certCollection, qepConfig.getInt("sendToHubAttempts"));
    }

    public Option<I2b2QepService> maybeCreate() {
        Config config = ConfigSource$.MODULE$.config();
        Config shrineConfig = config.getConfig("shrine");
        Set breakdownTypes = ResultOutputType$.MODULE$.breakdownTypes();
        BouncyKeyStoreCollection certCollection = BouncyKeyStoreCollection$.MODULE$.fromConfig();
        EndpointConfig pmEndpoint = (EndpointConfig)package$.MODULE$.ConfigExtensions(shrineConfig).getConfigured("pmEndpoint", (Function1 & Serializable & scala.Serializable)x$9 -> EndpointConfig$.MODULE$.apply(x$9));
        Poster pmPoster = Poster$.MODULE$.apply(certCollection, pmEndpoint);
        XmlNodeName xmlNodeName = new XmlNodeName(shrineConfig.getString("nodeKey"));
        package.ConfigExtensions qual$1 = package$.MODULE$.ConfigExtensions(shrineConfig);
        String x$1 = "queryEntryPoint";
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)qepConfig -> {
            String commonName = (String)certCollection.myEntry().commonName().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                void var1_1;
                String hostname = InetAddress.getLocalHost().getHostName();
                Log$.MODULE$.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("No common name available from ").append(certCollection.myEntry()).append(". Using ").append(hostname).append(" instead.").toString());
                return var1_1;
            });
            Authenticator authenticator = AuthStrategy$.MODULE$.determineAuthenticator((Config)qepConfig, pmPoster);
            QueryAuthorizationService authorizationService = AuthStrategy$.MODULE$.determineQueryAuthorizationService((Config)qepConfig);
            Log$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("authorizationService set to ").append(authorizationService).toString());
            return new I2b2QepService(commonName, authenticator, authorizationService, (Set<ResultOutputType>)breakdownTypes, qepConfig.getBoolean("audit.collectQepAudit"), xmlNodeName, certCollection, qepConfig.getInt("sendToHubAttempts"));
        };
        String x$3 = qual$1.getOptionConfiguredIf$default$3();
        return qual$1.getOptionConfiguredIf(x$1, (Function1)x$2, x$3);
    }

    public I2b2QepService apply(String commonName, Authenticator authenticator, QueryAuthorizationService authorizationService, Set<ResultOutputType> breakdownTypes, boolean collectQepAudit, XmlNodeName xmlNodeName, BouncyKeyStoreCollection certCollection, int sendToHubAttempts) {
        return new I2b2QepService(commonName, authenticator, authorizationService, breakdownTypes, collectQepAudit, xmlNodeName, certCollection, sendToHubAttempts);
    }

    public Option<Tuple8<String, Authenticator, QueryAuthorizationService, Set<ResultOutputType>, Object, XmlNodeName, BouncyKeyStoreCollection, Object>> unapply(I2b2QepService x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.commonName(), (Object)x$0.authenticator(), (Object)x$0.authorizationService(), x$0.breakdownTypes(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.collectQepAudit()), (Object)x$0.xmlNodeName(), (Object)x$0.certCollection(), (Object)BoxesRunTime.boxToInteger((int)x$0.sendToHubAttempts())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private I2b2QepService$() {
        MODULE$ = this;
    }
}

