/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Blocker$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Hotswap;
import fs2.Hotswap$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.CollectionCompat$JIteratorOps$;
import fs2.io.CollectionCompat$JSetOps$;
import fs2.io.CollectionCompat$SetOps$;
import fs2.io.Watcher;
import fs2.io.Watcher$;
import fs2.io.file.FileHandle;
import fs2.io.file.FileHandle$;
import fs2.io.file.ReadCursor$;
import fs2.io.file.WriteCursor;
import fs2.io.file.WriteCursor$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public <F> FreeC<F, Object, BoxedUnit> readAll(Path path, ExecutionContext blocker, int chunkSize, Sync<F> evidence$1, ContextShift<F> evidence$2) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(ReadCursor$.MODULE$.fromPath(path, blocker, ReadCursor$.MODULE$.fromPath$default$3(), evidence$1, evidence$2)), (Function1 & Serializable)cursor -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.void$extension(cursor.readAll(chunkSize)), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public <F> FreeC<F, Object, BoxedUnit> readRange(Path path, ExecutionContext blocker, int chunkSize, long start, long end, Sync<F> evidence$3, ContextShift<F> evidence$4) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(ReadCursor$.MODULE$.fromPath(path, blocker, ReadCursor$.MODULE$.fromPath$default$3(), evidence$3, evidence$4)), (Function1 & Serializable)cursor -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.void$extension(cursor.seek(start).readUntil(chunkSize, end)), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public <F> FreeC<F, Object, BoxedUnit> tail(Path path, ExecutionContext blocker, int chunkSize, long offset, FiniteDuration pollDelay, Sync<F> evidence$5, ContextShift<F> evidence$6, Timer<F> evidence$7) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(ReadCursor$.MODULE$.fromPath(path, blocker, ReadCursor$.MODULE$.fromPath$default$3(), evidence$5, evidence$6)), (Function1 & Serializable)cursor -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.void$extension(cursor.seek(offset).tail(chunkSize, pollDelay, evidence$7)), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public <F> long tail$default$4() {
        return 0L;
    }

    public <F> FiniteDuration tail$default$5() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public <F> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> writeAll(Path path, ExecutionContext blocker, Seq<StandardOpenOption> flags, Sync<F> evidence$8, ContextShift<F> evidence$9) {
        return (Function1 & Serializable)in -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(WriteCursor$.MODULE$.fromPath(path, blocker, (Seq<OpenOption>)flags, evidence$8, evidence$9)), (Function1 & Serializable)x$1 -> new Stream(Pull$.MODULE$.stream$extension(Pull$.MODULE$.void$extension(x$1.writeAll(in)), (.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    public <F> Seq<StandardOpenOption> writeAll$default$3() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> writeRotate(F computePath, long limit, ExecutionContext blocker, Seq<StandardOpenOption> flags, Concurrent<F> evidence$10, ContextShift<F> evidence$11) {
        return (Function1 & Serializable)in -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(Hotswap$.MODULE$.apply(package$.openNewFile$1(computePath, evidence$10, blocker, flags, evidence$11), evidence$10)), (Function1 & Serializable)x0$1 -> new Stream(package$.$anonfun$writeRotate$7(in, flags$2, evidence$10$1, evidence$11$1, limit$1, computePath$1, blocker$2, x0$1))));
    }

    public <F> Seq<StandardOpenOption> writeRotate$default$4() {
        return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public <F> Resource<F, Watcher<F>> watcher(ExecutionContext blocker, Concurrent<F> evidence$12, ContextShift<F> evidence$13) {
        return Watcher$.MODULE$.default(blocker, evidence$12, evidence$13);
    }

    public <F> FreeC<F, Watcher.Event, BoxedUnit> watch(ExecutionContext blocker, Path path, Seq<Watcher.EventType> types, Seq<WatchEvent.Modifier> modifiers, FiniteDuration pollTimeout, Concurrent<F> evidence$14, ContextShift<F> evidence$15) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(Watcher$.MODULE$.default(blocker, evidence$14, evidence$15)), (Function1 & Serializable)w -> new Stream(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.eval_(w.watch(path, (Seq<Watcher.EventType>)types, (Seq<WatchEvent.Modifier>)modifiers)), (Function0 & Serializable)() -> new Stream(w.events(pollTimeout$1)))));
    }

    public <F> Seq<Watcher.EventType> watch$default$3() {
        return scala.package$.MODULE$.Nil();
    }

    public <F> Seq<WatchEvent.Modifier> watch$default$4() {
        return scala.package$.MODULE$.Nil();
    }

    public <F> FiniteDuration watch$default$5() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public <F> F exists(ExecutionContext blocker, Path path, Seq<LinkOption> flags, Sync<F> evidence$16, ContextShift<F> evidence$17) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.exists(path, (LinkOption[])flags.toArray(ClassTag$.MODULE$.apply(LinkOption.class))), evidence$16, evidence$17);
    }

    public <F> Seq<LinkOption> exists$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> F permissions(ExecutionContext blocker, Path path, Seq<LinkOption> flags, Sync<F> evidence$18, ContextShift<F> evidence$19) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> CollectionCompat$JSetOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JSetOps(Files.getPosixFilePermissions(path, (LinkOption[])flags.toArray(ClassTag$.MODULE$.apply(LinkOption.class))))), evidence$18, evidence$19);
    }

    public <F> Seq<LinkOption> permissions$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> F setPermissions(ExecutionContext blocker, Path path, Set<PosixFilePermission> permissions, Sync<F> evidence$20, ContextShift<F> evidence$21) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.setPosixFilePermissions(path, CollectionCompat$SetOps$.MODULE$.asJava$extension(CollectionCompat$.MODULE$.SetOps(permissions))), evidence$20, evidence$21);
    }

    public <F> F copy(ExecutionContext blocker, Path source, Path target, Seq<CopyOption> flags, Sync<F> evidence$22, ContextShift<F> evidence$23) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.copy(source, target, (CopyOption[])flags.toArray(ClassTag$.MODULE$.apply(CopyOption.class))), evidence$22, evidence$23);
    }

    public <F> Seq<CopyOption> copy$default$4() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> F delete(ExecutionContext blocker, Path path, Sync<F> evidence$24, ContextShift<F> evidence$25) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcV.sp & Serializable)() -> Files.delete(path), evidence$24, evidence$25);
    }

    public <F> F deleteIfExists(ExecutionContext blocker, Path path, Sync<F> evidence$26, ContextShift<F> evidence$27) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.deleteIfExists(path), evidence$26, evidence$27);
    }

    public <F> F deleteDirectoryRecursively(ExecutionContext blocker, Path path, Set<FileVisitOption> options, Sync<F> evidence$28, ContextShift<F> evidence$29) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcV.sp & Serializable)() -> Files.walkFileTree(path, CollectionCompat$SetOps$.MODULE$.asJava$extension(CollectionCompat$.MODULE$.SetOps(options)), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path path, IOException e) {
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
        }), evidence$28, evidence$29);
    }

    public <F> Set<FileVisitOption> deleteDirectoryRecursively$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public <F> F size(ExecutionContext blocker, Path path, Sync<F> evidence$30, ContextShift<F> evidence$31) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcJ.sp & Serializable)() -> Files.size(path), evidence$30, evidence$31);
    }

    public <F> F move(ExecutionContext blocker, Path source, Path target, Seq<CopyOption> flags, Sync<F> evidence$32, ContextShift<F> evidence$33) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.move(source, target, (CopyOption[])flags.toArray(ClassTag$.MODULE$.apply(CopyOption.class))), evidence$32, evidence$33);
    }

    public <F> Seq<CopyOption> move$default$4() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> FreeC<F, Path, BoxedUnit> tempFileStream(ExecutionContext blocker, Path dir, String prefix, String suffix, Seq<FileAttribute<?>> attributes, Sync<F> evidence$34, ContextShift<F> evidence$35) {
        return Stream$.MODULE$.resource(this.tempFileResource(blocker, dir, prefix, suffix, attributes, evidence$34, evidence$35));
    }

    public <F> String tempFileStream$default$3() {
        return "";
    }

    public <F> String tempFileStream$default$4() {
        return ".tmp";
    }

    public <F> Seq<FileAttribute<?>> tempFileStream$default$5() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> Resource<F, Path> tempFileResource(ExecutionContext blocker, Path dir, String prefix, String suffix, Seq<FileAttribute<?>> attributes, Sync<F> evidence$36, ContextShift<F> evidence$37) {
        return Resource$.MODULE$.make(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.createTempFile(dir, prefix, suffix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), evidence$36, evidence$37), (Function1 & Serializable)x$2 -> package.all$.MODULE$.toFunctorOps(MODULE$.deleteIfExists(blocker, (Path)x$2, evidence$36, evidence$37), (Functor)evidence$36).void(), evidence$36);
    }

    public <F> String tempFileResource$default$3() {
        return "";
    }

    public <F> String tempFileResource$default$4() {
        return ".tmp";
    }

    public <F> Seq<FileAttribute<?>> tempFileResource$default$5() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> FreeC<F, Path, BoxedUnit> tempDirectoryStream(ExecutionContext blocker, Path dir, String prefix, Seq<FileAttribute<?>> attributes, Sync<F> evidence$38, ContextShift<F> evidence$39) {
        return Stream$.MODULE$.resource(this.tempDirectoryResource(blocker, dir, prefix, attributes, evidence$38, evidence$39));
    }

    public <F> String tempDirectoryStream$default$3() {
        return "";
    }

    public <F> Seq<FileAttribute<?>> tempDirectoryStream$default$4() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> Resource<F, Path> tempDirectoryResource(ExecutionContext blocker, Path dir, String prefix, Seq<FileAttribute<?>> attributes, Sync<F> evidence$40, ContextShift<F> evidence$41) {
        return Resource$.MODULE$.make(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.createTempDirectory(dir, prefix, (FileAttribute[])attributes.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), evidence$40, evidence$41), (Function1 & Serializable)p -> ApplicativeErrorOps$.MODULE$.recover$extension(package.all$.MODULE$.catsSyntaxApplicativeError(MODULE$.deleteDirectoryRecursively(blocker, (Path)p, MODULE$.deleteDirectoryRecursively$default$3(), evidence$40, evidence$41), (ApplicativeError)evidence$40), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NoSuchFileException ? BoxedUnit.UNIT : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchFileException;
                return bl;
            }
        }, (ApplicativeError)evidence$40), evidence$40);
    }

    public <F> String tempDirectoryResource$default$3() {
        return "";
    }

    public <F> Seq<FileAttribute<?>> tempDirectoryResource$default$4() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> F createDirectory(ExecutionContext blocker, Path path, Seq<FileAttribute<?>> flags, Sync<F> evidence$42, ContextShift<F> evidence$43) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.createDirectory(path, (FileAttribute[])flags.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), evidence$42, evidence$43);
    }

    public <F> Seq<FileAttribute<?>> createDirectory$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> F createDirectories(ExecutionContext blocker, Path path, Seq<FileAttribute<?>> flags, Sync<F> evidence$44, ContextShift<F> evidence$45) {
        return (F)Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.createDirectories(path, (FileAttribute[])flags.toArray(ClassTag$.MODULE$.apply(FileAttribute.class))), evidence$44, evidence$45);
    }

    public <F> Seq<FileAttribute<?>> createDirectories$default$3() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public <F> FreeC<F, Path, BoxedUnit> directoryStream(ExecutionContext blocker, Path path, Sync<F> evidence$46, ContextShift<F> evidence$47) {
        return this._runJavaCollectionResource(blocker, Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.newDirectoryStream(path), evidence$46, evidence$47), (Function1 & Serializable)x$3 -> CollectionCompat$JIterableOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JIterableOps(x$3)).iterator(), evidence$46, evidence$47);
    }

    public <F> FreeC<F, Path, BoxedUnit> directoryStream(ExecutionContext blocker, Path path, Function1<Path, Object> filter, Sync<F> evidence$48, ContextShift<F> evidence$49) {
        return this._runJavaCollectionResource(blocker, Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.newDirectoryStream(path, entry -> BoxesRunTime.unboxToBoolean((Object)filter.apply(entry))), evidence$48, evidence$49), (Function1 & Serializable)x$4 -> CollectionCompat$JIterableOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JIterableOps(x$4)).iterator(), evidence$48, evidence$49);
    }

    public <F> FreeC<F, Path, BoxedUnit> directoryStream(ExecutionContext blocker, Path path, String glob, Sync<F> evidence$50, ContextShift<F> evidence$51) {
        return this._runJavaCollectionResource(blocker, Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.newDirectoryStream(path, glob), evidence$50, evidence$51), (Function1 & Serializable)x$5 -> CollectionCompat$JIterableOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JIterableOps(x$5)).iterator(), evidence$50, evidence$51);
    }

    public <F> FreeC<F, Path, BoxedUnit> walk(ExecutionContext blocker, Path start, Sync<F> evidence$52, ContextShift<F> evidence$53) {
        return this.walk(blocker, start, (Seq<FileVisitOption>)((Seq)scala.package$.MODULE$.Seq().empty()), evidence$52, evidence$53);
    }

    public <F> FreeC<F, Path, BoxedUnit> walk(ExecutionContext blocker, Path start, Seq<FileVisitOption> options, Sync<F> evidence$54, ContextShift<F> evidence$55) {
        return this.walk(blocker, start, Integer.MAX_VALUE, options, evidence$54, evidence$55);
    }

    public <F> FreeC<F, Path, BoxedUnit> walk(ExecutionContext blocker, Path start, int maxDepth, Seq<FileVisitOption> options, Sync<F> evidence$56, ContextShift<F> evidence$57) {
        return this._runJavaCollectionResource(blocker, Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> Files.walk(start, maxDepth, (FileVisitOption[])options.toArray(ClassTag$.MODULE$.apply(FileVisitOption.class))), evidence$56, evidence$57), (Function1 & Serializable)x$6 -> CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(CollectionCompat$.MODULE$.JIteratorOps(x$6.iterator())), evidence$56, evidence$57);
    }

    public <F> Seq<FileVisitOption> walk$default$4() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private <F, C extends AutoCloseable> FreeC<F, Path, BoxedUnit> _runJavaCollectionResource(ExecutionContext blocker, F javaCollection, Function1<C, Iterator<Path>> collectionIterator, Sync<F> evidence$58, ContextShift<F> evidence$59) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.resource(Resource$.MODULE$.fromAutoCloseable(javaCollection, evidence$58)), (Function1 & Serializable)ds -> new Stream(Stream.PartiallyAppliedFromBlockingIterator$.MODULE$.apply$extension(Stream$.MODULE$.fromBlockingIterator(), blocker, (Iterator)collectionIterator.apply((Object)ds), evidence$58, evidence$59)));
    }

    private static final Resource openNewFile$1(Object computePath$1, Concurrent evidence$10$1, ExecutionContext blocker$2, Seq flags$2, ContextShift evidence$11$1) {
        return Resource$.MODULE$.eval(computePath$1, (Applicative)evidence$10$1).flatMap((Function1 & Serializable)p -> FileHandle$.MODULE$.fromPath((Path)p, blocker$2, (Seq<OpenOption>)flags$2.toList().$colon$colon((Object)StandardOpenOption.WRITE), evidence$10$1, evidence$11$1));
    }

    private static final Object newCursor$1(FileHandle file, Seq flags$2, Concurrent evidence$10$1, ContextShift evidence$11$1) {
        return WriteCursor$.MODULE$.fromFileHandle(file, flags$2.contains((Object)StandardOpenOption.APPEND), evidence$10$1, evidence$11$1);
    }

    public static final /* synthetic */ FreeC $anonfun$writeRotate$3(long newAcc$1, long limit$1, Hotswap fileHotswap$1, Concurrent evidence$10$1, FreeC tl$1, Object computePath$1, ExecutionContext blocker$2, Seq flags$2, ContextShift evidence$11$1, WriteCursor nc2) {
        return newAcc$1 >= limit$1 ? Pull$.MODULE$.flatMap$extension(Pull$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(fileHotswap$1.swap(package$.openNewFile$1(computePath$1, evidence$10$1, blocker$2, flags$2, evidence$11$1)), (FlatMap)evidence$10$1).flatMap((Function1 & Serializable)file -> package$.newCursor$1(file, flags$2, evidence$10$1, evidence$11$1))), (Function1 & Serializable)nc -> new Pull(package$.go$1(fileHotswap$1, nc, 0L, tl$1, limit$1, evidence$10$1, computePath$1, blocker$2, flags$2, evidence$11$1))) : package$.go$1(fileHotswap$1, nc2, newAcc$1, tl$1, limit$1, evidence$10$1, computePath$1, blocker$2, flags$2, evidence$11$1);
    }

    public static final /* synthetic */ FreeC $anonfun$writeRotate$2(long acc$1, WriteCursor cursor$1, long limit$1, Hotswap fileHotswap$1, Concurrent evidence$10$1, Object computePath$1, ExecutionContext blocker$2, Seq flags$2, ContextShift evidence$11$1, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk hd = (Chunk)tuple2._1();
            FreeC tl = ((Stream)tuple2._2()).fs2$Stream$$free();
            long newAcc = acc$1 + (long)hd.size();
            freeC = Pull$.MODULE$.flatMap$extension(cursor$1.writePull((Chunk<Object>)hd), (Function1 & Serializable)nc -> new Pull(package$.$anonfun$writeRotate$3(newAcc, limit$1, fileHotswap$1, evidence$10$1, tl, computePath$1, blocker$2, flags$2, evidence$11$1, nc)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private static final FreeC go$1(Hotswap fileHotswap, WriteCursor cursor, long acc, FreeC s, long limit$1, Concurrent evidence$10$1, Object computePath$1, ExecutionContext blocker$2, Seq flags$2, ContextShift evidence$11$1) {
        int toWrite = (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(limit$1 - acc), (long)Integer.MAX_VALUE);
        return Pull$.MODULE$.flatMap$extension(Stream.ToPull$.MODULE$.unconsLimit$extension(Stream.InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(s)), toWrite), (Function1 & Serializable)x0$1 -> new Pull(package$.$anonfun$writeRotate$2(acc, cursor, limit$1, fileHotswap, evidence$10$1, computePath$1, blocker$2, flags$2, evidence$11$1, x0$1)));
    }

    public static final /* synthetic */ FreeC $anonfun$writeRotate$7(FreeC in$2, Seq flags$2, Concurrent evidence$10$1, ContextShift evidence$11$1, long limit$1, Object computePath$1, ExecutionContext blocker$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Hotswap fileHotswap = (Hotswap)tuple2._1();
        FileHandle fileHandle = (FileHandle)tuple2._2();
        FreeC freeC = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(package$.newCursor$1(fileHandle, flags$2, evidence$10$1, evidence$11$1)), (Function1 & Serializable)cursor -> new Stream(Pull$.MODULE$.stream$extension(package$.go$1(fileHotswap, cursor, 0L, in$2, limit$1, evidence$10$1, computePath$1, blocker$2, flags$2, evidence$11$1), (.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return freeC;
    }

    private package$() {
    }
}

