/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.kernel.Eq;
import cats.kernel.Eq$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class JsonNumber$
implements Serializable {
    public static final JsonNumber$ MODULE$ = new JsonNumber$();
    private static final BigDecimal bigDecimalMinLong = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal bigDecimalMaxLong = new BigDecimal(Long.MAX_VALUE);
    private static final Eq<JsonNumber> eqJsonNumber = Eq$.MODULE$.instance((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)JsonNumber$.$anonfun$eqJsonNumber$1(x0$1, x1$1)));

    public final JsonNumber fromDecimalStringUnsafe(String value) {
        return new JsonDecimal(value);
    }

    public final JsonNumber fromIntegralStringUnsafe(String value) {
        JsonNumber jsonNumber;
        if (!BiggerDecimal$.MODULE$.integralIsValidLong(value)) {
            jsonNumber = new JsonDecimal(value);
        } else {
            long longValue = Long.parseLong(value);
            jsonNumber = value.charAt(0) == '-' && longValue == 0L ? new JsonDecimal(value) : new JsonLong(longValue);
        }
        return jsonNumber;
    }

    public final Option<JsonNumber> fromString(String value) {
        BiggerDecimal result = BiggerDecimal$.MODULE$.parseBiggerDecimalUnsafe(value);
        return result == null ? None$.MODULE$ : new Some((Object)new JsonBiggerDecimal(result, value));
    }

    public boolean bigDecimalIsWhole(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public boolean bigDecimalIsValidLong(BigDecimal value) {
        return this.bigDecimalIsWhole(value) && value.compareTo(bigDecimalMinLong) >= 0 && value.compareTo(bigDecimalMaxLong) <= 0;
    }

    public final Eq<JsonNumber> eqJsonNumber() {
        return eqJsonNumber;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonNumber$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$eqJsonNumber$1(JsonNumber x0$1, JsonNumber x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber2 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonLong) {
                JsonLong jsonLong = (JsonLong)jsonNumber;
                long x = jsonLong.value();
                if (jsonNumber2 instanceof JsonLong) {
                    JsonLong jsonLong2 = (JsonLong)jsonNumber2;
                    long y = jsonLong2.value();
                    if (x != y) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber3 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonDouble) {
                JsonDouble jsonDouble = (JsonDouble)jsonNumber;
                double x = jsonDouble.value();
                if (jsonNumber3 instanceof JsonDouble) {
                    JsonDouble jsonDouble2 = (JsonDouble)jsonNumber3;
                    double y = jsonDouble2.value();
                    if (Double.compare(x, y) != 0) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber4 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonFloat) {
                JsonFloat jsonFloat = (JsonFloat)jsonNumber;
                float x = jsonFloat.value();
                if (jsonNumber4 instanceof JsonFloat) {
                    JsonFloat jsonFloat2 = (JsonFloat)jsonNumber4;
                    float y = jsonFloat2.value();
                    if (Float.compare(x, y) != 0) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber5 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonBigDecimal) {
                JsonBigDecimal jsonBigDecimal = (JsonBigDecimal)jsonNumber;
                BigDecimal x = jsonBigDecimal.value();
                if (jsonNumber5 instanceof JsonBigDecimal) {
                    JsonBigDecimal jsonBigDecimal2 = (JsonBigDecimal)jsonNumber5;
                    BigDecimal y = jsonBigDecimal2.value();
                    if (x.compareTo(y) != 0) return false;
                    return true;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        JsonNumber a = (JsonNumber)tuple2._1();
        JsonNumber b = (JsonNumber)tuple2._2();
        BiggerDecimal biggerDecimal = a.toBiggerDecimal();
        BiggerDecimal biggerDecimal2 = b.toBiggerDecimal();
        if (biggerDecimal != null) {
            if (!biggerDecimal.equals(biggerDecimal2)) return false;
            return true;
        }
        if (biggerDecimal2 == null) return true;
        return false;
    }

    private JsonNumber$() {
    }
}

