/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.hub;

import cats.Applicative;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.implicits$;
import ch.qos.logback.classic.Logger;
import java.io.Serializable;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.ExecutionContexts$;
import net.shrine.http4s.catsio.RepeatedIOTask;
import net.shrine.http4s.catsio.RepeatedIOTask$;
import net.shrine.hub.HubDispatcher$;
import net.shrine.hub.QueryAttemptTimeToLiveExceeded;
import net.shrine.hub.data.store.HubDb$;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.NodeId;
import net.shrine.protocol.version.v2.ErrorResult;
import net.shrine.protocol.version.v2.Node;
import net.shrine.protocol.version.v2.Result;
import net.shrine.protocol.version.v2.ResultStatus;
import net.shrine.protocol.version.v2.UpdateResult;
import net.shrine.protocol.version.v2.UpdateResultWithError;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class OverdueResultsPoller$
implements Loggable {
    public static final OverdueResultsPoller$ MODULE$ = new OverdueResultsPoller$();
    private static final FiniteDuration resultsOverdueAfter;
    private static final FiniteDuration overdueResultsCheckPeriod;
    private static final int overdueResultsBatchSize;
    private static final Timer<IO> timer;
    private static final ContextShift<IO> concurrentEffect;
    private static final RepeatedIOTask scheduler;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
        resultsOverdueAfter = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.resultsOverdueAfter");
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        overdueResultsCheckPeriod = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.hub.result.overdueResultsCheckPeriod");
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        overdueResultsBatchSize = ConfigSource$.MODULE$.config().getInt("shrine.hub.result.overdueResultsBatchSize");
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext());
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        concurrentEffect = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContexts$.MODULE$.crcExecutionContext());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        scheduler = RepeatedIOTask$.MODULE$.scheduleIndefinitely(MODULE$.overdueResultsCheckPeriod(), MODULE$.overdueResultsCheckPeriod(), (Function0 & Serializable)() -> MODULE$.checkForOverdueResults(), "OldResultsPoller", MODULE$.timer(), MODULE$.concurrentEffect());
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        OverdueResultsPoller$ overdueResultsPoller$ = this;
        synchronized (overdueResultsPoller$) {
            if (!bitmap$0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = true;
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if (!bitmap$0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    private FiniteDuration resultsOverdueAfter() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 17");
        }
        return resultsOverdueAfter;
    }

    private FiniteDuration overdueResultsCheckPeriod() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 19");
        }
        return overdueResultsCheckPeriod;
    }

    private int overdueResultsBatchSize() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 21");
        }
        return overdueResultsBatchSize;
    }

    public Timer<IO> timer() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 23");
        }
        return timer;
    }

    public ContextShift<IO> concurrentEffect() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 24");
        }
        return concurrentEffect;
    }

    private RepeatedIOTask scheduler() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: OverdueResultsPoller.scala: 26");
        }
        return scheduler;
    }

    public IO<BoxedUnit> restart() {
        return this.scheduler().restartIO();
    }

    public IO<BoxedUnit> stop() {
        return this.scheduler().stopIO();
    }

    public IO<BoxedUnit> checkForOverdueResults() {
        long before = DateStamp$.MODULE$.now() - this.resultsOverdueAfter().toMillis();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Checking for overdue results - results before ").append(DateStamp$.MODULE$.toDateString$extension(before)).toString());
        return HubDb$.MODULE$.db().selectLatestNodesIO().flatMap((Function1 & Serializable)nodes -> HubDb$.MODULE$.db().countDistinctResultIds(before).flatMap((Function1 & Serializable)resultCount -> OverdueResultsPoller$.$anonfun$checkForOverdueResults$3(before, nodes, BoxesRunTime.unboxToInt((Object)resultCount))));
    }

    private IO<Object> batchProcessResults(long before, int count, Map<NodeId, Node> nodeIdsToNodes) {
        int batchSize = this.overdueResultsBatchSize();
        IndexedSeq batches = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), count / batchSize).map((Function1 & Serializable)x$2 -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> x$2)).map((Function1 & Serializable)batchIO -> batchIO.flatMap((Function1 & Serializable)batch -> OverdueResultsPoller$.$anonfun$batchProcessResults$4(before, batchSize, nodeIdsToNodes, BoxesRunTime.unboxToInt((Object)batch))));
        return ((IO)implicits$.MODULE$.toTraverseOps((Object)batches.toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.ioConcurrentEffect(this.concurrentEffect()))).flatMap((Function1 & Serializable)updateCounts -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)updateCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
    }

    private IO<Object> updateAsOverdue(Result result, Map<NodeId, Node> nodeIdsToNodes) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append(result).append(" from ").append(((Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId()))).key()).append(" is overdue").toString());
        QueryAttemptTimeToLiveExceeded problem = new QueryAttemptTimeToLiveExceeded(result.queryId(), (Node)nodeIdsToNodes.apply((Object)new NodeId(result.adapterNodeId())), this.resultsOverdueAfter());
        ErrorResult overdueResult = result.toError((RawProblem)problem, (ResultStatus)ResultStatus.ErrorFromCrc$.MODULE$, Option$.MODULE$.apply((Object)problem.summary()), result.crcQueryInstanceId(), DateStamp$.MODULE$.now());
        UpdateResultWithError overdueUpdate = new UpdateResultWithError(overdueResult);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Will update ").append(overdueUpdate).toString());
        return HubDispatcher$.MODULE$.updateResultIO((UpdateResult)overdueUpdate).flatMap((Function1 & Serializable)x$5 -> IO$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
    }

    public static final /* synthetic */ IO $anonfun$checkForOverdueResults$3(long before$1, Iterable nodes$1, int resultCount) {
        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append(resultCount).append(" results to examine").toString())).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return MODULE$.batchProcessResults(before$1, resultCount, (Map<NodeId, Node>)((IterableOnceOps)nodes$1.map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NodeId(((Node)node.get()).id())), node.get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1)(JFunction1.mcVI.sp & Serializable)updateCount -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Updated ").append(updateCount).append(" results").toString()));
        });
    }

    public static final /* synthetic */ int $anonfun$batchProcessResults$10(List updateCounts) {
        return BoxesRunTime.unboxToInt((Object)updateCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ IO $anonfun$batchProcessResults$4(long before$2, int batchSize$1, Map nodeIdsToNodes$1, int batch) {
        return HubDb$.MODULE$.db().selectOverdueBatchIO(before$2, batch, batchSize$1).flatMap((Function1 & Serializable)overdueResults -> IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("batch ").append(batch).append(" found ").append(overdueResults.size()).append(" overdue results to update").toString())).flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return ((IO)implicits$.MODULE$.toTraverseOps(overdueResults, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)x$3 -> MODULE$.updateAsOverdue((Result)x$3, (Map<NodeId, Node>)nodeIdsToNodes$1), (Applicative)IO$.MODULE$.ioConcurrentEffect(MODULE$.concurrentEffect()))).map((Function1 & Serializable)updateCounts -> BoxesRunTime.boxToInteger((int)OverdueResultsPoller$.$anonfun$batchProcessResults$10(updateCounts)));
        }));
    }

    private OverdueResultsPoller$() {
    }
}

