/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Semigroupal;
import cats.effect.Bracket;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.ExitCase;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.syntax.BracketOps$;
import cats.effect.syntax.package;
import cats.implicits$;
import cats.syntax.FlattenOps$;
import fs2.Chunk$;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.kafka.CommittableOffsetBatch;
import fs2.kafka.CommittableOffsetBatch$;
import fs2.kafka.ConsumerGroupException$;
import fs2.kafka.KafkaProducer$;
import fs2.kafka.ProducerResult$;
import fs2.kafka.Serializer;
import fs2.kafka.TransactionalKafkaProducer;
import fs2.kafka.TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$;
import fs2.kafka.TransactionalProducerRecords;
import fs2.kafka.TransactionalProducerSettings;
import fs2.kafka.internal.WithTransactionalProducer;
import fs2.kafka.internal.WithTransactionalProducer$;
import fs2.kafka.internal.converters$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.Producer;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TransactionalKafkaProducer$ {
    public static final TransactionalKafkaProducer$ MODULE$ = new TransactionalKafkaProducer$();

    public <F, K, V> Resource<F, TransactionalKafkaProducer.Metrics<F, K, V>> resource(TransactionalProducerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context) {
        return (Resource)implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)Resource$.MODULE$.eval(settings.producerSettings().keySerializer(), F), (Object)Resource$.MODULE$.eval(settings.producerSettings().valueSerializer(), F), WithTransactionalProducer$.MODULE$.apply(settings, F, context))).mapN((Function3 & Serializable)(keySerializer, valueSerializer, withProducer) -> new TransactionalKafkaProducer.Metrics<F, K, V>(F, (WithTransactionalProducer)withProducer, (Serializer)keySerializer, (Serializer)valueSerializer){
            private final ConcurrentEffect F$1;
            private final WithTransactionalProducer withProducer$1;
            private final Serializer keySerializer$1;
            private final Serializer valueSerializer$1;

            public <P> F produce(TransactionalProducerRecords<F, K, V, P> records) {
                return (F)implicits$.MODULE$.toFunctorOps(this.produceTransaction(records), (Functor)this.F$1).map((Function1 & Serializable)x$1 -> ProducerResult$.MODULE$.apply(x$1, records.passthrough()));
            }

            private <P> F produceTransaction(TransactionalProducerRecords<F, K, V, P> records) {
                if (records.records().isEmpty()) {
                    return (F)this.F$1.pure((Object)Chunk$.MODULE$.empty());
                }
                CommittableOffsetBatch<F> batch = CommittableOffsetBatch$.MODULE$.fromFoldableMap(records.records(), (Function1 & Serializable)x$2 -> x$2.offset(), this.F$1, Chunk$.MODULE$.instance());
                Object consumerGroupId = batch.consumerGroupIdsMissing() || batch.consumerGroupIds().size() != 1 ? this.F$1.raiseError((Object)((Object)ConsumerGroupException$.MODULE$.apply(batch.consumerGroupIds()))) : this.F$1.pure(batch.consumerGroupIds().head());
                return (F)implicits$.MODULE$.toFlatMapOps(consumerGroupId, (FlatMap)this.F$1).flatMap((Function1 & Serializable)groupId -> FlattenOps$.MODULE$.flatten$extension(implicits$.MODULE$.catsSyntaxFlatten($this.withProducer$1.exclusiveAccess((Function2 & Serializable)(producer, blocking) -> BracketOps$.MODULE$.bracketCase$extension(package.all$.MODULE$.catsEffectSyntaxBracket(blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.beginTransaction()), (Bracket)$this.F$1), (Function1 & Serializable)x$3 -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps((Object)records.records().flatMap((Function1 & Serializable)x$4 -> x$4.records()), Chunk$.MODULE$.instance()).traverse(KafkaProducer$.MODULE$.produceRecord($this.keySerializer$1, $this.valueSerializer$1, (Producer<byte[], byte[]>)producer, $this.F$1), (Applicative)$this.F$1), (Functor)$this.F$1).map((Function1 & Serializable)x$5 -> implicits$.MODULE$.toTraverseOps(x$5, Chunk$.MODULE$.instance()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)$this.F$1)), (FlatMap)$this.F$1).flatTap((Function1 & Serializable)x$6 -> blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.sendOffsetsToTransaction(converters$.MODULE$.collection().MapHasAsJava(batch.offsets()).asJava(), groupId))), (Function2 & Serializable)(x0$1, x1$1) -> {
                    ExitCase exitCase;
                    ExitCase exitCase2;
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null && ExitCase.Completed$.MODULE$.equals(exitCase2 = (ExitCase)tuple2._2())) {
                        return blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.commitTransaction());
                    }
                    if (tuple2 != null && (ExitCase.Canceled$.MODULE$.equals(exitCase = (ExitCase)tuple2._2()) ? true : exitCase instanceof ExitCase.Error)) {
                        return blocking.apply((JFunction0.mcV.sp & Serializable)() -> producer.abortTransaction());
                    }
                    throw new MatchError((Object)tuple2);
                }, (Bracket)$this.F$1)), (FlatMap)$this.F$1), (FlatMap)$this.F$1));
            }

            public F metrics() {
                return this.withProducer$1.blocking((Function1 & Serializable)x$7 -> converters$.MODULE$.collection().MapHasAsScala(x$7.metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public String toString() {
                return new StringBuilder(27).append("TransactionalKafkaProducer$").append(System.identityHashCode(this)).toString();
            }
            {
                this.F$1 = F$1;
                this.withProducer$1 = withProducer$1;
                this.keySerializer$1 = keySerializer$1;
                this.valueSerializer$1 = valueSerializer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$metrics$1(org.apache.kafka.clients.producer.Producer ), $anonfun$produce$1(fs2.kafka.TransactionalProducerRecords fs2.Chunk ), $anonfun$produceTransaction$1(fs2.kafka.CommittableProducerRecords ), $anonfun$produceTransaction$10(fs2.kafka.internal.Blocking org.apache.kafka.clients.producer.Producer scala.runtime.BoxedUnit cats.effect.ExitCase ), $anonfun$produceTransaction$11(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$12(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$2(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.kafka.TransactionalProducerRecords fs2.kafka.CommittableOffsetBatch java.lang.String ), $anonfun$produceTransaction$3(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.kafka.TransactionalProducerRecords fs2.kafka.CommittableOffsetBatch java.lang.String org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$produceTransaction$4(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$5(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.kafka.TransactionalProducerRecords org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking fs2.kafka.CommittableOffsetBatch java.lang.String scala.runtime.BoxedUnit ), $anonfun$produceTransaction$6(fs2.kafka.CommittableProducerRecords ), $anonfun$produceTransaction$7(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk ), $anonfun$produceTransaction$8(fs2.kafka.internal.Blocking org.apache.kafka.clients.producer.Producer fs2.kafka.CommittableOffsetBatch java.lang.String java.lang.Object ), $anonfun$produceTransaction$9(org.apache.kafka.clients.producer.Producer fs2.kafka.CommittableOffsetBatch java.lang.String )}, serializedLambda);
            }
        }, (Functor)Resource$.MODULE$.catsEffectMonadErrorForResource(F), (Semigroupal)Resource$.MODULE$.catsEffectMonadErrorForResource(F));
    }

    public <F> ConcurrentEffect<F> resource(ConcurrentEffect<F> F) {
        return F;
    }

    public <F, K, V> FreeC<F, TransactionalKafkaProducer.Metrics<F, K, V>, BoxedUnit> stream(TransactionalProducerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context) {
        return Stream$.MODULE$.resource(this.resource(settings, F, context));
    }

    public <F> ConcurrentEffect<F> stream(ConcurrentEffect<F> F) {
        return F;
    }

    public <F> boolean apply() {
        return TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    private TransactionalKafkaProducer$() {
    }
}

