/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.scanner;

import net.shrine.config.AdapterMappings;
import net.shrine.config.AdapterMappingsSource;
import net.shrine.ont.data.OntologyDao;
import net.shrine.ont.messaging.Concept;
import net.shrine.util.Loggable;
import net.shrine.utilities.scanner.QueryFailure;
import net.shrine.utilities.scanner.ScanQueryResult;
import net.shrine.utilities.scanner.ScanResults;
import net.shrine.utilities.scanner.ScanResults$;
import net.shrine.utilities.scanner.Scanner$;
import net.shrine.utilities.scanner.Scanner$Termable$;
import net.shrine.utilities.scanner.ScannerClient;
import net.shrine.utilities.scanner.TermResult;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0005-\u0011qaU2b]:,'O\u0003\u0002\u0004\t\u000591oY1o]\u0016\u0014(BA\u0003\u0007\u0003%)H/\u001b7ji&,7O\u0003\u0002\b\u0011\u000511\u000f\u001b:j]\u0016T\u0011!C\u0001\u0004]\u0016$8\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005!Q\u000f^5m\u0013\t9BC\u0001\u0005M_\u001e<\u0017M\u00197f\u0011!I\u0002A!b\u0001\n\u0003Q\u0012AF7bqRKW.\u001a+p/\u0006LGOR8s%\u0016\u001cX\u000f\u001c;\u0016\u0003m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u0011\u0011,(/\u0019;j_:T!\u0001\t\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002#;\tAA)\u001e:bi&|g\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001c\u0003]i\u0017\r\u001f+j[\u0016$vnV1ji\u001a{'OU3tk2$\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001\u001b\u00035\u0011XmU2b]RKW.Z8vi\"A\u0001\u0006\u0001B\u0001B\u0003%1$\u0001\bsKN\u001b\u0017M\u001c+j[\u0016|W\u000f\u001e\u0011\t\u0011)\u0002!Q1A\u0005\u0002-\nQ#\u00193baR,'/T1qa&twm]*pkJ\u001cW-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc!\u0001\u0004d_:4\u0017nZ\u0005\u0003c9\u0012Q#\u00113baR,'/T1qa&twm]*pkJ\u001cW\r\u0003\u00054\u0001\t\u0005\t\u0015!\u0003-\u0003Y\tG-\u00199uKJl\u0015\r\u001d9j]\u001e\u001c8k\\;sG\u0016\u0004\u0003\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\u0002\u0017=tGo\u001c7pOf$\u0015m\\\u000b\u0002oA\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005I\u0006$\u0018M\u0003\u0002=\r\u0005\u0019qN\u001c;\n\u0005yJ$aC(oi>dwnZ=EC>D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006IaN\u0001\r_:$x\u000e\\8hs\u0012\u000bw\u000e\t\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\u000611\r\\5f]R,\u0012\u0001\u0012\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u0011QbU2b]:,'o\u00117jK:$\b\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u000f\rd\u0017.\u001a8uA!)1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"b!\u0014(P!F\u0013\u0006CA#\u0001\u0011\u0015I\"\n1\u0001\u001c\u0011\u00151#\n1\u0001\u001c\u0011\u0015Q#\n1\u0001-\u0011\u0015)$\n1\u00018\u0011\u0015\u0011%\n1\u0001E\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0011\u00198-\u00198\u0015\u0003Y\u0003\"!R,\n\u0005a\u0013!aC*dC:\u0014Vm];miNDQA\u0017\u0001\u0005\u0012U\u000ba\u0001Z8TG\u0006t\u0007\"\u0002/\u0001\t\u0013i\u0016!C8ci\u0006LgNV5b+\tqF\r\u0006\u0002`aB!Q\u0002\u00192n\u0013\t\tgBA\u0005Gk:\u001cG/[8ocA\u00111\r\u001a\u0007\u0001\t\u0015)7L1\u0001g\u0005\u0005!\u0016CA4k!\ti\u0001.\u0003\u0002j\u001d\t9aj\u001c;iS:<\u0007CA\u0007l\u0013\tagBA\u0002B]f\u0004\"!\u00128\n\u0005=\u0014!aD*dC:\fV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000bE\\\u0006\u0019\u0001:\u0002\u0007\u001d,G\u000f\u0005\u0003\u000eA\n\u001c\bc\u0001;vo6\tq$\u0003\u0002w?\t1a)\u001e;ve\u0016\u0004\"!\u0012=\n\u0005e\u0014!A\u0003+fe6\u0014Vm];mi\")1\u0010\u0001C\u0005y\u0006ArN\u0019;bS:\u0014Vm];miN\fe\u000e\u001a$bS2,(/Z:\u0016\u0007u\f)\u0003F\u0003\u007f\u0003O\ti\u0003\u0005\u0004\u000e\u007f\u0006\r\u00111D\u0005\u0004\u0003\u0003q!A\u0002+va2,'\u0007E\u0003\u0002\u0006\u0005UqO\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u00111\u0003\b\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005!IE/\u001a:bE2,'bAA\n\u001dA1\u0011QAA\u000b\u0003;\u0001R!RA\u0010\u0003GI1!!\t\u0003\u00051\tV/\u001a:z\r\u0006LG.\u001e:f!\r\u0019\u0017Q\u0005\u0003\u0006Kj\u0014\rA\u001a\u0005\b\u0003SQ\b\u0019AA\u0016\u0003\u0015!XM]7t!\u0019\t)!!\u0006\u0002$!9\u0011q\u0006>A\u0002\u0005E\u0012\u0001C9vKJLhi\u001c:\u0011\u000b5\u0001\u00171E7\t\ri\u0003A\u0011BA\u001b)\u00151\u0016qGA(\u0011!\tI$a\rA\u0002\u0005m\u0012AE7baB,GMT3uo>\u00148\u000eV3s[N\u0004b!!\u0010\u0002D\u0005%cbA\u0007\u0002@%\u0019\u0011\u0011\t\b\u0002\rA\u0013X\rZ3g\u0013\u0011\t)%a\u0012\u0003\u0007M+GOC\u0002\u0002B9\u0001B!!\u0010\u0002L%!\u0011QJA$\u0005\u0019\u0019FO]5oO\"A\u0011\u0011KA\u001a\u0001\u0004\tY$A\ruKJl7/\u0012=qK\u000e$X\r\u001a+p\u0005\u0016,f.\\1qa\u0016$\u0007bBA+\u0001\u0011%\u0011qK\u0001\u0007e\u0016\u001c6-\u00198\u0015\u000bY\u000bI&!\u0018\t\u0011\u0005m\u00131\u000ba\u0001\u0003\u0007\t\u0011E\\3wKJ4\u0015N\\5tQ\u0016$7\u000b[8vY\u0012D\u0015M^3CK\u0016tW*\u00199qK\u0012D\u0001\"a\u0018\u0002T\u0001\u0007\u00111A\u0001%]\u00164XM\u001d$j]&\u001c\b.\u001a3TQ>,H\u000e\u001a(pi\"\u000bg/\u001a\"fK:l\u0015\r\u001d9fI\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014!\u0003;p)\u0016\u0014XnU3u)\u0011\tY$a\u001a\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003\u0007\tqA]3tk2$8\u000fC\u0004\u0002d\u0001!I!!\u001c\u0016\t\u0005=$Q\u0004\u000b\u0005\u0003c\u0012y\u0002\u0006\u0003\u0002<\u0005M\u0004BCA;\u0003W\n\t\u0011q\u0001\u0002x\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005e\u0014\u0011\u0012B\u000e\u001d\r)\u00151P\u0004\b\u0003{\u0012\u0001\u0012AA@\u0003\u001d\u00196-\u00198oKJ\u00042!RAA\r\u0019\t!\u0001#\u0001\u0002\u0004N\u0019\u0011\u0011\u0011\u0007\t\u000f-\u000b\t\t\"\u0001\u0002\bR\u0011\u0011q\u0010\u0004\f\u0003\u0017\u000b\t\t%A\u0012\u0002\t\tiI\u0001\u0005UKJl\u0017M\u00197f+\u0011\ty)!(\u0014\u0007\u0005%E\u0002\u0003\u0005\u0002\u0014\u0006%e\u0011AAK\u0003\u001d9W\r\u001e+fe6$B!!\u0013\u0002\u0018\"A\u0011\u0011TAI\u0001\u0004\tY*A\u0001u!\r\u0019\u0017Q\u0014\u0003\u0007K\u0006%%\u0019\u00014\t\u0011\u0005M\u0015\u0011\u0012D\u0001\u0003C#B!!\u0013\u0002$\"A\u0011\u0011TAP\u0001\u0004\t)\u000bE\u0003F\u0003?\tYjB\u0005\u0002*\u0006\u0005\u0005\u0012\u0001\u0002\u0002,\u0006AA+\u001a:nC\ndW\r\u0005\u0003\u0002.\u0006=VBAAA\r%\tY)!!\t\u0002\t\t\tlE\u0002\u000202AqaSAX\t\u0003\t)\f\u0006\u0002\u0002,\"Q\u0011\u0011XAX\u0005\u0004%\u0019!a/\u0002!M$(/\u001b8h\u0013N$VM]7bE2,WCAA_!\u0019\ti+!#\u0002J!I\u0011\u0011YAXA\u0003%\u0011QX\u0001\u0012gR\u0014\u0018N\\4JgR+'/\\1cY\u0016\u0004\u0003BCAc\u0003_\u0013\r\u0011b\u0001\u0002H\u0006!B/\u001a:n%\u0016\u001cX\u000f\u001c;JgR+'/\\1cY\u0016,\"!!3\u0011\u000b\u00055\u0016\u0011R<\t\u0013\u00055\u0017q\u0016Q\u0001\n\u0005%\u0017!\u0006;fe6\u0014Vm];mi&\u001bH+\u001a:nC\ndW\rI\u0004\t\u0003#\f\t\t#\u0002\u0002T\u0006i\u0011+^3ss\u0012+g-Y;miN\u0004B!!,\u0002V\u001aA\u0011q[AA\u0011\u000b\tINA\u0007Rk\u0016\u0014\u0018\u0010R3gCVdGo]\n\u0004\u0003+d\u0001bB&\u0002V\u0012\u0005\u0011Q\u001c\u000b\u0003\u0003'D!\"!9\u0002V\n\u0007I\u0011AAr\u0003\u001d!x\u000e]5d\u0013\u0012,\"!!:\u0011\t\u0005\u001d\u0018\u0011_\u0007\u0003\u0003STA!a;\u0002n\u0006!A.\u00198h\u0015\t\ty/\u0001\u0003kCZ\f\u0017\u0002BA'\u0003SD\u0011\"!>\u0002V\u0002\u0006I!!:\u0002\u0011Q|\u0007/[2JI\u0002B!\"!?\u0002V\n\u0007I\u0011AA~\u0003-yW\u000f\u001e9viRK\b/Z:\u0016\u0005\u0005u\bCBA\u0000\u0005\u0013\u0011Y!\u0004\u0002\u0003\u0002)!!1\u0001B\u0003\u0003%IW.\\;uC\ndWMC\u0002\u0003\b9\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)E!\u0001\u0011\t\t5!1C\u0007\u0003\u0005\u001fQ1A!\u0005\u0007\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\u000b\u0005\u001f\u0011\u0001CU3tk2$x*\u001e;qkR$\u0016\u0010]3\t\u0013\te\u0011Q\u001bQ\u0001\n\u0005u\u0018\u0001D8viB,H\u000fV=qKN\u0004\u0003cA2\u0003\u001e\u00111Q-a\u001bC\u0002\u0019D\u0001\"!\u001b\u0002l\u0001\u0007!\u0011\u0005\t\u0007\u0003\u000b\t)Ba\t\u0011\u000b\u0015\u000byBa\u0007")
public final class Scanner
implements Loggable {
    private final Duration maxTimeToWaitForResult;
    private final Duration reScanTimeout;
    private final AdapterMappingsSource adapterMappingsSource;
    private final OntologyDao ontologyDao;
    private final ScannerClient client;
    private final Logger internaLogger;
    private final boolean debugEnabled;
    private final boolean infoEnabled;
    private volatile byte bitmap$0;

    private Logger internaLogger$lzycompute() {
        Scanner scanner = this;
        synchronized (scanner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.internaLogger = Loggable.class.internaLogger((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.internaLogger;
        }
    }

    public Logger internaLogger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.internaLogger$lzycompute() : this.internaLogger;
    }

    private boolean debugEnabled$lzycompute() {
        Scanner scanner = this;
        synchronized (scanner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.debugEnabled = Loggable.class.debugEnabled((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.debugEnabled;
        }
    }

    public boolean debugEnabled() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.debugEnabled$lzycompute() : this.debugEnabled;
    }

    private boolean infoEnabled$lzycompute() {
        Scanner scanner = this;
        synchronized (scanner) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.infoEnabled = Loggable.class.infoEnabled((Loggable)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.infoEnabled;
        }
    }

    public boolean infoEnabled() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.infoEnabled$lzycompute() : this.infoEnabled;
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public Duration maxTimeToWaitForResult() {
        return this.maxTimeToWaitForResult;
    }

    public Duration reScanTimeout() {
        return this.reScanTimeout;
    }

    public AdapterMappingsSource adapterMappingsSource() {
        return this.adapterMappingsSource;
    }

    public OntologyDao ontologyDao() {
        return this.ontologyDao;
    }

    public ScannerClient client() {
        return this.client;
    }

    public ScanResults scan() {
        return this.doScan();
    }

    public ScanResults doScan() {
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shrine Scanner starting";
            }
        });
        Set mappedNetworkTerms = ((AdapterMappings)this.adapterMappingsSource().load().get()).networkTerms();
        Set termsExpectedToBeUnmapped = (Set)this.allShrineOntologyTerms$1().$minus$minus((GenTraversableOnce)mappedNetworkTerms);
        this.info((Function0<Object>)new Serializable(this, mappedNetworkTerms, termsExpectedToBeUnmapped){
            public static final long serialVersionUID = 0L;
            private final Set mappedNetworkTerms$1;
            private final Set termsExpectedToBeUnmapped$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We expect ", " to be mapped, and ", " to be unmapped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mappedNetworkTerms$1.size()), BoxesRunTime.boxToInteger((int)this.termsExpectedToBeUnmapped$1.size())}));
            }
            {
                this.mappedNetworkTerms$1 = mappedNetworkTerms$1;
                this.termsExpectedToBeUnmapped$1 = termsExpectedToBeUnmapped$1;
            }
        });
        return this.doScan((Set<String>)mappedNetworkTerms, (Set<String>)termsExpectedToBeUnmapped);
    }

    private <T> Function1<T, ScanQueryResult> obtainVia(Function1<T, Future<TermResult>> get) {
        return new Serializable(this, get){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Scanner $outer;
            private final Function1 get$1;

            public final ScanQueryResult apply(T input) {
                ScanQueryResult scanQueryResult;
                try {
                    TermResult result = (TermResult)Await$.MODULE$.result((Awaitable)this.get$1.apply(input), this.$outer.maxTimeToWaitForResult());
                    this.$outer.debug((Function0<Object>)new Serializable(this, input, result){
                        public static final long serialVersionUID = 0L;
                        private final Object input$1;
                        private final TermResult result$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Status ", " received, queried for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.result$1.status(), this.input$1}));
                        }
                        {
                            this.input$1 = input$1;
                            this.result$1 = result$1;
                        }
                    });
                    scanQueryResult = result;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.warn((Function0<Object>)new Serializable(this, input){
                        public static final long serialVersionUID = 0L;
                        private final Object input$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error obtaining results for input ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.input$1}));
                        }
                        {
                            this.input$1 = input$1;
                        }
                    }, e);
                    QueryFailure<T> queryFailure = new QueryFailure<T>(input, e);
                    scanQueryResult = queryFailure;
                }
                return scanQueryResult;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.get$1 = get$1;
            }
        };
    }

    private <T> Tuple2<Iterable<TermResult>, Iterable<QueryFailure<T>>> obtainResultsAndFailures(Iterable<T> terms, Function1<T, ScanQueryResult> queryFor) {
        Iterable results = (Iterable)terms.map(queryFor, Iterable$.MODULE$.canBuildFrom());
        return new Tuple2(results.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScanQueryResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TermResult) {
                    TermResult termResult = (TermResult)A1;
                    object = termResult;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScanQueryResult x1) {
                ScanQueryResult scanQueryResult = x1;
                boolean bl = scanQueryResult instanceof TermResult;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom()), results.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScanQueryResult, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof QueryFailure) {
                    QueryFailure queryFailure = (QueryFailure)A1;
                    object = queryFailure;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScanQueryResult x2) {
                ScanQueryResult scanQueryResult = x2;
                boolean bl = scanQueryResult instanceof QueryFailure;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private ScanResults doScan(Set<String> mappedNetworkTerms, Set<String> termsExpectedToBeUnmapped) {
        Function1 queryFor = this.obtainVia((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Scanner $outer;

            public final Future<TermResult> apply(String term) {
                return this.$outer.client().query(term);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Tuple2<Iterable<TermResult>, Iterable<QueryFailure<String>>> tuple2 = this.obtainResultsAndFailures((Iterable)mappedNetworkTerms, queryFor);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable resultsForMappedTerms = (Iterable)tuple2._1();
            Iterable failuresForMappedTerms = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)resultsForMappedTerms, (Object)failuresForMappedTerms);
            Iterable resultsForMappedTerms2 = (Iterable)tuple23._1();
            Iterable failuresForMappedTerms2 = (Iterable)tuple23._2();
            Tuple2<Iterable<TermResult>, Iterable<QueryFailure<String>>> tuple24 = this.obtainResultsAndFailures((Iterable)termsExpectedToBeUnmapped, queryFor);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Iterable resultsForUnMappedTerms = (Iterable)tuple24._1();
                Iterable failuresForUnMappedTerms = (Iterable)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)resultsForUnMappedTerms, (Object)failuresForUnMappedTerms);
                Iterable resultsForUnMappedTerms2 = (Iterable)tuple26._1();
                Iterable failuresForUnMappedTerms2 = (Iterable)tuple26._2();
                Tuple2 tuple27 = resultsForMappedTerms2.partition((Function1)new $anonfun$2(this));
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Iterable finishedAndShouldHaveBeenMapped = (Iterable)tuple27._1();
                    Iterable didntFinishAndShouldHaveBeenMapped = (Iterable)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)finishedAndShouldHaveBeenMapped, (Object)didntFinishAndShouldHaveBeenMapped);
                    Iterable finishedAndShouldHaveBeenMapped2 = (Iterable)tuple29._1();
                    Iterable didntFinishAndShouldHaveBeenMapped2 = (Iterable)tuple29._2();
                    Tuple2 tuple210 = resultsForUnMappedTerms2.partition((Function1)new $anonfun$3(this));
                    if (tuple210 != null) {
                        Tuple2 tuple211;
                        Iterable finishedAndShouldNotHaveBeenMapped = (Iterable)tuple210._1();
                        Iterable didntFinishAndShouldNotHaveBeenMapped = (Iterable)tuple210._2();
                        Tuple2 tuple212 = tuple211 = new Tuple2((Object)finishedAndShouldNotHaveBeenMapped, (Object)didntFinishAndShouldNotHaveBeenMapped);
                        Iterable finishedAndShouldNotHaveBeenMapped2 = (Iterable)tuple212._1();
                        Iterable didntFinishAndShouldNotHaveBeenMapped2 = (Iterable)tuple212._2();
                        Iterable shouldHaveBeenMapped = (Iterable)finishedAndShouldHaveBeenMapped2.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TermResult x$8) {
                                return x$8.status().isError();
                            }
                        });
                        Iterable shouldNotHaveBeenMapped = (Iterable)finishedAndShouldNotHaveBeenMapped2.filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TermResult x$9) {
                                return x$9.status().isError();
                            }
                        });
                        ScanResults reScanResults = this.reScan((Iterable<TermResult>)didntFinishAndShouldHaveBeenMapped2, (Iterable<TermResult>)didntFinishAndShouldNotHaveBeenMapped2);
                        Set finalSouldHaveBeenMappedSet = (Set)this.toTermSet((Iterable<TermResult>)shouldHaveBeenMapped).$plus$plus(reScanResults.shouldHaveBeenMapped());
                        Set finalSouldNotHaveBeenMappedSet = (Set)this.toTermSet((Iterable<TermResult>)shouldNotHaveBeenMapped).$plus$plus(reScanResults.shouldNotHaveBeenMapped());
                        Set failed = (Set)this.toTermSet((Iterable)failuresForMappedTerms2.$plus$plus((GenTraversableOnce)failuresForUnMappedTerms2, Iterable$.MODULE$.canBuildFrom()), Scanner$Termable$.MODULE$.stringIsTermable()).$plus$plus(reScanResults.failed());
                        return new ScanResults((Set<String>)finalSouldHaveBeenMappedSet, (Set<String>)finalSouldNotHaveBeenMappedSet, reScanResults.neverFinished(), (Set<String>)failed);
                    }
                    throw new MatchError((Object)tuple210);
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private ScanResults reScan(Iterable<TermResult> neverFinishedShouldHaveBeenMapped, Iterable<TermResult> neverFinishedShouldNotHaveBeenMapped) {
        Tuple2<Iterable<TermResult>, Iterable<QueryFailure<TermResult>>> tuple2;
        block4: {
            Tuple2<Iterable<TermResult>, Iterable<QueryFailure<TermResult>>> tuple22;
            block5: {
                Tuple2 tuple23;
                block6: {
                    Tuple2 tuple24;
                    block7: {
                        ScanResults scanResults;
                        block3: {
                            Tuple2 tuple25;
                            Tuple2 tuple26;
                            Tuple2 tuple27;
                            Tuple2 tuple28;
                            block2: {
                                if (!neverFinishedShouldHaveBeenMapped.isEmpty() || !neverFinishedShouldNotHaveBeenMapped.isEmpty()) break block2;
                                scanResults = ScanResults$.MODULE$.empty();
                                break block3;
                            }
                            int total = neverFinishedShouldHaveBeenMapped.size() + neverFinishedShouldNotHaveBeenMapped.size();
                            this.info((Function0<Object>)new Serializable(this, total){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Scanner $outer;
                                private final int total$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " before retreiving results for ", " incomplete queries..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reScanTimeout(), BoxesRunTime.boxToInteger((int)this.total$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.total$1 = total$1;
                                }
                            });
                            Thread.sleep(this.reScanTimeout().toMillis());
                            Function1 retrieve = this.obtainVia((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Scanner $outer;

                                public final Future<TermResult> apply(TermResult termResult) {
                                    return this.$outer.client().retrieveResults(termResult);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            tuple2 = this.obtainResultsAndFailures(neverFinishedShouldHaveBeenMapped, retrieve);
                            if (tuple2 == null) break block4;
                            Iterable neverFinishedShouldHaveBeenMappedRetries = (Iterable)tuple2._1();
                            Iterable failedShouldHaveBeenMappedRetries = (Iterable)tuple2._2();
                            Tuple2 tuple29 = tuple28 = new Tuple2((Object)neverFinishedShouldHaveBeenMappedRetries, (Object)failedShouldHaveBeenMappedRetries);
                            Iterable neverFinishedShouldHaveBeenMappedRetries2 = (Iterable)tuple29._1();
                            Iterable failedShouldHaveBeenMappedRetries2 = (Iterable)tuple29._2();
                            tuple22 = this.obtainResultsAndFailures(neverFinishedShouldNotHaveBeenMapped, retrieve);
                            if (tuple22 == null) break block5;
                            Iterable neverFinishedShouldNotHaveBeenMappedRetries = (Iterable)tuple22._1();
                            Iterable failedShouldNotHaveBeenMappedRetries = (Iterable)tuple22._2();
                            Tuple2 tuple210 = tuple27 = new Tuple2((Object)neverFinishedShouldNotHaveBeenMappedRetries, (Object)failedShouldNotHaveBeenMappedRetries);
                            Iterable neverFinishedShouldNotHaveBeenMappedRetries2 = (Iterable)tuple210._1();
                            Iterable failedShouldNotHaveBeenMappedRetries2 = (Iterable)tuple210._2();
                            tuple23 = neverFinishedShouldHaveBeenMappedRetries2.partition((Function1)new $anonfun$7(this));
                            if (tuple23 == null) break block6;
                            Iterable doneShouldHaveBeenMapped = (Iterable)tuple23._1();
                            Iterable stillNotFinishedShouldHaveBeenMapped = (Iterable)tuple23._2();
                            Tuple2 tuple211 = tuple26 = new Tuple2((Object)doneShouldHaveBeenMapped, (Object)stillNotFinishedShouldHaveBeenMapped);
                            Iterable doneShouldHaveBeenMapped2 = (Iterable)tuple211._1();
                            Iterable stillNotFinishedShouldHaveBeenMapped2 = (Iterable)tuple211._2();
                            tuple24 = neverFinishedShouldNotHaveBeenMappedRetries2.partition((Function1)new $anonfun$8(this));
                            if (tuple24 == null) break block7;
                            Iterable doneShouldNotHaveBeenMapped = (Iterable)tuple24._1();
                            Iterable stillNotFinishedShouldNotHaveBeenMapped = (Iterable)tuple24._2();
                            Tuple2 tuple212 = tuple25 = new Tuple2((Object)doneShouldNotHaveBeenMapped, (Object)stillNotFinishedShouldNotHaveBeenMapped);
                            Iterable doneShouldNotHaveBeenMapped2 = (Iterable)tuple212._1();
                            Iterable stillNotFinishedShouldNotHaveBeenMapped2 = (Iterable)tuple212._2();
                            Iterable shouldHaveBeenMapped = (Iterable)doneShouldHaveBeenMapped2.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$16) {
                                    return x$16.status().isError();
                                }
                            });
                            Iterable shouldNotHaveBeenMapped = (Iterable)doneShouldNotHaveBeenMapped2.filterNot((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$17) {
                                    return x$17.status().isError();
                                }
                            });
                            Iterable stillNotFinished = (Iterable)stillNotFinishedShouldHaveBeenMapped2.$plus$plus((GenTraversableOnce)stillNotFinishedShouldNotHaveBeenMapped2, Iterable$.MODULE$.canBuildFrom());
                            Iterable failed = (Iterable)failedShouldHaveBeenMappedRetries2.$plus$plus((GenTraversableOnce)failedShouldNotHaveBeenMappedRetries2, Iterable$.MODULE$.canBuildFrom());
                            scanResults = new ScanResults(this.toTermSet((Iterable<TermResult>)shouldHaveBeenMapped), this.toTermSet((Iterable<TermResult>)shouldNotHaveBeenMapped), this.toTermSet((Iterable<TermResult>)stillNotFinished), this.toTermSet(failed, Scanner$Termable$.MODULE$.termResultIsTermable()));
                        }
                        return scanResults;
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    private Set<String> toTermSet(Iterable<TermResult> results) {
        return ((TraversableOnce)results.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TermResult x$18) {
                return x$18.term();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private <T> Set<String> toTermSet(Iterable<QueryFailure<T>> results, Termable<T> evidence$1) {
        Termable termable = (Termable)Predef$.MODULE$.implicitly(evidence$1);
        return ((TraversableOnce)results.map((Function1)new Serializable(this, termable){
            public static final long serialVersionUID = 0L;
            private final Termable eta$0$1$1;

            public final String apply(QueryFailure<T> t) {
                return this.eta$0$1$1.getTerm(t);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private final Set allShrineOntologyTerms$1() {
        return ((TraversableOnce)this.ontologyDao().ontologyEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Concept x$1) {
                return x$1.path();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public Scanner(Duration maxTimeToWaitForResult, Duration reScanTimeout, AdapterMappingsSource adapterMappingsSource, OntologyDao ontologyDao, ScannerClient client) {
        this.maxTimeToWaitForResult = maxTimeToWaitForResult;
        this.reScanTimeout = reScanTimeout;
        this.adapterMappingsSource = adapterMappingsSource;
        this.ontologyDao = ontologyDao;
        this.client = client;
        Loggable.class.$init$((Loggable)this);
    }

    public static interface Termable<T> {
        public String getTerm(T var1);

        public String getTerm(QueryFailure<T> var1);
    }
}

