/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Dispatcher;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.BoundedFIFO;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncAppender
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    BoundedFIFO bf = new BoundedFIFO(128);
    AppenderAttachableImpl aai = new AppenderAttachableImpl();
    Dispatcher dispatcher = new Dispatcher(this.bf, this);
    boolean locationInfo = false;
    boolean interruptedWarningMessage = false;

    public AsyncAppender() {
        this.dispatcher.start();
    }

    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.addAppender(newAppender);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void append(LoggingEvent event) {
        if (!this.dispatcher.isAlive()) {
            AppenderAttachableImpl appenderAttachableImpl = this.aai;
            synchronized (appenderAttachableImpl) {
                this.aai.appendLoopOnAppenders(event);
                return;
            }
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            while (true) {
                if (!this.bf.isFull()) {
                    this.bf.put(event);
                    if (!this.bf.wasEmpty()) return;
                    this.bf.notify();
                    return;
                }
                try {
                    this.bf.wait();
                }
                catch (InterruptedException e) {
                    if (!this.interruptedWarningMessage) {
                        this.interruptedWarningMessage = true;
                        LogLog.warn("AsyncAppender interrupted.", e);
                        continue;
                    }
                    LogLog.warn("AsyncAppender interrupted again.");
                }
            }
        }
    }

    public void close() {
        AsyncAppender asyncAppender = this;
        synchronized (asyncAppender) {
            if (this.closed) {
                Object var2_3 = null;
                return;
            }
            this.closed = true;
        }
        this.dispatcher.close();
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            LogLog.error("Got an InterruptedException while waiting for the dispatcher to finish.", e);
        }
        this.dispatcher = null;
        this.bf = null;
    }

    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            Enumeration enumeration = this.aai.getAllAppenders();
            Object var3_3 = null;
            return enumeration;
        }
    }

    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            Appender appender = this.aai.getAppender(name);
            Object var4_4 = null;
            return appender;
        }
    }

    public int getBufferSize() {
        return this.bf.getMaxSize();
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAllAppenders();
        }
    }

    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(name);
        }
    }

    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.aai;
        synchronized (appenderAttachableImpl) {
            this.aai.removeAppender(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setBufferSize(int size) {
        this.bf.resize(size);
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }
}

