/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.scanner;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class FileNameSource$ {
    public static final FileNameSource$ MODULE$;
    private final SimpleDateFormat dateFormat;
    private final Regex endingNumberRegex;
    private final String base;
    private volatile byte bitmap$init$0;

    static {
        new FileNameSource$();
    }

    private SimpleDateFormat dateFormat() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.dateFormat;
        }
        throw new UninitializedFieldError("Uninitialized field: FileNameSource.scala: 14");
    }

    public Regex endingNumberRegex() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.endingNumberRegex;
        }
        throw new UninitializedFieldError("Uninitialized field: FileNameSource.scala: 16");
    }

    public String base() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.base;
        }
        throw new UninitializedFieldError("Uninitialized field: FileNameSource.scala: 18");
    }

    public String nextOutputFileName() {
        String string;
        String dateString = this.dateFormat().format(new Date());
        String baseName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.base(), dateString}));
        String baseNameWithExtension = new StringBuilder().append((Object)baseName).append((Object)".csv").toString();
        if (this.exists(baseNameWithExtension)) {
            int n;
            Seq<File> seq = this.numberedFiles();
            if (Nil$.MODULE$.equals(seq)) {
                n = 0;
            } else {
                File highestNumberedFile = (File)((IterableLike)((SeqLike)seq.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse()).head();
                n = BoxesRunTime.unboxToInt((Object)this.numberOf(highestNumberedFile.getName()).map((Function1)new Serializable(){

                    public final int apply(int x$1) {
                        return this.apply$mcII$sp(x$1);
                    }

                    public int apply$mcII$sp(int x$1) {
                        return x$1 + 1;
                    }
                }).getOrElse((Function0)new Serializable(){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
            int fileNumber = n;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName, BoxesRunTime.boxToInteger((int)fileNumber)}));
        } else {
            string = baseNameWithExtension;
        }
        return string;
    }

    public boolean exists(String fileName) {
        return new File(fileName).exists();
    }

    public Option<Object> numberOf(String fileName) {
        None$ none$;
        String string = fileName;
        Option option = this.endingNumberRegex().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String i = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = Try$.MODULE$.apply((Function0)new Serializable(i){
                private final String i$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(this.i$1)).toInt();
                }
                {
                    this.i$1 = i$1;
                }
            }).toOption();
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Seq<File> numberedFiles() {
        File cwd = new File(".");
        FilenameFilter fileNameFilter = new FilenameFilter(){

            public boolean accept(File enclosingDir, String fileName) {
                return FileNameSource$.MODULE$.endingNumberRegex().pattern().matcher(fileName).matches();
            }
        };
        return Predef$.MODULE$.wrapRefArray((Object[])cwd.listFiles(fileNameFilter));
    }

    private FileNameSource$() {
        MODULE$ = this;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.endingNumberRegex = new StringOps(Predef$.MODULE$.augmentString(".*\\.(\\d+)\\.csv$")).r();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.base = "scanner-output";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

