/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.scanner;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreDescriptorParser$;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.Credential;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.ResultOutputTypes$;
import net.shrine.utilities.scallop.Keys$;
import net.shrine.utilities.scanner.FileNameSource$;
import net.shrine.utilities.scanner.ScannerConfig;
import net.shrine.utilities.scanner.ScannerConfig$ScannerConfigKeys$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple11;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.util.Try$;

public final class ScannerConfig$
implements Serializable {
    public static final ScannerConfig$ MODULE$;

    static {
        new ScannerConfig$();
    }

    public Duration getDuration(String keyName, Config subConfig) {
        block5: {
            FiniteDuration finiteDuration;
            block3: {
                block4: {
                    block2: {
                        if (!subConfig.hasPath(Keys$.MODULE$.milliseconds())) break block2;
                        finiteDuration = new package.DurationLong(package$.MODULE$.DurationLong(subConfig.getLong(Keys$.MODULE$.milliseconds()))).milliseconds();
                        break block3;
                    }
                    if (!subConfig.hasPath(Keys$.MODULE$.seconds())) break block4;
                    finiteDuration = new package.DurationLong(package$.MODULE$.DurationLong(subConfig.getLong(Keys$.MODULE$.seconds()))).seconds();
                    break block3;
                }
                if (!subConfig.hasPath(Keys$.MODULE$.minutes())) break block5;
                finiteDuration = new package.DurationLong(package$.MODULE$.DurationLong(subConfig.getLong(Keys$.MODULE$.minutes()))).minutes();
            }
            return finiteDuration;
        }
        throw new ConfigException.Missing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to find one of ", ".{", ", ", ", ", "} at subConfig ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyName, Keys$.MODULE$.milliseconds(), Keys$.MODULE$.seconds(), Keys$.MODULE$.minutes(), subConfig})));
    }

    public ScannerConfig apply(Config config) {
        return new ScannerConfig(this.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.adapterMappingsFile(), config), this.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.ontologySqlFile(), config), this.duration$1(ScannerConfig$ScannerConfigKeys$.MODULE$.reScanTimeout(), config), this.duration$1(ScannerConfig$ScannerConfigKeys$.MODULE$.maxTimeToWaitForResults(), config), this.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.shrineUrl(), config), this.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.projectId(), config), this.authInfo$1(ScannerConfig$ScannerConfigKeys$.MODULE$.credentials(), config), (String)Try$.MODULE$.apply((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply() {
                return ScannerConfig$.MODULE$.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.outputFile(), this.config$1);
            }
            {
                this.config$1 = config$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FileNameSource$.MODULE$.nextOutputFileName();
            }
        }), KeyStoreDescriptorParser$.MODULE$.apply(config.getConfig(ScannerConfig$ScannerConfigKeys$.MODULE$.keystore())), this.net$shrine$utilities$scanner$ScannerConfig$$string$1(ScannerConfig$ScannerConfigKeys$.MODULE$.pmUrl(), config), (Set<ResultOutputType>)((Set)Try$.MODULE$.apply((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final Set<ResultOutputType> apply() {
                return ResultOutputTypes$.MODULE$.fromConfig(this.config$1.getConfig(ScannerConfig$ScannerConfigKeys$.MODULE$.breakdownResultOutputTypes()));
            }
            {
                this.config$1 = config$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<ResultOutputType> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        })));
    }

    public ScannerConfig apply(String adapterMappingsFile, String ontologySqlFile, Duration reScanTimeout, Duration maxTimeToWaitForResults, String shrineUrl, String projectId, AuthenticationInfo authorization, String outputFile, KeyStoreDescriptor keystoreDescriptor, String pmUrl, Set<ResultOutputType> breakdownTypes) {
        return new ScannerConfig(adapterMappingsFile, ontologySqlFile, reScanTimeout, maxTimeToWaitForResults, shrineUrl, projectId, authorization, outputFile, keystoreDescriptor, pmUrl, breakdownTypes);
    }

    public Option<Tuple11<String, String, Duration, Duration, String, String, AuthenticationInfo, String, KeyStoreDescriptor, String, Set<ResultOutputType>>> unapply(ScannerConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.adapterMappingsFile(), (Object)x$0.ontologySqlFile(), (Object)x$0.reScanTimeout(), (Object)x$0.maxTimeToWaitForResults(), (Object)x$0.shrineUrl(), (Object)x$0.projectId(), (Object)x$0.authorization(), (Object)x$0.outputFile(), (Object)x$0.keystoreDescriptor(), (Object)x$0.pmUrl(), x$0.breakdownTypes()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void requirePath$1(String path, Config subConfig$1) {
        if (subConfig$1.hasPath(path)) {
            return;
        }
        throw new ConfigException.Missing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to find '", "' in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, subConfig$1})));
    }

    private final AuthenticationInfo getAuthInfo$1(Config subConfig) {
        this.requirePath$1(Keys$.MODULE$.domain(), subConfig);
        this.requirePath$1(Keys$.MODULE$.username(), subConfig);
        this.requirePath$1(Keys$.MODULE$.password(), subConfig);
        return new AuthenticationInfo(subConfig.getString(Keys$.MODULE$.domain()), subConfig.getString(Keys$.MODULE$.username()), new Credential(subConfig.getString(Keys$.MODULE$.password()), false));
    }

    public final String net$shrine$utilities$scanner$ScannerConfig$$string$1(String k, Config config$1) {
        return config$1.getString(k);
    }

    private final Duration duration$1(String k, Config config$1) {
        return this.getDuration(k, config$1.getConfig(k));
    }

    private final AuthenticationInfo authInfo$1(String k, Config config$1) {
        return this.getAuthInfo$1(config$1.getConfig(k));
    }

    private ScannerConfig$() {
        MODULE$ = this;
    }
}

