/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.scanner;

import java.io.FileInputStream;
import java.io.InputStream;
import net.shrine.adapter.client.AdapterClient;
import net.shrine.adapter.client.RemoteAdapterClient$;
import net.shrine.authentication.Authenticator;
import net.shrine.broadcaster.AdapterClientBroadcaster;
import net.shrine.broadcaster.BroadcastAndAggregationService;
import net.shrine.broadcaster.Broadcaster;
import net.shrine.broadcaster.BroadcasterClient;
import net.shrine.broadcaster.InJvmBroadcasterClient;
import net.shrine.broadcaster.NodeHandle;
import net.shrine.broadcaster.SigningBroadcastAndAggregationService;
import net.shrine.broadcaster.dao.HubDao;
import net.shrine.client.HttpClient;
import net.shrine.client.JerseyHttpClient;
import net.shrine.client.JerseyHttpClient$;
import net.shrine.client.Poster;
import net.shrine.config.mappings.AdapterMappingsSource;
import net.shrine.config.mappings.FileSystemFormatDetectingAdapterMappingsSource;
import net.shrine.crypto.CertCollection;
import net.shrine.crypto.DefaultSignerVerifier;
import net.shrine.crypto.KeyStoreCertCollection;
import net.shrine.crypto.KeyStoreCertCollection$;
import net.shrine.crypto.Signer;
import net.shrine.crypto.SigningCertStrategy$;
import net.shrine.crypto.TrustParam;
import net.shrine.hms.authentication.EcommonsPmAuthenticator;
import net.shrine.ont.data.OntologyDao;
import net.shrine.ont.data.ShrineSqlOntologyDao;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.NodeId;
import net.shrine.protocol.SingleNodeResult;
import net.shrine.protocol.query.QueryDefinition;
import net.shrine.utilities.scanner.BroadcastServiceScannerClient;
import net.shrine.utilities.scanner.ClasspathAndCommandLineScannerConfigSource$;
import net.shrine.utilities.scanner.CommandLineScannerConfigParser;
import net.shrine.utilities.scanner.ScanResults;
import net.shrine.utilities.scanner.Scanner;
import net.shrine.utilities.scanner.ScannerConfig;
import net.shrine.utilities.scanner.ScannerModule$;
import net.shrine.utilities.scanner.SingleThreadExecutionContext$;
import net.shrine.utilities.scanner.SingleThreadExecutionContext$Implicits$;
import scala.Function0;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0003\u0017\ti1kY1o]\u0016\u0014Xj\u001c3vY\u0016T!a\u0001\u0003\u0002\u000fM\u001c\u0017M\u001c8fe*\u0011QAB\u0001\nkRLG.\u001b;jKNT!a\u0002\u0005\u0002\rMD'/\u001b8f\u0015\u0005I\u0011a\u00018fi\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0003be\u001e\u001c\bcA\u000b\u001eA9\u0011ac\u0007\b\u0003/ii\u0011\u0001\u0007\u0006\u00033)\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005qq\u0011a\u00029bG.\fw-Z\u0005\u0003=}\u00111aU3r\u0015\tab\u0002\u0005\u0002\"I9\u0011QBI\u0005\u0003G9\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111E\u0004\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)b\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001\"B\n(\u0001\u0004!\u0002b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0011G>lW.\u00198e\u0019&tW\r\u0015:paN,\u0012\u0001\r\t\u0003WEJ!A\r\u0002\u0003=\r{W.\\1oI2Kg.Z*dC:tWM]\"p]\u001aLw\rU1sg\u0016\u0014\bB\u0002\u001b\u0001A\u0003%\u0001'A\td_6l\u0017M\u001c3MS:,\u0007K]8qg\u0002BQA\u000e\u0001\u0005\u0002]\n\u0001d\u001d5poZ+'o]5p]R{wm\u001a7f\u000b:\f'\r\\3e+\u0005A\u0004CA\u0007:\u0013\tQdBA\u0004C_>dW-\u00198\t\u000bq\u0002A\u0011A\u001c\u0002+MDwn\u001e%fYB$vnZ4mK\u0016s\u0017M\u00197fI\"Aa\b\u0001EC\u0002\u0013\u0005q(\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0001B\u00111&Q\u0005\u0003\u0005\n\u0011QbU2b]:,'oQ8oM&<\u0007\u0002\u0003#\u0001\u0011\u0003\u0005\u000b\u0015\u0002!\u0002\u000f\r|gNZ5hA!A1\u0001\u0001EC\u0002\u0013%a)F\u0001H!\tY\u0003*\u0003\u0002J\u0005\t91kY1o]\u0016\u0014\b\u0002C&\u0001\u0011\u0003\u0005\u000b\u0015B$\u0002\u0011M\u001c\u0017M\u001c8fe\u0002BQ!\u0014\u0001\u0005\u00029\u000bAa]2b]R\tq\n\u0005\u0002,!&\u0011\u0011K\u0001\u0002\f'\u000e\fgNU3tk2$8oB\u0003T\u0005!\u0005A+A\u0007TG\u0006tg.\u001a:N_\u0012,H.\u001a\t\u0003WU3Q!\u0001\u0002\t\u0002Y\u001b\"!\u0016\u0007\t\u000b!*F\u0011\u0001-\u0015\u0003QCQAW+\u0005\u0002m\u000b\u0001\u0003\u001d:j]R4VM]:j_:LeNZ8\u0015\u0003q\u0003\"!D/\n\u0005ys!\u0001B+oSRDQ\u0001Y+\u0005\u0002\u0005\fA!\\1j]R\u0011AL\u0019\u0005\u0006'}\u0003\ra\u0019\t\u0004\u001b\u0011\u0004\u0013BA3\u000f\u0005\u0015\t%O]1z\u0001")
public final class ScannerModule {
    private final CommandLineScannerConfigParser commandLineProps;
    private ScannerConfig config;
    private Scanner scanner;
    private volatile boolean bitmap$init$0;
    private volatile byte bitmap$0;

    public static void main(String[] stringArray) {
        ScannerModule$.MODULE$.main(stringArray);
    }

    public static void printVersionInfo() {
        ScannerModule$.MODULE$.printVersionInfo();
    }

    private ScannerConfig config$lzycompute() {
        ScannerModule scannerModule = this;
        synchronized (scannerModule) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.config = ClasspathAndCommandLineScannerConfigSource$.MODULE$.config(this.commandLineProps());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.config;
        }
    }

    private Scanner scanner$lzycompute() {
        ScannerModule scannerModule = this;
        synchronized (scannerModule) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Duration.Infinite adapterTimeout = Duration$.MODULE$.Inf();
                Duration.Infinite pmTimeout = Duration$.MODULE$.Inf();
                Poster poster = new Poster(this.config().shrineUrl(), (HttpClient)new JerseyHttpClient((TrustParam)TrustParam.AcceptAllCerts$.MODULE$, (Duration)adapterTimeout, JerseyHttpClient$.MODULE$.apply$default$3(), JerseyHttpClient$.MODULE$.apply$default$4()));
                Set destinations = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NodeHandle[]{new NodeHandle(new NodeId(this.config().shrineUrl()), (AdapterClient)RemoteAdapterClient$.MODULE$.apply(new NodeId(this.config().shrineUrl()), poster, this.config().breakdownTypes()))}));
                KeyStoreCertCollection certCollection = KeyStoreCertCollection$.MODULE$.fromFile(this.config().keystoreDescriptor());
                DefaultSignerVerifier signer = new DefaultSignerVerifier((CertCollection)certCollection);
                HubDao doesNothingHubDao = new HubDao(this){

                    public <T> T inTransaction(Function0<T> f) {
                        return (T)f.apply();
                    }

                    public void logOutboundQuery(long networkQueryId, AuthenticationInfo networkAuthn, QueryDefinition queryDef) {
                    }

                    public void logQueryResult(long networkQueryId, SingleNodeResult result) {
                    }
                };
                SigningBroadcastAndAggregationService broadcastService = new SigningBroadcastAndAggregationService((BroadcasterClient)new InJvmBroadcasterClient((Broadcaster)new AdapterClientBroadcaster(destinations, doesNothingHubDao)), (Signer)signer, SigningCertStrategy$.MODULE$.Attach());
                String pmEndpoint = this.config().pmUrl();
                JerseyHttpClient pmHttpClient = new JerseyHttpClient((TrustParam)TrustParam.AcceptAllCerts$.MODULE$, (Duration)pmTimeout, JerseyHttpClient$.MODULE$.apply$default$3(), JerseyHttpClient$.MODULE$.apply$default$4());
                EcommonsPmAuthenticator authenticator = new EcommonsPmAuthenticator(new Poster(pmEndpoint, (HttpClient)pmHttpClient));
                BroadcastServiceScannerClient client = new BroadcastServiceScannerClient(this.config().projectId(), this.config().authorization(), (BroadcastAndAggregationService)broadcastService, (Authenticator)authenticator, SingleThreadExecutionContext$Implicits$.MODULE$.executionContext());
                FileSystemFormatDetectingAdapterMappingsSource adapterMappingsSource = new FileSystemFormatDetectingAdapterMappingsSource(this.config().adapterMappingsFile());
                ShrineSqlOntologyDao ontologyDao = new ShrineSqlOntologyDao((InputStream)new FileInputStream(this.config().ontologySqlFile()));
                this.scanner = new Scanner(this.config().maxTimeToWaitForResults(), this.config().reScanTimeout(), (AdapterMappingsSource)adapterMappingsSource, (OntologyDao)ontologyDao, client);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.scanner;
        }
    }

    public CommandLineScannerConfigParser commandLineProps() {
        if (this.bitmap$init$0) {
            return this.commandLineProps;
        }
        throw new UninitializedFieldError("Uninitialized field: ScannerModule.scala: 37");
    }

    public boolean showVersionToggleEnabled() {
        return this.commandLineProps().shouldShowVersion();
    }

    public boolean showHelpToggleEnabled() {
        return this.commandLineProps().shouldShowHelp();
    }

    public ScannerConfig config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.config$lzycompute() : this.config;
    }

    private Scanner scanner() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.scanner$lzycompute() : this.scanner;
    }

    public ScanResults scan() {
        try {
            return this.scanner().scan();
        }
        finally {
            SingleThreadExecutionContext$.MODULE$.shutdown();
        }
    }

    public ScannerModule(Seq<String> args) {
        this.commandLineProps = new CommandLineScannerConfigParser(args);
        this.bitmap$init$0 = true;
    }
}

