/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.scanner;

import net.shrine.config.mappings.AdapterMappings;
import net.shrine.config.mappings.AdapterMappingsSource;
import net.shrine.log.Loggable;
import net.shrine.ont.data.OntologyDao;
import net.shrine.ont.messaging.Concept;
import net.shrine.utilities.scanner.QueryFailure;
import net.shrine.utilities.scanner.ScanQueryResult;
import net.shrine.utilities.scanner.ScanResults;
import net.shrine.utilities.scanner.ScanResults$;
import net.shrine.utilities.scanner.Scanner$Termable$;
import net.shrine.utilities.scanner.ScannerClient;
import net.shrine.utilities.scanner.TermResult;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0005-\u0011qaU2b]:,'O\u0003\u0002\u0004\t\u000591oY1o]\u0016\u0014(BA\u0003\u0007\u0003%)H/\u001b7ji&,7O\u0003\u0002\b\u0011\u000511\u000f\u001b:j]\u0016T\u0011!C\u0001\u0004]\u0016$8\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005\u0019An\\4\n\u0005]!\"\u0001\u0003'pO\u001e\f'\r\\3\t\u0011e\u0001!Q1A\u0005\u0002i\ta#\\1y)&lW\rV8XC&$hi\u001c:SKN,H\u000e^\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0001ED\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u0012\u001e\u0005!!UO]1uS>t\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002/5\f\u0007\u0010V5nKR{w+Y5u\r>\u0014(+Z:vYR\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u001bI,7kY1o)&lWm\\;u\u0011!A\u0003A!A!\u0002\u0013Y\u0012A\u0004:f'\u000e\fg\u000eV5nK>,H\u000f\t\u0005\tU\u0001\u0011)\u0019!C\u0001W\u0005)\u0012\rZ1qi\u0016\u0014X*\u00199qS:<7oU8ve\u000e,W#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001C7baBLgnZ:\u000b\u0005E2\u0011AB2p]\u001aLw-\u0003\u00024]\t)\u0012\tZ1qi\u0016\u0014X*\u00199qS:<7oU8ve\u000e,\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002-\u0005$\u0017\r\u001d;fe6\u000b\u0007\u000f]5oON\u001cv.\u001e:dK\u0002B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001O\u0001\f_:$x\u000e\\8hs\u0012\u000bw.F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003eCR\f'B\u0001 \u0007\u0003\ryg\u000e^\u0005\u0003\u0001n\u00121b\u00148u_2|w-\u001f#b_\"A!\t\u0001B\u0001B\u0003%\u0011(\u0001\u0007p]R|Gn\\4z\t\u0006|\u0007\u0005\u0003\u0005E\u0001\t\u0015\r\u0011\"\u0001F\u0003\u0019\u0019G.[3oiV\ta\t\u0005\u0002H\u00116\t!!\u0003\u0002J\u0005\ti1kY1o]\u0016\u00148\t\\5f]RD\u0001b\u0013\u0001\u0003\u0002\u0003\u0006IAR\u0001\bG2LWM\u001c;!\u0011\u0015i\u0005\u0001\"\u0001O\u0003\u0019a\u0014N\\5u}Q1q\nU)S'R\u0003\"a\u0012\u0001\t\u000bea\u0005\u0019A\u000e\t\u000b\u0019b\u0005\u0019A\u000e\t\u000b)b\u0005\u0019\u0001\u0017\t\u000b]b\u0005\u0019A\u001d\t\u000b\u0011c\u0005\u0019\u0001$\t\u000bY\u0003A\u0011A,\u0002\tM\u001c\u0017M\u001c\u000b\u00021B\u0011q)W\u0005\u00035\n\u00111bU2b]J+7/\u001e7ug\")A\f\u0001C\t/\u00061Am\\*dC:DQA\u0018\u0001\u0005\n}\u000b\u0011b\u001c2uC&tg+[1\u0016\u0005\u00014GCA1s!\u0011i!\rZ8\n\u0005\rt!!\u0003$v]\u000e$\u0018n\u001c82!\t)g\r\u0004\u0001\u0005\u000b\u001dl&\u0019\u00015\u0003\u0003Q\u000b\"!\u001b7\u0011\u00055Q\u0017BA6\u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!D7\n\u00059t!aA!osB\u0011q\t]\u0005\u0003c\n\u0011qbU2b]F+XM]=SKN,H\u000e\u001e\u0005\u0006gv\u0003\r\u0001^\u0001\u0004O\u0016$\b\u0003B\u0007cIV\u00042A^<z\u001b\u0005y\u0012B\u0001= \u0005\u00191U\u000f^;sKB\u0011qI_\u0005\u0003w\n\u0011!\u0002V3s[J+7/\u001e7u\u0011\u0015i\b\u0001\"\u0003\u007f\u0003ay'\r^1j]J+7/\u001e7ug\u0006sGMR1jYV\u0014Xm]\u000b\u0004\u007f\u0006%BCBA\u0001\u0003W\t\t\u0004E\u0004\u000e\u0003\u0007\t9!a\b\n\u0007\u0005\u0015aB\u0001\u0004UkBdWM\r\t\u0006\u0003\u0013\tI\"\u001f\b\u0005\u0003\u0017\t)B\u0004\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tBC\u0001\u0007yI|w\u000e\u001e \n\u0003=I1!a\u0006\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0007\u0002\u001e\tA\u0011\n^3sC\ndWMC\u0002\u0002\u00189\u0001b!!\u0003\u0002\u001a\u0005\u0005\u0002#B$\u0002$\u0005\u001d\u0012bAA\u0013\u0005\ta\u0011+^3ss\u001a\u000b\u0017\u000e\\;sKB\u0019Q-!\u000b\u0005\u000b\u001dd(\u0019\u00015\t\u000f\u00055B\u00101\u0001\u00020\u0005)A/\u001a:ngB1\u0011\u0011BA\r\u0003OAq!a\r}\u0001\u0004\t)$\u0001\u0005rk\u0016\u0014\u0018PR8s!\u0015i!-a\np\u0011\u0019a\u0006\u0001\"\u0003\u0002:Q)\u0001,a\u000f\u0002T!A\u0011QHA\u001c\u0001\u0004\ty$\u0001\nnCB\u0004X\r\u001a(fi^|'o\u001b+fe6\u001c\bCBA!\u0003\u000f\niED\u0002\u000e\u0003\u0007J1!!\u0012\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011JA&\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u000br\u0001\u0003BA!\u0003\u001fJA!!\u0015\u0002L\t11\u000b\u001e:j]\u001eD\u0001\"!\u0016\u00028\u0001\u0007\u0011qH\u0001\u001ai\u0016\u0014Xn]#ya\u0016\u001cG/\u001a3U_\n+WK\\7baB,G\rC\u0004\u0002Z\u0001!I!a\u0017\u0002\rI,7kY1o)\u0015A\u0016QLA1\u0011!\ty&a\u0016A\u0002\u0005\u001d\u0011!\t8fm\u0016\u0014h)\u001b8jg\",Gm\u00155pk2$\u0007*\u0019<f\u0005\u0016,g.T1qa\u0016$\u0007\u0002CA2\u0003/\u0002\r!a\u0002\u0002I9,g/\u001a:GS:L7\u000f[3e'\"|W\u000f\u001c3O_RD\u0015M^3CK\u0016tW*\u00199qK\u0012Dq!a\u001a\u0001\t\u0013\tI'A\u0005u_R+'/\\*fiR!\u0011qHA6\u0011!\ti'!\u001aA\u0002\u0005\u001d\u0011a\u0002:fgVdGo\u001d\u0005\b\u0003O\u0002A\u0011BA9+\u0011\t\u0019H!\u000b\u0015\t\u0005U$1\u0006\u000b\u0005\u0003\u007f\t9\b\u0003\u0006\u0002z\u0005=\u0014\u0011!a\u0002\u0003w\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\ti(!$\u0003(9\u0019q)a \b\u000f\u0005\u0005%\u0001#\u0001\u0002\u0004\u000691kY1o]\u0016\u0014\bcA$\u0002\u0006\u001a1\u0011A\u0001E\u0001\u0003\u000f\u001b2!!\"\r\u0011\u001di\u0015Q\u0011C\u0001\u0003\u0017#\"!a!\u0007\u0017\u0005=\u0015Q\u0011I\u0001$\u0003\u0011\u0011\u0011\u0013\u0002\t)\u0016\u0014X.\u00192mKV!\u00111SAQ'\r\ti\t\u0004\u0005\t\u0003/\u000biI\"\u0001\u0002\u001a\u00069q-\u001a;UKJlG\u0003BA'\u00037C\u0001\"!(\u0002\u0016\u0002\u0007\u0011qT\u0001\u0002iB\u0019Q-!)\u0005\r\u001d\fiI1\u0001i\u0011!\t9*!$\u0007\u0002\u0005\u0015F\u0003BA'\u0003OC\u0001\"!(\u0002$\u0002\u0007\u0011\u0011\u0016\t\u0006\u000f\u0006\r\u0012qT\u0004\n\u0003[\u000b)\t#\u0001\u0003\u0003_\u000b\u0001\u0002V3s[\u0006\u0014G.\u001a\t\u0005\u0003c\u000b\u0019,\u0004\u0002\u0002\u0006\u001aI\u0011qRAC\u0011\u0003\u0011\u0011QW\n\u0004\u0003gc\u0001bB'\u00024\u0012\u0005\u0011\u0011\u0018\u000b\u0003\u0003_C!\"!0\u00024\n\u0007I1AA`\u0003A\u0019HO]5oO&\u001bH+\u001a:nC\ndW-\u0006\u0002\u0002BB1\u0011\u0011WAG\u0003\u001bB\u0011\"!2\u00024\u0002\u0006I!!1\u0002#M$(/\u001b8h\u0013N$VM]7bE2,\u0007\u0005\u0003\u0006\u0002J\u0006M&\u0019!C\u0002\u0003\u0017\fA\u0003^3s[J+7/\u001e7u\u0013N$VM]7bE2,WCAAg!\u0015\t\t,!$z\u0011%\t\t.a-!\u0002\u0013\ti-A\u000buKJl'+Z:vYRL5\u000fV3s[\u0006\u0014G.\u001a\u0011\b\u0011\u0005U\u0017Q\u0011E\u0003\u0003/\fQ\"U;fef$UMZ1vYR\u001c\b\u0003BAY\u000334\u0001\"a7\u0002\u0006\"\u0015\u0011Q\u001c\u0002\u000e#V,'/\u001f#fM\u0006,H\u000e^:\u0014\u0007\u0005eG\u0002C\u0004N\u00033$\t!!9\u0015\u0005\u0005]\u0007BCAs\u00033\u0014\r\u0011\"\u0001\u0002h\u00069Ao\u001c9jG&#WCAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\fA\u0001\\1oO*\u0011\u00111_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u00055\b\"CA}\u00033\u0004\u000b\u0011BAu\u0003!!x\u000e]5d\u0013\u0012\u0004\u0003BCA\u007f\u00033\u0014\r\u0011\"\u0001\u0002h\u0006IAo\u001c9jG:\u000bW.\u001a\u0005\n\u0005\u0003\tI\u000e)A\u0005\u0003S\f!\u0002^8qS\u000et\u0015-\\3!\u0011)\u0011)!!7C\u0002\u0013\u0005!qA\u0001\f_V$\b/\u001e;UsB,7/\u0006\u0002\u0003\nA1!1\u0002B\u000b\u0005/i!A!\u0004\u000b\t\t=!\u0011C\u0001\nS6lW\u000f^1cY\u0016T1Aa\u0005\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\u0012i\u0001\u0005\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\r\u0011iBB\u0001\taJ|Go\\2pY&!!\u0011\u0005B\u000e\u0005A\u0011Vm];mi>+H\u000f];u)f\u0004X\rC\u0005\u0003&\u0005e\u0007\u0015!\u0003\u0003\n\u0005aq.\u001e;qkR$\u0016\u0010]3tAA\u0019QM!\u000b\u0005\r\u001d\fyG1\u0001i\u0011!\ti'a\u001cA\u0002\t5\u0002CBA\u0005\u00033\u0011y\u0003E\u0003H\u0003G\u00119\u0003")
public final class Scanner
implements Loggable {
    private final Duration maxTimeToWaitForResult;
    private final Duration reScanTimeout;
    private final AdapterMappingsSource adapterMappingsSource;
    private final OntologyDao ontologyDao;
    private final ScannerClient client;
    private final Logger net$shrine$log$Loggable$$internalLogger;
    private volatile boolean bitmap$0;

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        Scanner scanner = this;
        synchronized (scanner) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.class.net$shrine$log$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$log$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger : this.net$shrine$log$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public Duration maxTimeToWaitForResult() {
        return this.maxTimeToWaitForResult;
    }

    public Duration reScanTimeout() {
        return this.reScanTimeout;
    }

    public AdapterMappingsSource adapterMappingsSource() {
        return this.adapterMappingsSource;
    }

    public OntologyDao ontologyDao() {
        return this.ontologyDao;
    }

    public ScannerClient client() {
        return this.client;
    }

    public ScanResults scan() {
        return this.doScan();
    }

    public ScanResults doScan() {
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shrine Scanner starting";
            }
        });
        Set mappedNetworkTerms = ((AdapterMappings)this.adapterMappingsSource().load("test").get()).networkTerms();
        Set termsExpectedToBeUnmapped = (Set)this.allShrineOntologyTerms$1().$minus$minus((GenTraversableOnce)mappedNetworkTerms);
        this.info((Function0<Object>)new Serializable(this, mappedNetworkTerms, termsExpectedToBeUnmapped){
            public static final long serialVersionUID = 0L;
            private final Set mappedNetworkTerms$1;
            private final Set termsExpectedToBeUnmapped$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We expect ", " to be mapped, and ", " to be unmapped."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mappedNetworkTerms$1.size()), BoxesRunTime.boxToInteger((int)this.termsExpectedToBeUnmapped$1.size())}));
            }
            {
                this.mappedNetworkTerms$1 = mappedNetworkTerms$1;
                this.termsExpectedToBeUnmapped$1 = termsExpectedToBeUnmapped$1;
            }
        });
        return this.doScan((Set<String>)mappedNetworkTerms, (Set<String>)termsExpectedToBeUnmapped);
    }

    private <T> Function1<T, ScanQueryResult> obtainVia(Function1<T, Future<TermResult>> get) {
        return new Serializable(this, get){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Scanner $outer;
            private final Function1 get$1;

            public final ScanQueryResult apply(T input) {
                ScanQueryResult scanQueryResult;
                try {
                    TermResult result = (TermResult)Await$.MODULE$.result((Awaitable)this.get$1.apply(input), this.$outer.maxTimeToWaitForResult());
                    this.$outer.debug((Function0<Object>)new Serializable(this, result, input){
                        public static final long serialVersionUID = 0L;
                        private final TermResult result$1;
                        private final Object input$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Status ", " received, queried for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.result$1.status(), this.input$1}));
                        }
                        {
                            this.result$1 = result$1;
                            this.input$1 = input$1;
                        }
                    });
                    scanQueryResult = result;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.warn((Function0<Object>)new Serializable(this, input){
                        public static final long serialVersionUID = 0L;
                        private final Object input$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error obtaining results for input ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.input$1}));
                        }
                        {
                            this.input$1 = input$1;
                        }
                    }, e);
                    QueryFailure<T> queryFailure = new QueryFailure<T>(input, e);
                    scanQueryResult = queryFailure;
                }
                return scanQueryResult;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.get$1 = get$1;
            }
        };
    }

    private <T> Tuple2<Iterable<TermResult>, Iterable<QueryFailure<T>>> obtainResultsAndFailures(Iterable<T> terms, Function1<T, ScanQueryResult> queryFor) {
        Iterable results = (Iterable)terms.map(queryFor, Iterable$.MODULE$.canBuildFrom());
        return new Tuple2(results.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScanQueryResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TermResult) {
                    TermResult termResult = (TermResult)A1;
                    object = termResult;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScanQueryResult x1) {
                ScanQueryResult scanQueryResult = x1;
                boolean bl = scanQueryResult instanceof TermResult;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom()), results.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ScanQueryResult, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof QueryFailure) {
                    QueryFailure queryFailure = (QueryFailure)A1;
                    object = queryFailure;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ScanQueryResult x2) {
                ScanQueryResult scanQueryResult = x2;
                boolean bl = scanQueryResult instanceof QueryFailure;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private ScanResults doScan(Set<String> mappedNetworkTerms, Set<String> termsExpectedToBeUnmapped) {
        Function1 queryFor = this.obtainVia((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Scanner $outer;

            public final Future<TermResult> apply(String term) {
                return this.$outer.client().query(term);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Tuple2<Iterable<TermResult>, Iterable<QueryFailure<String>>> tuple2 = this.obtainResultsAndFailures((Iterable)mappedNetworkTerms, queryFor);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable resultsForMappedTerms = (Iterable)tuple2._1();
            Iterable failuresForMappedTerms = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)resultsForMappedTerms, (Object)failuresForMappedTerms);
            Iterable resultsForMappedTerms2 = (Iterable)tuple23._1();
            Iterable failuresForMappedTerms2 = (Iterable)tuple23._2();
            Tuple2<Iterable<TermResult>, Iterable<QueryFailure<String>>> tuple24 = this.obtainResultsAndFailures((Iterable)termsExpectedToBeUnmapped, queryFor);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Iterable resultsForUnMappedTerms = (Iterable)tuple24._1();
                Iterable failuresForUnMappedTerms = (Iterable)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)resultsForUnMappedTerms, (Object)failuresForUnMappedTerms);
                Iterable resultsForUnMappedTerms2 = (Iterable)tuple26._1();
                Iterable failuresForUnMappedTerms2 = (Iterable)tuple26._2();
                Tuple2 tuple27 = resultsForMappedTerms2.partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TermResult x$4) {
                        return x$4.status().isDone();
                    }
                });
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Iterable finishedAndShouldHaveBeenMapped = (Iterable)tuple27._1();
                    Iterable didntFinishAndShouldHaveBeenMapped = (Iterable)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)finishedAndShouldHaveBeenMapped, (Object)didntFinishAndShouldHaveBeenMapped);
                    Iterable finishedAndShouldHaveBeenMapped2 = (Iterable)tuple29._1();
                    Iterable didntFinishAndShouldHaveBeenMapped2 = (Iterable)tuple29._2();
                    Tuple2 tuple210 = resultsForUnMappedTerms2.partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(TermResult x$6) {
                            return x$6.status().isDone();
                        }
                    });
                    if (tuple210 != null) {
                        Tuple2 tuple211;
                        Iterable finishedAndShouldNotHaveBeenMapped = (Iterable)tuple210._1();
                        Iterable didntFinishAndShouldNotHaveBeenMapped = (Iterable)tuple210._2();
                        Tuple2 tuple212 = tuple211 = new Tuple2((Object)finishedAndShouldNotHaveBeenMapped, (Object)didntFinishAndShouldNotHaveBeenMapped);
                        Iterable finishedAndShouldNotHaveBeenMapped2 = (Iterable)tuple212._1();
                        Iterable didntFinishAndShouldNotHaveBeenMapped2 = (Iterable)tuple212._2();
                        Iterable shouldHaveBeenMapped = (Iterable)finishedAndShouldHaveBeenMapped2.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TermResult x$8) {
                                return x$8.status().isError();
                            }
                        });
                        Iterable shouldNotHaveBeenMapped = (Iterable)finishedAndShouldNotHaveBeenMapped2.filterNot((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TermResult x$9) {
                                return x$9.status().isError();
                            }
                        });
                        ScanResults reScanResults = this.reScan((Iterable<TermResult>)didntFinishAndShouldHaveBeenMapped2, (Iterable<TermResult>)didntFinishAndShouldNotHaveBeenMapped2);
                        Set finalSouldHaveBeenMappedSet = (Set)this.toTermSet((Iterable<TermResult>)shouldHaveBeenMapped).$plus$plus(reScanResults.shouldHaveBeenMapped());
                        Set finalSouldNotHaveBeenMappedSet = (Set)this.toTermSet((Iterable<TermResult>)shouldNotHaveBeenMapped).$plus$plus(reScanResults.shouldNotHaveBeenMapped());
                        Set failed = (Set)this.toTermSet((Iterable)failuresForMappedTerms2.$plus$plus((GenTraversableOnce)failuresForUnMappedTerms2, Iterable$.MODULE$.canBuildFrom()), Scanner$Termable$.MODULE$.stringIsTermable()).$plus$plus(reScanResults.failed());
                        return new ScanResults((Set<String>)finalSouldHaveBeenMappedSet, (Set<String>)finalSouldNotHaveBeenMappedSet, reScanResults.neverFinished(), (Set<String>)failed);
                    }
                    throw new MatchError((Object)tuple210);
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private ScanResults reScan(Iterable<TermResult> neverFinishedShouldHaveBeenMapped, Iterable<TermResult> neverFinishedShouldNotHaveBeenMapped) {
        Tuple2<Iterable<TermResult>, Iterable<QueryFailure<TermResult>>> tuple2;
        block4: {
            Tuple2<Iterable<TermResult>, Iterable<QueryFailure<TermResult>>> tuple22;
            block5: {
                Tuple2 tuple23;
                block6: {
                    Tuple2 tuple24;
                    block7: {
                        ScanResults scanResults;
                        block3: {
                            Tuple2 tuple25;
                            Tuple2 tuple26;
                            Tuple2 tuple27;
                            Tuple2 tuple28;
                            block2: {
                                if (!neverFinishedShouldHaveBeenMapped.isEmpty() || !neverFinishedShouldNotHaveBeenMapped.isEmpty()) break block2;
                                scanResults = ScanResults$.MODULE$.empty();
                                break block3;
                            }
                            int total = neverFinishedShouldHaveBeenMapped.size() + neverFinishedShouldNotHaveBeenMapped.size();
                            this.info((Function0<Object>)new Serializable(this, total){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Scanner $outer;
                                private final int total$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " before retreiving results for ", " incomplete queries..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.reScanTimeout(), BoxesRunTime.boxToInteger((int)this.total$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.total$1 = total$1;
                                }
                            });
                            Thread.sleep(this.reScanTimeout().toMillis());
                            Function1 retrieve = this.obtainVia((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ Scanner $outer;

                                public final Future<TermResult> apply(TermResult termResult) {
                                    return this.$outer.client().retrieveResults(termResult);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            tuple2 = this.obtainResultsAndFailures(neverFinishedShouldHaveBeenMapped, retrieve);
                            if (tuple2 == null) break block4;
                            Iterable neverFinishedShouldHaveBeenMappedRetries = (Iterable)tuple2._1();
                            Iterable failedShouldHaveBeenMappedRetries = (Iterable)tuple2._2();
                            Tuple2 tuple29 = tuple28 = new Tuple2((Object)neverFinishedShouldHaveBeenMappedRetries, (Object)failedShouldHaveBeenMappedRetries);
                            Iterable neverFinishedShouldHaveBeenMappedRetries2 = (Iterable)tuple29._1();
                            Iterable failedShouldHaveBeenMappedRetries2 = (Iterable)tuple29._2();
                            tuple22 = this.obtainResultsAndFailures(neverFinishedShouldNotHaveBeenMapped, retrieve);
                            if (tuple22 == null) break block5;
                            Iterable neverFinishedShouldNotHaveBeenMappedRetries = (Iterable)tuple22._1();
                            Iterable failedShouldNotHaveBeenMappedRetries = (Iterable)tuple22._2();
                            Tuple2 tuple210 = tuple27 = new Tuple2((Object)neverFinishedShouldNotHaveBeenMappedRetries, (Object)failedShouldNotHaveBeenMappedRetries);
                            Iterable neverFinishedShouldNotHaveBeenMappedRetries2 = (Iterable)tuple210._1();
                            Iterable failedShouldNotHaveBeenMappedRetries2 = (Iterable)tuple210._2();
                            tuple23 = neverFinishedShouldHaveBeenMappedRetries2.partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$12) {
                                    return x$12.status().isDone();
                                }
                            });
                            if (tuple23 == null) break block6;
                            Iterable doneShouldHaveBeenMapped = (Iterable)tuple23._1();
                            Iterable stillNotFinishedShouldHaveBeenMapped = (Iterable)tuple23._2();
                            Tuple2 tuple211 = tuple26 = new Tuple2((Object)doneShouldHaveBeenMapped, (Object)stillNotFinishedShouldHaveBeenMapped);
                            Iterable doneShouldHaveBeenMapped2 = (Iterable)tuple211._1();
                            Iterable stillNotFinishedShouldHaveBeenMapped2 = (Iterable)tuple211._2();
                            tuple24 = neverFinishedShouldNotHaveBeenMappedRetries2.partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$14) {
                                    return x$14.status().isDone();
                                }
                            });
                            if (tuple24 == null) break block7;
                            Iterable doneShouldNotHaveBeenMapped = (Iterable)tuple24._1();
                            Iterable stillNotFinishedShouldNotHaveBeenMapped = (Iterable)tuple24._2();
                            Tuple2 tuple212 = tuple25 = new Tuple2((Object)doneShouldNotHaveBeenMapped, (Object)stillNotFinishedShouldNotHaveBeenMapped);
                            Iterable doneShouldNotHaveBeenMapped2 = (Iterable)tuple212._1();
                            Iterable stillNotFinishedShouldNotHaveBeenMapped2 = (Iterable)tuple212._2();
                            Iterable shouldHaveBeenMapped = (Iterable)doneShouldHaveBeenMapped2.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$16) {
                                    return x$16.status().isError();
                                }
                            });
                            Iterable shouldNotHaveBeenMapped = (Iterable)doneShouldNotHaveBeenMapped2.filterNot((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TermResult x$17) {
                                    return x$17.status().isError();
                                }
                            });
                            Iterable stillNotFinished = (Iterable)stillNotFinishedShouldHaveBeenMapped2.$plus$plus((GenTraversableOnce)stillNotFinishedShouldNotHaveBeenMapped2, Iterable$.MODULE$.canBuildFrom());
                            Iterable failed = (Iterable)failedShouldHaveBeenMappedRetries2.$plus$plus((GenTraversableOnce)failedShouldNotHaveBeenMappedRetries2, Iterable$.MODULE$.canBuildFrom());
                            scanResults = new ScanResults(this.toTermSet((Iterable<TermResult>)shouldHaveBeenMapped), this.toTermSet((Iterable<TermResult>)shouldNotHaveBeenMapped), this.toTermSet((Iterable<TermResult>)stillNotFinished), this.toTermSet(failed, Scanner$Termable$.MODULE$.termResultIsTermable()));
                        }
                        return scanResults;
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple23);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    private Set<String> toTermSet(Iterable<TermResult> results) {
        return ((TraversableOnce)results.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TermResult x$18) {
                return x$18.term();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private <T> Set<String> toTermSet(Iterable<QueryFailure<T>> results, Termable<T> evidence$1) {
        Termable termable = (Termable)Predef$.MODULE$.implicitly(evidence$1);
        return ((TraversableOnce)results.map((Function1)new Serializable(this, termable){
            public static final long serialVersionUID = 0L;
            private final Termable eta$0$1$1;

            public final String apply(QueryFailure<T> t) {
                return this.eta$0$1$1.getTerm(t);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private final Set allShrineOntologyTerms$1() {
        return ((TraversableOnce)this.ontologyDao().ontologyEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Concept x$1) {
                return x$1.path();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public Scanner(Duration maxTimeToWaitForResult, Duration reScanTimeout, AdapterMappingsSource adapterMappingsSource, OntologyDao ontologyDao, ScannerClient client) {
        this.maxTimeToWaitForResult = maxTimeToWaitForResult;
        this.reScanTimeout = reScanTimeout;
        this.adapterMappingsSource = adapterMappingsSource;
        this.ontologyDao = ontologyDao;
        this.client = client;
        Loggable.class.$init$((Loggable)this);
    }

    public static interface Termable<T> {
        public String getTerm(T var1);

        public String getTerm(QueryFailure<T> var1);
    }
}

