-- When upgrading from shrine2.0 to shrine3.0 run this script to update the shrine_query_history database
use shrine_query_history;

drop index "ix_HUB_QUERY_RESULT_network_query_id" on "HUB_QUERY_RESULT";
drop index "ix_HUB_QUERY_RESULT_network_query_id_node_name" on "HUB_QUERY_RESULT";

drop table "HUB_QUERY";
drop table "HUB_QUERY_RESULT";

drop index "IDX_AUDIT_ENTRY_DOMAIN_USERNAME_QUERY_TOPIC" on "AUDIT_ENTRY";
drop table "AUDIT_ENTRY";

-- some usernames and domains were swapped by shrine 2.0.0
exec sp_addlinkedserver @server = 'adapterAuditDB';
update SHRINE_QUERY set username = domain, domain = username where username not in (select distinct(CAST(userName as varchar(8000))) from adapterAuditDB.dbo.queriesReceived);
