-- Working tables in shrine_query_history */
use shrine_query_history;

create table "ADAPTER_MAPPING" ("SHRINE_KEY" VARCHAR(700) NOT NULL,"ADAPTER_KEY" VARCHAR(700) NOT NULL); -- 700 max length of i2b2 ontology term path
create table "ADAPTER_MAPPING_META" ("FILENAME" VARCHAR(255) NOT NULL,"FILE_LAST_MODIFIED" BIGINT NOT NULL,"LOADED_FROM_FILE" BIGINT NOT NULL,"CHECKSUM" BIGINT NOT NULL);
create index "IX_ADAPTER_MAPPING_LOOKUP" on "ADAPTER_MAPPING"("SHRINE_KEY");

create table SHRINE_QUERY(
  [id] [int] not null IDENTITY(1,1),
  local_id [varchar](255) not null,
  network_id bigint not null,
  username [varchar](255) not null,
  domain [varchar](255) not null,
  query_name [varchar](255) not null,
  query_expression text,
  date_created datetime default current_timestamp,
  has_been_run bit not null default 0,
  flagged bit not null default 0,
  flag_message [varchar](MAX) null,
  constraint query_id_pk primary key clustered (id asc),
  query_xml text
);
CREATE NONCLUSTERED INDEX [ix_SHRINE_QUERY_network_id] ON [dbo].[SHRINE_QUERY] ([network_id] ASC);
CREATE NONCLUSTERED INDEX [ix_SHRINE_QUERY_local_id] ON [dbo].[SHRINE_QUERY] ([local_id] ASC);
CREATE NONCLUSTERED INDEX [ix_SHRINE_QUERY_username_domain] ON [dbo].[SHRINE_QUERY] (username, domain ASC);

create table QUERY_RESULT(
  id int not null identity(1,1),
  local_id varchar(255) not null,
  query_id int not null,
  type varchar(100) not null,
  [status] varchar(30) not null,
  time_elapsed int null,
  last_updated datetime default current_timestamp,
  constraint QUERY_RESULT_id_pk primary key(id),
  constraint fk_QUERY_RESULT_query_id foreign key (query_id) references SHRINE_QUERY (id) on delete cascade
);

create table ERROR_RESULT(
  id int not null identity(1,1),
  result_id int not null,
  message varchar(255) not null,
  CODEC text not null default 'Pre-1.20 Error',
  SUMMARY text not null default 'Pre-1.20 Error',
  PROBLEM_DESCRIPTION text not null default 'Pre-1.20 Error',
  DETAILS text not null default 'Pre-1.20 Error',
  STAMP text not null default 'Unknown time and machine',
  constraint ERROR_RESULT_id_pk primary key(id),
  constraint fk_ERROR_RESULT_QUERY_RESULT_id foreign key (result_id) references QUERY_RESULT (id) on delete cascade
);

create table COUNT_RESULT(
  id int not null identity(1,1),
  result_id int not null,
  obfuscated_count int not null,
  date_created datetime default current_timestamp,
  constraint COUNT_RESULT_id_pk primary key(id),
  constraint fk_COUNT_RESULT_QUERY_RESULT_id foreign key (result_id) references QUERY_RESULT (id) on delete cascade
);

create table BREAKDOWN_RESULT(
  id int not null identity(1,1),
  result_id int not null,
  data_key varchar(255) null,
  obfuscated_value int not null,
  constraint BREAKDOWN_RESULT_id_pk primary key(id),
  constraint fk_BREAKDOWN_RESULT_QUERY_RESULT_id foreign key (result_id) references QUERY_RESULT (id) on delete cascade
);