use qepAuditDB;

create table "QUERY_SENT" (
    "SHRINE_NODE_ID" VARCHAR(MAX) NOT NULL,
    "USER_NAME" VARCHAR(MAX) NOT NULL,
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "QUERY_NAME" VARCHAR(MAX) NOT NULL,
    "TIME_QUERY_SENT" BIGINT NOT NULL
);

create table "PREVIOUS_QUERY" (
    "NETWORK_ID" BIGINT NOT NULL,
    "USER_NAME" VARCHAR(MAX) NOT NULL,
    "DOMAIN" VARCHAR(MAX) NOT NULL,
    "QUERY_NAME" VARCHAR(MAX) NOT NULL,
    "QUERY_NOTES" VARCHAR(MAX),
    "QUERY_FAVED" BIT NOT NULL,
    "DATE_CREATED" BIGINT NOT NULL,
    "DELETED" BIT NOT NULL,
    "CHANGE_DATE" BIGINT NOT NULL,
    "STATUS" VARCHAR(MAX) NOT NULL,
    "QUERY_JSON" VARCHAR(MAX) not null
);

create table "QUERY_RESULT" (
    "RESULT_ID" BIGINT NOT NULL,
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "INSTANCE_ID" BIGINT NOT NULL,
    "ADAPTER_NODE" VARCHAR(MAX) NOT NULL,
    "RESULT_TYPE" VARCHAR(MAX),
    "SIZE" BIGINT NOT NULL,
    "START_DATE" BIGINT,
    "END_DATE" BIGINT,
    "STATUS" VARCHAR(MAX) NOT NULL,
    "STATUS_MESSAGE" VARCHAR(MAX),
    "CHANGE_DATE" BIGINT NOT NULL
);

create table "QUERY_BREAKDOWN_RESULT" (
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "ADAPTER_NODE" VARCHAR(MAX) NOT NULL,
    "RESULT_ID" BIGINT NOT NULL,
    "RESULT_TYPE" VARCHAR(MAX) NOT NULL,
    "DATA_KEY" VARCHAR(MAX) NULL,
    "VALUE" BIGINT NOT NULL,
    "CHANGE_DATE" BIGINT NOT NULL
);

create table "QUERY_RESULT_PROBLEM_DIGEST" (
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "ADAPTER_NODE" VARCHAR(MAX) NOT NULL,
    "CODEC" VARCHAR(MAX) NOT NULL,
    "STAMP" VARCHAR(MAX) NOT NULL,
    "SUMMARY" VARCHAR(MAX) NOT NULL,
    "DESCRIPTION" VARCHAR(MAX) NOT NULL,
    "DETAILS" VARCHAR(MAX) NOT NULL,
    "CHANGE_DATE" BIGINT NOT NULL
);

create table "RESULTS_OBSERVED" (
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "CHECKSUM" BIGINT NOT NULL,
    "OBSERVED_TIME" BIGINT NOT NULL
);

create table "QUERY_PROBLEM_DIGEST" (
    "NETWORK_QUERY_ID" BIGINT NOT NULL,
    "CODEC" VARCHAR(MAX) NOT NULL,
    "STAMP" VARCHAR(MAX) NOT NULL,
    "SUMMARY" VARCHAR(MAX) NOT NULL,
    "DESCRIPTION" VARCHAR(MAX) NOT NULL,
    "DETAILS" VARCHAR(MAX) NOT NULL,
    "CHANGE_DATE" BIGINT NOT NULL
);

create index "queryResultsChangeDateIndex" on "QUERY_RESULT" ("CHANGE_DATE");
create index "queryResultsNetworkQueryIdIndex" on "QUERY_RESULT" ("NETWORK_QUERY_ID");
-- create index "queryResultsAdapterNodeIndex" on "QUERY_RESULT" ("ADAPTER_NODE");
create index "queryResultsResultIdIndex" on "QUERY_RESULT" ("RESULT_ID");

create index "queryBreakdownResultsChangeDateIndex" on "QUERY_BREAKDOWN_RESULT" ("CHANGE_DATE");
create index "queryBreakdownResultsNetworkQueryIdIndex" on "QUERY_BREAKDOWN_RESULT" ("NETWORK_QUERY_ID");
-- create index "queryBreakdownResultsAdapterNodeIndex" on "QUERY_BREAKDOWN_RESULT" ("ADAPTER_NODE");
create index "queryBreakdownResultsResultIdIndex" on "QUERY_BREAKDOWN_RESULT" ("RESULT_ID");

create index "previousQueriesQueryFavedIndex" on "PREVIOUS_QUERY" ("QUERY_FAVED");
-- create index "previousQueriesUserNameIndex" on "PREVIOUS_QUERY" ("USER_NAME");
-- create index "previousQueriesDomainIndex" on "PREVIOUS_QUERY" ("DOMAIN");
create index "previousQueriesChangeDateIndex" on "PREVIOUS_QUERY" ("CHANGE_DATE");
create index "previousQueriesDeletedIndex" on "PREVIOUS_QUERY" ("DELETED");
create index "previousQueriesNetworkIdIndex" on "PREVIOUS_QUERY" ("NETWORK_ID");
create index "previousQueriesDateCreatedIndex" on "PREVIOUS_QUERY" ("DATE_CREATED");

create index "problemsNetworkIdIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("NETWORK_QUERY_ID");
-- create index "problemsAdapterNodeIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("ADAPTER_NODE");
create index "problemsChangeDateIndex" on "QUERY_RESULT_PROBLEM_DIGEST" ("CHANGE_DATE");

create index "resultsObservedQueryIdIndex" on "RESULTS_OBSERVED" ("NETWORK_QUERY_ID");
create index "resultsObservedChecksumIndex" on "RESULTS_OBSERVED" ("CHECKSUM");

create index "queryProblemsNetworkIdIndex" on "QUERY_PROBLEM_DIGEST" ("NETWORK_QUERY_ID");
