use qepAuditDB;

create table `QUERY_SENT` (
    `SHRINE_NODE_ID` TEXT NOT NULL,
    `USER_NAME` TEXT NOT NULL,
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `QUERY_NAME` TEXT NOT NULL,
    `TIME_QUERY_SENT` BIGINT NOT NULL
);

create table `PREVIOUS_QUERY` (
    `NETWORK_ID` BIGINT NOT NULL,
    `USER_NAME` TEXT NOT NULL,
    `DOMAIN` TEXT NOT NULL,
    `QUERY_NAME` TEXT NOT NULL,
    `QUERY_NOTES` TEXT,
    `QUERY_FAVED` BOOLEAN NOT NULL,
    `DATE_CREATED` BIGINT NOT NULL,
    `DELETED` BOOLEAN NOT NULL,
    `CHANGE_DATE` BIGINT NOT NULL,
    `STATUS` VARCHAR(255) NOT NULL ,
    `QUERY_JSON` TEXT not null
);

create table `QUERY_RESULT` (
    `RESULT_ID` BIGINT NOT NULL,
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `INSTANCE_ID` BIGINT NOT NULL,
    `ADAPTER_NODE` TEXT NOT NULL,
    `RESULT_TYPE` TEXT,
    `SIZE` BIGINT NOT NULL,
    `START_DATE` BIGINT,
    `END_DATE` BIGINT,
    `STATUS` TEXT NOT NULL,
    `STATUS_MESSAGE` TEXT,
    `CHANGE_DATE` BIGINT NOT NULL
);

create table `QUERY_BREAKDOWN_RESULT` (
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `ADAPTER_NODE` TEXT NOT NULL,
    `RESULT_ID` BIGINT NOT NULL,
    `RESULT_TYPE` TEXT NOT NULL,
    `DATA_KEY` TEXT NULL,
    `VALUE` BIGINT NOT NULL,
    `CHANGE_DATE` BIGINT NOT NULL
);

create table `QUERY_RESULT_PROBLEM_DIGEST` (
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `ADAPTER_NODE` TEXT NOT NULL,
    `CODEC` TEXT NOT NULL,
    `STAMP` TEXT NOT NULL,
    `SUMMARY` TEXT NOT NULL,
    `DESCRIPTION` TEXT NOT NULL,
    `DETAILS` TEXT NOT NULL,
    `CHANGE_DATE` BIGINT NOT NULL
);

create table `RESULTS_OBSERVED` (
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `CHECKSUM` BIGINT NOT NULL,
    `OBSERVED_TIME` BIGINT NOT NULL
);
create table `QUERY_PROBLEM_DIGEST` (
    `NETWORK_QUERY_ID` BIGINT NOT NULL,
    `CODEC` TEXT NOT NULL,
    `STAMP` TEXT NOT NULL,
    `SUMMARY` TEXT NOT NULL,
    `DESCRIPTION` TEXT NOT NULL,
    `DETAILS` TEXT NOT NULL,
    `CHANGE_DATE` BIGINT NOT NULL
);

create index queryResultsChangeDateIndex on QUERY_RESULT (CHANGE_DATE);
create index queryResultsNetworkQueryIdIndex on QUERY_RESULT (NETWORK_QUERY_ID);
create index queryResultsAdapterNodeIndex on QUERY_RESULT (ADAPTER_NODE(255));
create index queryResultsResultIdIndex on QUERY_RESULT (RESULT_ID);
create index queryResultsStatusIndex on QUERY_RESULT (STATUS(255));

create index queryBreakdownResultsChangeDateIndex on QUERY_BREAKDOWN_RESULT (CHANGE_DATE);
create index queryBreakdownResultsNetworkQueryIdIndex on QUERY_BREAKDOWN_RESULT (NETWORK_QUERY_ID);
create index queryBreakdownResultsAdapterNodeIndex on QUERY_BREAKDOWN_RESULT (ADAPTER_NODE(255));
create index queryBreakdownResultsResultIdIndex on QUERY_BREAKDOWN_RESULT (RESULT_ID);

create index previousQueriesQueryFavedIndex on PREVIOUS_QUERY (QUERY_FAVED);
create index previousQueriesUserNameIndex on PREVIOUS_QUERY (USER_NAME(255));
create index previousQueriesDomainIndex on PREVIOUS_QUERY (DOMAIN(255));
create index previousQueriesChangeDateIndex on PREVIOUS_QUERY (CHANGE_DATE);
create index previousQueriesDeletedIndex on PREVIOUS_QUERY (DELETED);
create index previousQueriesNetworkIdIndex on PREVIOUS_QUERY (NETWORK_ID);
create index previousQueriesDateCreatedIndex on PREVIOUS_QUERY (DATE_CREATED);

create index problemsNetworkIdIndex on QUERY_RESULT_PROBLEM_DIGEST(NETWORK_QUERY_ID);
create index problemsAdapterNodeIndex on QUERY_RESULT_PROBLEM_DIGEST(ADAPTER_NODE(255));
create index problemsChangeDateIndex on QUERY_RESULT_PROBLEM_DIGEST(CHANGE_DATE);

create index resultsObservedQueryIdIndex on RESULTS_OBSERVED(NETWORK_QUERY_ID);
create index resultsObservedChecksumIndex on RESULTS_OBSERVED(CHECKSUM);

create index queryProblemsNetworkIdIndex on QUERY_PROBLEM_DIGEST(NETWORK_QUERY_ID);
