/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.log;

import net.shrine.log.LogCensor$;
import org.http4s.BasicCredentials;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i2A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0001;!)!\u0007\u0001C\u0001;!)A\u0007\u0001C\u0001;!)a\u0007\u0001C\u0001;!)\u0001\b\u0001C\u0001;\tiAj\\4DK:\u001cxN\u001d+fgRT!a\u0003\u0007\u0002\u00071|wM\u0003\u0002\u000e\u001d\u000511\u000f\u001b:j]\u0016T\u0011aD\u0001\u0004]\u0016$8\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\u000b\u00039!Xm\u001d;DK:\u001cxN]%3EJ\"\u0012A\b\t\u0003'}I!\u0001\t\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\t\u0002\"a\t\u0017\u000e\u0003\u0011R!!\n\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002(Q\u00059!.\u001e9ji\u0016\u0014(BA\u0015+\u0003\u0015QWO\\5u\u0015\u0005Y\u0013aA8sO&\u0011Q\u0006\n\u0002\u0005)\u0016\u001cH/A\fuKN$8)\u001a8t_JL%G\u0019\u001aDe\u000e\u0014Vm];mi\"\u00121AI\u0001\u001ci\u0016\u001cHoQ3og>\u0014()Y:jG\u0006+H\u000f[,ji\"luN]3)\u0005\u0011\u0011\u0013a\u0006;fgR\u001cUM\\:pe\n\u000b7/[2BkRDG*Y:uQ\t)!%\u0001\u0011uKN$8)\u001a8t_J$\u0016\u0010]3tC\u001a,7i\u001c8gS\u001e\u0004\u0016m]:x_J$\u0007F\u0001\u0004#\u0003\r\"Xm\u001d;DK:\u001cxN\u001d+za\u0016\u001c\u0018MZ3D_:4\u0017nZ)faB\u000b7o]<pe\u0012D#a\u0002\u0012\u00025Q,7\u000f^\"f]N|'OQ1tS\u000e\u001c%/\u001a3f]RL\u0017\r\\:)\u0005!\u0011\u0003")
public class LogCensorTest {
    @Test
    public void testCensorI2b2() {
        String i2b2PasswordString = "<password is_token=\"false\" token_ms_timeout=\"1800000\">kapow</password>";
        String expectedI2b2PasswordString = "<password is_token=\"false\" token_ms_timeout=\"1800000\">REDACTED</password>";
        String result = LogCensor$.MODULE$.censor(i2b2PasswordString);
        Assertions.assertEquals((Object)expectedI2b2PasswordString, (Object)result);
    }

    @Test
    public void testCensorI2b2CrcResult() {
        String i2b2CountString = "<set_size>239</set_size>";
        String expectedI2b2CountString = "<set_size>REDACTED</set_size>";
        String result = LogCensor$.MODULE$.censor(i2b2CountString);
        Assertions.assertEquals((Object)expectedI2b2CountString, (Object)result);
    }

    @Test
    public void testCensorBasicAuthWithMore() {
        String basicAuthLine = "HttpRequest(GET,https://shrine-qa1.hms.harvard.edu:6443/qep/approvedTopics/user/shrine,List(Host: shrine-qa1.hms.harvard.edu:6443, Authorization: Basic cWVwOnRydXN0bWU=, User-Agent: spray-can/1.3.3),Empty,HTTP/1.1)";
        String expectedBasicAuthLine = "HttpRequest(GET,https://shrine-qa1.hms.harvard.edu:6443/qep/approvedTopics/user/shrine,List(Host: shrine-qa1.hms.harvard.edu:6443, Authorization: Basic REDACTED, User-Agent: spray-can/1.3.3),Empty,HTTP/1.1)";
        String result = LogCensor$.MODULE$.censor(basicAuthLine);
        Assertions.assertEquals((Object)expectedBasicAuthLine, (Object)result);
    }

    @Test
    public void testCensorBasicAuthLast() {
        String basicAuthLine = "Request: HttpRequest(POST,http://example.com/steward/rejectTopic/topic/1,List(Authorization: Basic ZGF2ZTprYWJsYW0=),Empty,HTTP/1.1)";
        String expectedBasicAuthLine = "Request: HttpRequest(POST,http://example.com/steward/rejectTopic/topic/1,List(Authorization: Basic REDACTED),Empty,HTTP/1.1)";
        String result = LogCensor$.MODULE$.censor(basicAuthLine);
        Assertions.assertEquals((Object)expectedBasicAuthLine, (Object)result);
    }

    @Test
    public void testCensorTypesafeConfigPassword() {
        String typesafeConfigLine = "\"password\" : \"flarf\",";
        String expectedTypesafeConfigLine = "\"password\" : \"REDACTED\",";
        String result = LogCensor$.MODULE$.censor(typesafeConfigLine);
        Assertions.assertEquals((Object)expectedTypesafeConfigLine, (Object)result);
    }

    @Test
    public void testCensorTypesafeConfigQepPassword() {
        String typesafeConfigLine = "\"qepPassword\" : \"flarf\",";
        String expectedTypesafeConfigLine = "\"qepPassword\" : \"REDACTED\",";
        String result = LogCensor$.MODULE$.censor(typesafeConfigLine);
        Assertions.assertEquals((Object)expectedTypesafeConfigLine, (Object)result);
    }

    @Test
    public void testCensorBasicCredentials() {
        String basicCredentialsString = new BasicCredentials("username", "password").toString();
        String expectedString = "BasicCredentials(username,REDACTED)";
        String result = LogCensor$.MODULE$.censor(basicCredentialsString);
        Assertions.assertEquals((Object)expectedString, (Object)result);
    }
}

